/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.sound3d;

import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.java.games.joal.AL;
import net.java.games.joal.ALC;
import net.java.games.joal.ALCcontext;
import net.java.games.joal.ALCdevice;
import net.java.games.joal.ALException;
import net.java.games.joal.ALFactory;
import net.java.games.joal.util.WAVData;
import net.java.games.joal.util.WAVLoader;
import net.java.games.sound3d.Buffer;
import net.java.games.sound3d.Context;
import net.java.games.sound3d.Device;
import net.java.games.sound3d.Listener;
import net.java.games.sound3d.Source;

public class AudioSystem3D {
    private static AL al;
    private static ALC alc;
    private static Listener listener;

    public static void init() throws ALException {
        al = ALFactory.getAL();
        alc = ALFactory.getALC();
    }

    public static Context createContext(Device device) {
        Context context = null;
        ALCcontext aLCcontext = alc.alcCreateContext(device.realDevice, null);
        context = new Context(alc, aLCcontext, device);
        return context;
    }

    public static void makeContextCurrent(Context context) {
        ALCcontext aLCcontext = null;
        if (context != null) {
            aLCcontext = context.realContext;
        }
        alc.alcMakeContextCurrent(aLCcontext);
    }

    public static Device openDevice(String string) {
        Device device = null;
        ALCdevice aLCdevice = alc.alcOpenDevice(string);
        device = new Device(alc, aLCdevice);
        return device;
    }

    public static Buffer[] generateBuffers(int n) {
        Buffer[] bufferArray = new Buffer[n];
        int[] nArray = new int[n];
        al.alGenBuffers(n, nArray, 0);
        for (int i = 0; i < n; ++i) {
            bufferArray[i] = new Buffer(al, nArray[i]);
        }
        return bufferArray;
    }

    public static Buffer loadBuffer(String string) throws IOException, UnsupportedAudioFileException {
        Buffer[] bufferArray = AudioSystem3D.generateBuffers(1);
        Buffer buffer = bufferArray[0];
        WAVData wAVData = WAVLoader.loadFromFile(string);
        buffer.configure(wAVData.data, wAVData.format, wAVData.freq);
        return buffer;
    }

    public static Source loadSource(String string) throws IOException, UnsupportedAudioFileException {
        Buffer buffer = AudioSystem3D.loadBuffer(string);
        return AudioSystem3D.generateSource(buffer);
    }

    public static Source[] generateSources(int n) {
        Source[] sourceArray = new Source[n];
        int[] nArray = new int[n];
        al.alGenSources(n, nArray, 0);
        for (int i = 0; i < n; ++i) {
            sourceArray[i] = new Source(al, nArray[i]);
        }
        return sourceArray;
    }

    public static Source generateSource(Buffer buffer) {
        Source source = null;
        Source[] sourceArray = AudioSystem3D.generateSources(1);
        source = sourceArray[0];
        source.setBuffer(buffer);
        return source;
    }

    public static Listener getListener() {
        if (listener == null) {
            listener = new Listener(al);
        }
        return listener;
    }
}

