/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.em3d.core.AbstractObject;
import org.openmali.vecmath2.Colorf;

public class CuesObject
extends AbstractObject {
    List<String> locations;
    Iterator<String> locationIterator;
    boolean moving;
    float speed;

    public CuesObject(String name, boolean moving, float speed, String model, float scale, float rotX, float rotY, float rotZ, String texture, Colorf color) {
        super(name, model, scale, rotX, rotY, rotZ, texture, color);
        this.moving = moving;
        this.speed = speed;
        this.locations = new LinkedList<String>();
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void addLocation(String name) {
        this.locations.add(name);
    }

    public String getFirstLocationName() {
        return this.locations.get(0);
    }

    public boolean hasNextLocation() {
        if (this.locationIterator == null) {
            this.locationIterator = this.locations.listIterator();
        }
        return this.locationIterator.hasNext();
    }

    public String getNextLocationName() {
        if (this.locationIterator == null) {
            this.locationIterator = this.locations.listIterator();
        }
        return this.locationIterator.next();
    }

    public String[] getAllLocationNames() {
        return this.locations.toArray(new String[0]);
    }

    public float getSpeed() {
        return this.speed;
    }
}

