/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.util;

import org.jagatoo.input.actions.LabeledInputAction;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.layout.GridLayout;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.text2d.TextAlignment;

public class TestUtils {
    public static ResourceLocator createResourceLocator() {
        return ResourceLocator.create("test-resources/");
    }

    public static void displayDebugTextures(float texWidth, HUD hud, Texture2D ... textures) {
        float texHeight = texWidth / hud.getResAspect();
        if (textures.length <= 4) {
            if (textures.length >= 1) {
                hud.getContentPane().addWidget(new Image(texWidth, texHeight, textures[0]), 10.0f, 10.0f);
            }
            if (textures.length >= 2) {
                hud.getContentPane().addWidget(new Image(texWidth, texHeight, textures[1]), hud.getResX() - texWidth - 10.0f, 10.0f);
            }
            if (textures.length >= 3) {
                hud.getContentPane().addWidget(new Image(texWidth, texHeight, textures[0]), 10.0f, hud.getResY() - texHeight - 10.0f);
            }
            if (textures.length >= 4) {
                hud.getContentPane().addWidget(new Image(texWidth, texHeight, textures[1]), hud.getResX() - texWidth - 10.0f, hud.getResY() - texHeight - 10.0f);
            }
        } else {
            Panel p = new Panel(hud.getResX(), hud.getResY());
            p.setLayout(new GridLayout(0, 3, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f));
            for (int i = 0; i < textures.length; ++i) {
                p.addWidget(new Image(texWidth, texHeight, textures[0]));
            }
            hud.getContentPane().addWidget(p);
        }
    }

    public static HUD displayDebugTextures(Sized2iRO hudSize, float texWidth, SceneGraph sg, Texture2D ... textures) {
        HUD hud = new HUD(hudSize, 800.0f);
        TestUtils.displayDebugTextures(texWidth, hud, textures);
        if (sg != null) {
            sg.addHUD(hud);
        }
        return hud;
    }

    public static void displayInputBindings(DeviceComponent[] comps, String[] descriptions, HUD hud) {
        if (comps.length == 0) {
            return;
        }
        Panel panel = new Panel(100.0f, 100.0f, new Colorf(Colorf.GRAY60, 0.3f));
        GridLayout layout = new GridLayout(comps.length, 2, 10.0f, 2.0f, 10.0f, 10.0f, 10.0f, 10.0f);
        panel.setLayout(layout);
        HUDFont font = HUDFont.getFont("DejaVu Sans Mono", HUDFont.PLAIN, 12);
        for (int i = 0; i < comps.length; ++i) {
            panel.addWidget(new Label(-1.0f, -1.0f, comps[i].getLocalizedName(), font, Colorf.WHITE, TextAlignment.CENTER_LEFT));
            panel.addWidget(new Label(-1.0f, -1.0f, descriptions[i], font, Colorf.WHITE, TextAlignment.CENTER_LEFT));
        }
        hud.getContentPane().addWidget(panel);
        Dim2f dim = Dim2f.fromPool();
        float widthA = 0.0f;
        float widthB = 0.0f;
        for (int i = 0; i < comps.length; ++i) {
            Label labelA = (Label)panel.getWidgets().get(i * 2 + 0);
            labelA.getMinimalSize(dim);
            if (dim.getWidth() > widthA) {
                widthA = dim.getWidth();
            }
            Label labelB = (Label)panel.getWidgets().get(i * 2 + 1);
            labelB.getMinimalSize(dim);
            if (!(dim.getWidth() > widthB)) continue;
            widthB = dim.getWidth();
        }
        layout.setColWeights(widthA, widthB);
        float width = layout.getBorderLeft() + widthA + layout.getHGap() + widthB + layout.getBorderRight();
        float height = layout.getBorderTop() + layout.getBorderBottom() + (dim.getHeight() + layout.getVGap()) * (float)comps.length;
        Dim2f.toPool(dim);
        panel.setSize(width, height);
        panel.setLocation(10.0f, hud.getResY() - 10.0f - height);
    }

    public static HUD displayInputBindings(Sized2iRO hudSize, DeviceComponent[] comps, String[] descriptions, SceneGraph sg) {
        if (comps.length == 0) {
            return null;
        }
        HUD hud = new HUD(hudSize, 800.0f);
        TestUtils.displayInputBindings(comps, descriptions, hud);
        if (sg != null) {
            sg.addHUD(hud);
        }
        return hud;
    }

    public static HUD displayInputBindings(Sized2iRO hudSize, DeviceComponent[] comps, LabeledInputAction[] actions, SceneGraph sg) {
        if (comps.length == 0) {
            return null;
        }
        String[] descriptions = new String[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            descriptions[i] = actions[i].getLocalizedText();
        }
        return TestUtils.displayInputBindings(hudSize, comps, descriptions, sg);
    }

    public static long dumpAction(String action) {
        long t0 = System.currentTimeMillis();
        System.out.print(action);
        return t0;
    }

    public static void dumpDoneIn(long t0) {
        System.out.println("done in " + (float)(System.currentTimeMillis() - t0) / 1000.0f + " seconds.");
    }
}

