/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.phases;

import java.util.LinkedList;
import java.util.List;
import org.em3d.core.Scene;
import org.em3d.phases.Phase;
import org.em3d.phases.WorldInterface;
import org.em3d.results.Results;

public class Collisions
extends Phase {
    private static final int COLLISION_STARTED = 1;
    private static final int COLLISION_LASTING = 2;
    private static final int COLLISION_FINISHED = 3;
    private static final int NOTHING = 0;
    private int state = 0;
    private long lastUpdate = 0L;
    private int maxTime;
    private int maxCollisions;
    private int numOfCollisions = 0;
    List<Long> correctTimes;
    List<Long> userTimes;
    private boolean interposition = true;
    private boolean projection = true;
    private boolean shading = true;
    private boolean shadows = true;
    private boolean fog = false;

    public Collisions(WorldInterface worldIface, Scene scene, String playerStartPosition, String playerFacingLocation, String gui, int freedom, int maxTime, int maxCollisions, boolean interposition, boolean projection, boolean shading, boolean shadows, boolean fog) {
        super(worldIface, scene, playerStartPosition, playerFacingLocation, gui, freedom);
        this.maxCollisions = maxCollisions;
        this.maxTime = maxTime;
        this.correctTimes = new LinkedList<Long>();
        this.userTimes = new LinkedList<Long>();
        this.interposition = interposition;
        this.projection = projection;
        this.shading = shading;
        this.shadows = shadows;
        this.fog = fog;
    }

    public void initialize(Results results) {
        super.initialize(results);
        System.out.println("collision phase started!");
        this.scene.resetObjectIterator();
        this.world.setCollisionListener(this.scene.getNextObject().getName(), this.scene.getNextObject().getName(), this);
        this.world.setCues(this.interposition, this.projection, this.shading, this.shadows, this.fog);
    }

    public void update(long gameTime) {
        super.update(gameTime);
        if (this.currentTime - this.lastUpdate > 100L) {
            this.lastUpdate = this.currentTime;
            switch (this.state) {
                case 0: {
                    this.state = 0;
                    break;
                }
                case 1: {
                    this.state = 1;
                    break;
                }
                case 2: {
                    this.state = 3;
                    break;
                }
                case 3: {
                    this.state = 0;
                }
            }
        }
        if (this.maxTime > 0 && (long)this.maxTime <= this.currentTime / 1000L) {
            this.userFinish();
        }
    }

    public void collision(String object1, String object2) {
        if (this.currentTime <= 0L) {
            return;
        }
        switch (this.state) {
            case 0: {
                this.state = 1;
                break;
            }
            case 1: {
                ++this.numOfCollisions;
                if (this.numOfCollisions < this.maxCollisions) {
                    if (this.world.debug()) {
                        System.out.println("collision " + this.numOfCollisions + ": " + object1 + " and " + object2 + " in " + this.currentTime);
                    }
                    this.correctTimes.add(this.currentTime);
                }
                if (this.numOfCollisions == this.maxCollisions) {
                    this.correctTimes.add(this.currentTime);
                    if (this.maxTime < 0) {
                        this.maxTime = (int)(this.currentTime / 1000L) + 3;
                    }
                    if (this.world.debug()) {
                        System.out.println("current time: " + this.currentTime / 1000L);
                        System.out.println("max time: " + this.maxTime);
                    }
                }
                this.state = 2;
                break;
            }
            case 3: {
                this.state = 2;
            }
        }
    }

    public void userFinish() {
        this.results.setCorrectCollisionTimes(this.correctTimes.toArray(new Long[0]));
        this.results.setUserCollisionTimes(this.userTimes.toArray(new Long[0]));
        this.finished = true;
        if (this.world.debug()) {
            System.out.println("collision phase finished!");
        }
    }

    public void userCollision() {
        if (this.maxCollisions >= this.numOfCollisions) {
            System.out.println("user spotted collision in " + this.currentTime);
            this.userTimes.add(this.currentTime);
        }
    }

    public boolean switchInterposition() {
        this.interposition = !this.interposition;
        return this.interposition;
    }

    public boolean switchProjection() {
        this.projection = !this.projection;
        return this.projection;
    }

    public boolean switchShading() {
        this.shading = !this.shading;
        System.out.println("shading: " + this.shading);
        return this.shading;
    }

    public boolean switchShadows() {
        this.shadows = !this.shadows;
        return this.shadows;
    }

    public boolean switchFog() {
        this.fog = !this.fog;
        return this.fog;
    }
}

