/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.phases;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.em3d.core.Scene;
import org.em3d.phases.Phase;
import org.em3d.phases.WorldInterface;
import org.em3d.results.Results;

public class RecallWithHint
extends Phase {
    Map<String, String> currentLocationObject = new HashMap<String, String>();
    Map<String, String> currentObjectLocation = new HashMap<String, String>();
    List<String> order = new LinkedList<String>();
    String holdingObject;

    public RecallWithHint(WorldInterface worldIface, Scene scene, String playerStartPosition, String playerFacingLocation, String gui, int freedom) {
        super(worldIface, scene, playerStartPosition, playerFacingLocation, gui, freedom);
    }

    public void initialize(Results results) {
        super.initialize(results);
        this.scene.resetObjectIterator();
        String[] locations = new String[this.scene.getObjectNames().length];
        int k = 0;
        while (this.scene.hasNextObject()) {
            locations[k] = this.scene.getNextObject().getFirstLocationName();
            ++k;
        }
        results.setCorrectLocations(locations);
        results.setCorrectOrder(this.scene.getObjectNames());
        String[] objects = this.shuffleArray(this.scene.getObjectNames());
        this.scene.resetLocationIterator();
        String loc = "none";
        for (String o : objects) {
            if (!this.scene.hasNextLocation()) break;
            loc = this.scene.getNextLocation().getName();
            while (!this.scene.isLocationTable(loc)) {
                loc = this.scene.getNextLocation().getName();
            }
            this.world.showObject(o, loc);
            this.world.setObjectPickable(o, true);
            this.currentLocationObject.put(loc, o);
            this.currentObjectLocation.put(o, loc);
        }
    }

    public void locationSelected(String locationName) {
        String object = this.currentLocationObject.get(locationName);
        if (this.holdingObject != null && this.scene.isLocationSocket(locationName)) {
            this.world.hideObject(object);
            this.order.add(this.holdingObject);
            this.currentLocationObject.put(locationName, this.holdingObject);
            this.currentObjectLocation.put(this.holdingObject, locationName);
            this.holdingObject = null;
            this.world.showObjectInHud(null);
            if (this.order.size() == this.scene.getNumberOfObjects()) {
                this.userFinish();
            }
        }
    }

    public void objectSelected(String objectName) {
        String location = this.currentObjectLocation.get(objectName);
        this.world.hideObject(objectName);
        this.world.showObject(this.holdingObject, location);
        this.currentLocationObject.put(location, this.holdingObject);
        this.currentObjectLocation.put(this.holdingObject, location);
        this.holdingObject = objectName;
        this.world.showObjectInHud(this.holdingObject);
    }

    public void mouseOverLocation(String locationName) {
        if (this.scene.isLocationSocket(locationName) && this.holdingObject != null) {
            this.gui.showFocus(true);
        }
    }

    public void mouseOverObject(String objectName) {
        this.gui.showFocus(true);
    }

    public void userFinish() {
        String[] objects = this.scene.getObjectNames();
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this.currentObjectLocation.get(objects[i]);
        }
        this.results.setUserLocations(objects);
        this.results.setUserOrder(this.order.toArray(new String[0]));
        this.finished = true;
    }
}

