/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.main;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.em3d.core.AbstractObject;
import org.em3d.core.CuesObject;
import org.em3d.core.Scene;
import org.em3d.core.ScriptManager;
import org.em3d.gui.GUI;
import org.em3d.phases.Phase;
import org.em3d.phases.WorldInterface;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.input.events.MouseMovedEvent;
import org.jagatoo.loaders.models.bsp.BSPClusterManager;
import org.jagatoo.loaders.textures.locators.TextureStreamLocatorURL;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.input.modules.fpih.FPIHInputAction;
import org.xith3d.input.modules.fpih.FPIHPhysics;
import org.xith3d.launcher.Xith3DTest;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.models.util.specific.bsp.CollisionEnabledClusterManager;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loaders.util.CollideableTranslatingModel;
import org.xith3d.loaders.util.RotatingModel;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.RenderLoop;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.loop.opscheduler.PickScheduler;
import org.xith3d.physics.PhysicsEngine;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.Collision;
import org.xith3d.physics.collision.CollisionCheck;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionListener;
import org.xith3d.physics.joode.JoodePhysicsEngine;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.picking.AllPickListener;
import org.xith3d.picking.PickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPass;
import org.xith3d.render.Renderer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BSPTreeGroup;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.ExponentialFog;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Transform;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.SkyBox;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.hud.widgets.Widget3D;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Xith3DTest.Description(fulltext={"The World"}, authors={"David Yazel", "Marvin Froehlich (aka Qudus)", "Michal Stolba"})
public class Main
extends Xith3DTest
implements PickListener,
WorldInterface {
    private static final boolean DEBUG = false;
    private static final boolean SHADOWS = true;
    private static final int PICK_BUTTON_PRESSED = 0;
    private static final int PICK_MOUSE_MOVED = 1;
    private static final int MAX_PICKING_DISTANCE = 5;
    private CollisionEnabledClusterManager clusterManager;
    private View view;
    private Canvas3D canvas;
    private FirstPersonInputHandler fpHandler;
    private PickScheduler pickScheder;
    private GroupNode scene;
    private CollisionEngine collEngine;
    private SimulationWorld world;
    private HUD hud;
    private RotatingModel hudModel;
    private Label hudLabel;
    private BranchGroup hudModelBG;
    private boolean guiBlocked = false;
    private boolean pickingBlocked = false;
    private String language = "en";
    private ScriptManager manager;
    private Map<String, Transform> mapObjectTransform;
    private Map<String, Model> mapObjectModel;
    private Map<String, CollideableTranslatingModel> mapObjectCTM;
    private TransformGroup debugSphere;
    private RenderPass levelRenderPass;
    private BranchGroup skybox;
    private ExponentialFog fog;
    private Cube ground;
    private GUI currentGUI;

    @Override
    protected void onRenderLoopStopped(long gameTime, UpdatingThread.TimingMode timingMode, float averageFPS) {
        super.onRenderLoopStopped(gameTime, timingMode, averageFPS);
        System.out.println("average FPS: " + averageFPS);
    }

    @Override
    protected void exit() {
        this.fpHandler.setMouseMovementSuspended(true);
        super.exit();
    }

    @Override
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        if (this.guiBlocked) {
            return;
        }
        this.currentGUI.keyPressed(key);
        switch (key.getKeyID()) {
            case F4: {
                if (this.clusterManager == null) break;
                this.clusterManager.setPVSUsage(!this.clusterManager.isPVSUsed());
                System.out.println("PVS: " + (this.clusterManager.isPVSUsed() ? "on" : "off"));
                break;
            }
            case C: {
                break;
            }
            case G: {
                break;
            }
            case BACK_SPACE: {
                this.manager.getCurrentPhase().restartPlayerPosition();
                break;
            }
            case V: {
                this.canvas.getPeer().setVSyncEnabled(!this.canvas.getPeer().isVSyncEnabled());
                break;
            }
            case Y: {
                this.fpHandler.flipMouseYAxis();
            }
        }
    }

    @Override
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        if (this.guiBlocked) {
            return;
        }
    }

    @Override
    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        if (this.guiBlocked) {
            return;
        }
        if (button == MouseButtons.LEFT_BUTTON) {
            if (this.pickingBlocked) {
                return;
            }
            this.pickScheder.pickAll(this.scene, e.getButton(), this.canvas.getWidth() / 2, this.canvas.getHeight() / 2, (AllPickListener)this, (Object)0);
        } else {
            this.fpHandler.setSuspended(!this.fpHandler.isSuspended());
            this.pickingBlocked = !this.pickingBlocked;
        }
    }

    @Override
    public void onMouseMoved(MouseMovedEvent e, int x, int y, int dx, int dy) {
    }

    @Override
    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        Shape3D shape;
        if (nearest.getMedialDistance() > 5.0f) {
            return;
        }
        if (userObject.equals(0)) {
            shape = (Shape3D)nearest.getNode();
            if (this.manager.getScene().isLocation(shape.getName())) {
                this.manager.getCurrentPhase().locationSelected(shape.getName());
            }
            if (this.manager.getScene().isObject(shape.getName())) {
                this.manager.getCurrentPhase().objectSelected(shape.getName());
            }
        }
        if (userObject.equals(1)) {
            shape = (Shape3D)nearest.getNode();
            if (this.manager.getScene().isLocation(shape.getName())) {
                this.manager.getCurrentPhase().mouseOverLocation(shape.getName());
            }
            if (this.manager.getScene().isObject(shape.getName())) {
                this.manager.getCurrentPhase().mouseOverObject(shape.getName());
            }
        }
    }

    @Override
    public void onObjectsPicked(List<PickResult> pickResults, Object userObject, long pickTime) {
        this.manager.getCurrentPhase().mouseOverNothing();
        Iterator<PickResult> it = pickResults.iterator();
        int i = 0;
        while (it.hasNext()) {
            PickResult r = it.next();
            this.onObjectPicked(r, userObject, pickTime);
            ++i;
        }
    }

    @Override
    public void onPickingMissed(Object userObject, long pickTime) {
    }

    @Override
    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        this.manager.update(gameTime);
        if (!this.pickingBlocked) {
            this.pickScheder.pickAll(this.scene, MouseButtons.LEFT_BUTTON, this.canvas.getWidth() / 2, this.canvas.getHeight() / 2, (AllPickListener)this, (Object)1);
        }
    }

    private static boolean check(URL baseURL, String name) {
        URL url = null;
        try {
            url = new URL(baseURL, name + "/front.png");
        }
        catch (IOException e) {
            return false;
        }
        try {
            url.openStream();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static SkyBox createSkyBox(URL baseURL, String name) {
        long t0 = TestUtils.dumpAction("Creating SkyBox from \"" + baseURL + name + "\"...");
        TextureStreamLocatorURL tsl = TextureLoader.getInstance().addTextureStreamLocator(baseURL);
        String ext = Main.check(baseURL, name) ? "png" : "jpg";
        SkyBox sb = new SkyBox(name + "/front." + ext, name + "/right." + ext, name + "/back." + ext, name + "/left." + ext, name + "/top." + ext, name + "/bottom." + ext);
        TextureLoader.getInstance().removeTextureStreamLocator(tsl);
        TestUtils.dumpDoneIn(t0);
        return sb;
    }

    private void initHudModel(HUD hud, SceneGraph sg, Animator animator) throws Exception {
        Model model = new Model();
        this.hudModel = new RotatingModel(model, 10.0f);
        this.hudModel.setRenderable(false);
        this.hudModelBG = new BranchGroup();
        this.hudModelBG.addChild(this.hudModel);
        animator.addAnimatableObject(this.hudModel);
        View hudView = new View();
        RenderPass hudRenderPass = sg.addPerspectiveBranch(this.hudModelBG);
        hudView.lookAt(this.hudModel.getPosition());
        hudRenderPass.getBranchGroup().getSceneGraph().addView(hudView);
        hudRenderPass.getConfig().setViewTransform(hudView.getTransform());
        Widget3D w3d = new Widget3D(200.0f, 200.0f, hudRenderPass.getConfig());
        Panel panel = new Panel(200.0f, 200.0f, new Colorf(Colorf.GRAY60, 0.5f));
        panel.addWidget(w3d);
        hud.getContentPane().addWidget(panel, 10.0f, 10.0f);
    }

    Transform loadModel(AbstractObject o, ResourceLocator resLoc, Tuple3f location) throws Exception {
        Transform t;
        Shape3D[] shapes;
        URL modelResource = resLoc.getResource(o.getModelName());
        long t0 = TestUtils.dumpAction("Loading Model \"" + modelResource + "\"...");
        Model model = ModelLoader.getInstance().loadModel(modelResource);
        model.setPickable(o.isPickable());
        System.out.println(o.getName());
        Material material = new Material();
        material.setLightingEnabled(true);
        material.setDiffuseColor(o.getColor());
        for (Shape3D s : shapes = model.getShapes()) {
            s.setName(o.getName());
            s.setPickable(o.isPickable());
            if (s.getAppearance() == null) {
                s.setAppearance(new Appearance());
            }
            s.getAppearance().setMaterial(material);
            s.getAppearance().setColor(o.getColor());
            if (!o.getTexture().equals("none")) {
                s.getAppearance().setTexture(o.getTexture());
            }
            StaticTransform.scale(s, o.getScale());
            StaticTransform.rotateX(s, o.getRotation().x());
            StaticTransform.rotateY(s, o.getRotation().y());
            StaticTransform.rotateZ(s, o.getRotation().z());
            s.setIsOccluder(true);
            s.setIsShadowReceiver(true);
        }
        if (o.isMoving()) {
            CollideableTranslatingModel tModel = new CollideableTranslatingModel(this.getXith3DEnvironment().getPhysicsEngine().getCollisionEngine(), model, 1.0f, ((CuesObject)o).getSpeed(), 0.25f, this.manager.getScene().getLocations(o.getAllLocationNames()));
            t = new Transform((Node)tModel).addTranslation(location);
            this.getAnimator().addAnimatableObject(tModel);
            this.mapObjectCTM.put(o.getName(), tModel);
        } else {
            t = new Transform((Node)model).addTranslation((Tuple3f)location.div(o.getScale()));
        }
        TestUtils.dumpDoneIn(t0);
        if (!o.isMoving()) {
            model.setRenderable(false);
        }
        this.mapObjectModel.put(o.getName(), model);
        this.mapObjectTransform.put(o.getName(), t);
        return t;
    }

    private RenderPass loadLevel(CollisionEngine collEngine, Xith3DEnvironment env) throws Exception {
        Scene managerScene = this.manager.getScene();
        Xith3DEnvironment sceneGraph = env;
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        BranchGroup scene = new BranchGroup();
        if (managerScene.getLevelName().equals("levels/skybox")) {
            System.out.println("loading skybox");
            this.skybox = env.addRenderPass(Main.createSkyBox(resLoc.getResource("skyboxes/"), "sb2"));
        } else {
            System.out.println("loading bsp level");
            Model bspScene = ModelLoader.getInstance().loadModel(resLoc.getResource(managerScene.getLevelName()));
            if (bspScene.getMainGroup() instanceof BSPTreeGroup) {
                BSPTreeGroup bspTG = (BSPTreeGroup)bspScene.getMainGroup();
                this.clusterManager = new CollisionEnabledClusterManager((BSPClusterManager)bspTG.getBSPVisibilityUpdater(), bspScene, collEngine);
                bspTG.setBSPVisibilityUpdater(this.clusterManager);
                this.clusterManager.setPVSUsage(false);
            }
            if (bspScene.getSkyBox() != null) {
                this.skybox = sceneGraph.addRenderPass(Main.createSkyBox(resLoc.getResource("skyboxes/"), "sb2"));
            }
            scene.addChild(bspScene);
        }
        managerScene.resetSocketIterator();
        resLoc.createAndAddTSL("textures");
        while (managerScene.hasNextSocket()) {
            Cube socket = managerScene.getNextSocket(true);
            scene.addChild(socket);
            this.ground = socket;
        }
        managerScene.resetObjectIterator();
        while (managerScene.hasNextObject()) {
            AbstractObject o = managerScene.getNextObject();
            scene.addChild(this.loadModel(o, resLoc, managerScene.getLocation(o.getFirstLocationName()).getValue()));
        }
        managerScene.resetLocationIterator();
        while (managerScene.hasNextLocation()) {
            scene.addChild(managerScene.getNextLocation().getLocationSphere(false));
        }
        PointLight light = new PointLight();
        light.setColor(Colorf.WHITE);
        light.setLocation(0.0f, 1.5f, 0.0f);
        scene.addChild(light);
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(Vector3f.NEGATIVE_Y_AXIS);
        dl.setColor(Colorf.WHITE);
        scene.addChild(dl);
        dl = new DirectionalLight();
        dl.setDirection(Vector3f.NEGATIVE_X_AXIS);
        dl.setColor(Colorf.WHITE);
        scene.addChild(dl);
        scene.addChild(new AmbientLight(true, Colorf.GRAY50));
        this.scene = scene;
        RenderPass renderPass = sceneGraph.addPerspectiveBranch(scene);
        return renderPass;
    }

    private void createCollidables(CollisionEngine collEngine, CollideableGroup collGroup) {
        Scene managerScene = this.manager.getScene();
        managerScene.resetSocketIterator();
        while (managerScene.hasNextSocket()) {
            collGroup.addCollideable(collEngine.newBox(managerScene.getNextSocket(false)));
        }
    }

    private void createHUD(HUD hud) {
        DeviceComponent[] comps = new DeviceComponent[]{Keys.C, Keys.G, Keys.BACK_SPACE, Keys.V, Keys.Y, Keys.ESCAPE};
        String[] descriptions = new String[]{"Toggle collision-detection", "Toggle gravity", "Reset player", "Toggle v-sync", "Toggle Mouse-Y-flip", "Exit"};
        TestUtils.displayInputBindings(comps, descriptions, hud);
        this.hudLabel = new Label(hud.getResX() - 20.0f, 30.0f, "Nothing selected", HUDFont.getFont("Verdana", HUDFont.PLAIN, 14), Colorf.WHITE, TextAlignment.BOTTOM_RIGHT);
        hud.getContentPane().addWidget(this.hudLabel, 0.0f, 10.0f);
    }

    private RenderPass createSceneGraph(Xith3DEnvironment env, CollisionEngine collEngine, HUD hud) throws Exception {
        RenderPass rp;
        this.levelRenderPass = rp = this.loadLevel(collEngine, env);
        rp.getConfig().setFrontClipDistance(0.5f);
        rp.getConfig().setBackClipDistance(6000.0f);
        rp.setClipperEnabled(false);
        rp.getConfig().setOpaqueSortingPolicy(Renderer.OpaqueSortingPolicy.SORT_NONE);
        rp.getConfig().setRenderOptions(new RenderOptions());
        rp.getConfig().getRenderOptions().setWireframeModeEnabled(false);
        this.pickScheder = env.getPickScheduler();
        return rp;
    }

    private final void createFPIH(boolean mouseYInverted, PhysicsEngine physEngine, CollideableGroup levelGroup) {
        this.fpHandler = new FirstPersonInputHandler((Transformable)this.view, this.canvas, 1.0f, 1.0f, mouseYInverted, 1.0f);
        this.fpHandler.getMovementConstraints().setFixedPlaneEnabled(true);
        this.fpHandler.getBindingsManager().createDefaultBindings();
        this.fpHandler.getBindingsManager().unbind(FPIHInputAction.CROUCH);
        this.collEngine = physEngine.getCollisionEngine();
        this.world = physEngine.getSimulationEngine().newWorld();
        this.world.setGravity(0.0f, 0.0f, 0.0f);
        this.fpHandler.setPhysicsObject(new FPIHPhysics(1.5f, 3.0f, new Vector3f(0.0f, -1.1f, 0.0f), physEngine, this.world, true, false));
        this.fpHandler.getPhysicsObject().setSlidingColliderCheckCallback(physEngine.getCollisionEngine(), levelGroup);
        InputSystem.getInstance().addInputHandler(this.fpHandler);
    }

    public Main(String testName, String language, BasicApplicationArguments arguments, Xith3DTest.FinishListener fl) throws Throwable {
        super(arguments.getMaxFPS());
        this.language = language;
        this.manager = new ScriptManager(this, testName);
        this.mapObjectTransform = new HashMap<String, Transform>();
        this.mapObjectModel = new HashMap<String, Model>();
        this.mapObjectCTM = new HashMap<String, CollideableTranslatingModel>();
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        this.view = env.getView();
        this.view.lookAlong(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        JoodePhysicsEngine physEngine = new JoodePhysicsEngine();
        env.setPhysicsEngine(physEngine);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        this.hud = new HUD(arguments.getResolution(), 800.0f);
        this.createSceneGraph(env, physEngine.getCollisionEngine(), this.hud);
        CollideableGroup levelCollGroup = this.clusterManager != null ? this.clusterManager.getCollideableGroup() : physEngine.getCollisionEngine().newGroup();
        this.createCollidables(physEngine.getCollisionEngine(), levelCollGroup);
        resLoc.createAndAddTSL("HUD");
        this.createHUD(this.hud);
        this.initHudModel(this.hud, env, this.getAnimator());
        env.addHUD(this.hud);
        Canvas3D canvas = Canvas3DFactory.create(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        canvas.enableLighting();
        env.addCanvas(canvas);
        this.canvas = canvas;
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.createFPIH(arguments.getMouseYInverted(), physEngine, levelCollGroup);
        this.manager.initializeFirstPhase();
        this.begin(fl, RenderLoop.RunMode.RUN_IN_SAME_THREAD);
    }

    public static void main(String[] args) throws Throwable {
        Main test = new Main(args[0], "en", Main.parseCommandLine(args), null);
        test.begin();
    }

    @Override
    public void showObject(String objectName, String locationName) {
        if (objectName == null || locationName == null) {
            return;
        }
        Tuple3f newPosition = this.manager.getScene().getLocation(locationName).getValue();
        Transform objectTransform = this.mapObjectTransform.get(objectName);
        objectTransform.setTranslation(newPosition);
        this.mapObjectModel.get(objectName).setRenderable(true);
    }

    @Override
    public void hideObject(String objectName) {
        if (objectName == null) {
            return;
        }
        this.mapObjectModel.get(objectName).setRenderable(false);
    }

    @Override
    public void showObjectInHud(String objectName) {
        if (objectName == null || objectName.equals("none")) {
            this.hudModel.setRenderable(false);
            return;
        }
        this.hudModel.setRenderable(true);
        Model model = this.mapObjectModel.get(objectName).getSharedInstance();
        this.hudModel.removeAllChildren();
        this.hudModel.addChild(model);
        PointLight light = new PointLight();
        light.setColor(Colorf.WHITE);
        light.setLocation(-2.0f, 0.0f, 0.0f);
        this.hudModel.addChild(light);
        light = new PointLight();
        light.setColor(Colorf.WHITE);
        light.setLocation(0.0f, -2.0f, 0.0f);
        this.hudModel.addChild(light);
        light = new PointLight();
        light.setColor(Colorf.WHITE);
        light.setLocation(0.0f, 0.0f, -2.0f);
        this.hudModel.addChild(light);
    }

    @Override
    public String isNearer(String object1, String object2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void changeGUI(GUI gui) {
        gui.createHUD();
        this.currentGUI = gui;
        this.showObjectInHud(null);
        if (!gui.showModel()) {
            this.hudModel.setRenderable(false);
        }
        if (!gui.renderBackground()) {
            this.getXith3DEnvironment().getBranchGroup(0).setRenderable(false);
        } else {
            this.getXith3DEnvironment().getBranchGroup(0).setRenderable(true);
        }
        this.fpHandler.setSuspended(gui.suspendFirstPerson());
        this.pickingBlocked = gui.suspendFirstPerson();
    }

    @Override
    public void setPlayerPosition(String location, String facing) {
        this.view.lookAt(this.manager.getScene().getLocation(location).getValue(), this.manager.getScene().getLocation(facing).getValue(), Vector3f.POSITIVE_Y_AXIS);
        this.fpHandler.updateViewInverse();
    }

    @Override
    public HUD getHUD() {
        return this.getXith3DEnvironment().getHUD();
    }

    @Override
    public void userExit() {
        this.exit();
    }

    @Override
    public void blockGUI(boolean block) {
        this.guiBlocked = block;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setObjectPickable(String object, boolean pickable) {
        System.out.println("set pickable: " + object);
        this.mapObjectModel.get(object).setPickable(pickable);
        System.out.println("pickable: " + this.mapObjectModel.get(object).isPickable());
    }

    @Override
    public void setCollisionListener(final String object1, final String object2, final Phase phase) {
        System.out.println("set collision listener: " + object1 + " and " + object2);
        Collideable c1 = this.mapObjectCTM.get(object1).getCollideable();
        Collideable c2 = this.mapObjectCTM.get(object2).getCollideable();
        this.fpHandler.getPhysicsObject().getCollider().setName("fpHandler");
        this.collEngine.addCollisionCheck(new CollisionCheck(c1, c2, new CollisionListener(){

            public void onCollision(Collision arg0) {
                phase.collision(object1, object2);
            }
        }));
    }

    @Override
    public void setCues(boolean interposition, boolean projection, boolean shading, boolean shadows, boolean fog) {
        if (!interposition) {
            boolean wireframe = this.levelRenderPass.switchWireframeMode();
            this.skybox.setRenderable(!wireframe);
        }
        if (!projection) {
            this.levelRenderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
            this.levelRenderPass.getConfig().setScreenScale(7.0f);
            if (this.ground != null) {
                this.ground.setRenderable(false);
            }
        }
        if (!shading) {
            Iterator<Model> mit = this.mapObjectModel.values().iterator();
            while (mit.hasNext()) {
                Shape3D[] shapes;
                for (Shape3D s : shapes = mit.next().getShapes()) {
                    s.getAppearance().getMaterial().setLightingEnabled(shading);
                }
            }
        }
    }

    @Override
    public void switchInterposition() {
        boolean wireframe = this.levelRenderPass.switchWireframeMode();
        this.skybox.setRenderable(!wireframe);
        this.manager.getCurrentPhase().switchInterposition();
    }

    @Override
    public void switchProjection() {
        if (this.manager.getCurrentPhase().switchProjection()) {
            this.levelRenderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
            this.levelRenderPass.getConfig().setScreenScale(1.0f);
            if (this.ground != null) {
                this.ground.setRenderable(true);
            }
        } else {
            this.levelRenderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
            this.levelRenderPass.getConfig().setScreenScale(7.0f);
            if (this.ground != null) {
                this.ground.setRenderable(false);
            }
        }
    }

    @Override
    public void switchShading() {
        boolean shading = this.manager.getCurrentPhase().switchShading();
        Iterator<Model> mit = this.mapObjectModel.values().iterator();
        while (mit.hasNext()) {
            Shape3D[] shapes;
            for (Shape3D s : shapes = mit.next().getShapes()) {
                s.getAppearance().getMaterial().setLightingEnabled(shading);
            }
        }
    }

    @Override
    public void switchShadows() {
    }

    @Override
    public void switchFog() {
    }

    @Override
    public void setPlayerMovement(boolean walk, boolean strafe, boolean freeLook) {
        if (freeLook) {
            this.fpHandler.setMouseXSpeed(1.0f);
        } else {
            this.fpHandler.setMouseXSpeed(1000.0f);
        }
        if (walk) {
            this.fpHandler.setMovementSpeedForward(1.0f);
            this.fpHandler.setMovementSpeedBackward(1.0f);
        } else {
            this.fpHandler.setMovementSpeedForward(0.0f);
            this.fpHandler.setMovementSpeedBackward(0.0f);
        }
        if (strafe) {
            this.fpHandler.setMovementSpeedSideward(1.0f);
        } else {
            this.fpHandler.setMovementSpeedSideward(0.0f);
        }
    }

    @Override
    public boolean pauseAnimation() {
        boolean paused = false;
        Iterator<CollideableTranslatingModel> mit = this.mapObjectCTM.values().iterator();
        while (mit.hasNext()) {
            CollideableTranslatingModel m;
            paused = m.pause(!(m = mit.next()).isPaused());
        }
        return paused;
    }

    @Override
    public boolean debug() {
        return false;
    }
}

