/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.base;

import java.io.File;
import org.xith3d.base.EnvScreenshotEngine;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.opscheduler.ScheduledScreenshot;
import org.xith3d.loop.opscheduler.util.SchedOpsPool;
import org.xith3d.render.Canvas3D;

class EnvScreenshotEngineImpl
implements EnvScreenshotEngine {
    private final Xith3DEnvironment env;

    public void takeScreenshot(Canvas3D canvas, File file, boolean alpha) {
        if (this.env.getOperationScheduler() == null) {
            System.out.print("taking screenshot...");
            canvas.takeScreenshot(file, true);
            System.out.println("screenshot: " + file.getAbsolutePath() + " saved.");
        } else {
            ScheduledScreenshot schededShot = SchedOpsPool.allocateSchededScreenshot(canvas, file, alpha);
            this.env.getOperationScheduler().scheduleOperation(schededShot);
        }
    }

    public void takeScreenshot(File file, boolean alpha) {
        if (this.env.getCanvas() == null) {
            throw new NullPointerException("No Canvas3D added to the Environment. Cannot take screenshot.");
        }
        this.env.getCanvas().takeScreenshot(file, alpha);
    }

    public File takeScreenshot(Canvas3D canvas, String filenameBase, boolean alpha) {
        return canvas.takeScreenshot(filenameBase, alpha);
    }

    public File takeScreenshot(Canvas3D canvas, boolean alpha) {
        return canvas.takeScreenshot("screenshot", alpha);
    }

    public File takeScreenshot(String filenameBase, boolean alpha) {
        if (this.env.getCanvas() == null) {
            throw new NullPointerException("No Canvas3D added to the Environment. Cannot take screenshot.");
        }
        return this.env.getCanvas().takeScreenshot(filenameBase, alpha);
    }

    public File takeScreenshot(boolean alpha) {
        return this.takeScreenshot("screenshot", alpha);
    }

    EnvScreenshotEngineImpl(Xith3DEnvironment env) {
        this.env = env;
    }
}

