/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.effects.atmosphere;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.jagatoo.opengl.enums.BlendFunction;
import org.jagatoo.opengl.enums.BlendMode;
import org.jagatoo.opengl.enums.DrawMode;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.openmali.FastMath;
import org.openmali.vecmath2.AxisAngle3f;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.Vector4f;
import org.xith3d.effects.atmosphere.AtmosphereFactory;
import org.xith3d.loaders.shaders.impl.glsl.GLSLShaderLoader;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.GLSLFragmentShader;
import org.xith3d.scenegraph.GLSLParameters;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.GLSLVertexShader;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.primitives.Sphere;

public class GLSLAtmosphereFactory
extends AtmosphereFactory {
    private static GLSLShaderProgram groundFromSpace = null;
    private static GLSLShaderProgram skyFromSpace = null;
    private static ArrayList<GLSLParameters> parametersGround = new ArrayList();
    private static ArrayList<GLSLParameters> parametersSky = new ArrayList();
    private int nbSamples = 2;
    private float kr = 0.0025f;
    private float km = 0.0015f;
    private float eSun = 15.0f;
    private float g = -0.95f;
    private float innerRadius;
    private float outerRadius;
    private float rayleighScaleDepth = 0.25f;

    private final float getScale() {
        return 1.0f / (this.outerRadius - this.innerRadius);
    }

    private final float getKm4Pi() {
        return this.km * 4.0f * (float)Math.PI;
    }

    private final float getKr4Pi() {
        return this.kr * 4.0f * (float)Math.PI;
    }

    private void updateShaderWavelength(Tuple3f wavelength3) {
        if (wavelength3 == null) {
            wavelength3 = this.getWavelength3();
        }
        Vector4f wavelength4 = Vector4f.fromPool();
        wavelength4.set(FastMath.pow((float)wavelength3.getX(), (float)4.0f), FastMath.pow((float)wavelength3.getY(), (float)4.0f), FastMath.pow((float)wavelength3.getZ(), (float)4.0f), 0.0f);
        Tuple3f invWaveLength = Tuple3f.fromPool();
        invWaveLength.set(1.0f / wavelength4.getX(), 1.0f / wavelength4.getY(), 1.0f / wavelength4.getZ());
        for (int i = 0; i < parametersGround.size(); ++i) {
            parametersGround.get(i).setUniformVar("v3InvWavelength", (TupleNf<?>)invWaveLength);
            parametersSky.get(i).setUniformVar("v3InvWavelength", (TupleNf<?>)invWaveLength);
        }
        Tuple3f.toPool((Tuple3f)invWaveLength);
        Vector4f.toPool((Vector4f)wavelength4);
    }

    public void setWavelength3(Tuple3f wavelength3) {
        super.setWavelength3(wavelength3);
        this.updateShaderWavelength(wavelength3);
    }

    public final void transformVector(Quaternion4f q, Tuple3f v, Vector3f out) {
        Matrix3f m = Matrix3f.fromPool();
        m.set(q);
        m.mul(v, (Tuple3f)out);
        Matrix3f.toPool((Matrix3f)m);
    }

    private void setShaderCameraPos(Point3f cameraPos, Vector3f translation, AxisAngle3f angle) {
        Vector3f cam = new Vector3f();
        cam.set(cameraPos.getX(), cameraPos.getY(), cameraPos.getZ());
        cam.sub((TupleNf)translation);
        Quaternion4f rotate = Quaternion4f.fromPool();
        if (angle.getAngle() != 0.0f) {
            rotate.set(angle);
        } else {
            rotate.setFromAxisAngle(0.0f, 1.0f, 0.0f, 0.0f);
        }
        rotate.invert();
        Vector3f computedCam = Vector3f.fromPool();
        this.transformVector(rotate, (Tuple3f)cam, computedCam);
        float camHeight = computedCam.length();
        Quaternion4f.toPool((Quaternion4f)rotate);
        for (int i = 0; i < parametersGround.size(); ++i) {
            GLSLParameters paramsGround = parametersGround.get(i);
            GLSLParameters paramsSky = parametersSky.get(i);
            paramsGround.setUniformVar("v3CameraPos", (TupleNf<?>)computedCam);
            paramsGround.setUniformVar("fCameraHeight", camHeight);
            paramsGround.setUniformVar("fCameraHeight2", camHeight * camHeight);
            paramsSky.setUniformVar("v3CameraPos", (TupleNf<?>)computedCam);
            paramsSky.setUniformVar("fCameraHeight", camHeight);
            paramsSky.setUniformVar("fCameraHeight2", camHeight * camHeight);
        }
        Vector3f.toPool((Vector3f)computedCam);
    }

    private void setShaderLightPos(Tuple3f lightPos, Vector3f translation, AxisAngle3f angle) {
        Quaternion4f rotate = Quaternion4f.fromPool();
        if (angle.getAngle() != 0.0f) {
            rotate.set(angle);
        } else {
            rotate.setFromAxisAngle(0.0f, 1.0f, 0.0f, 0.0f);
        }
        rotate.invert();
        lightPos.sub((TupleNf)translation);
        Vector3f computedLight = Vector3f.fromPool();
        this.transformVector(rotate, lightPos, computedLight);
        computedLight.normalize();
        for (int i = 0; i < parametersGround.size(); ++i) {
            parametersGround.get(i).setUniformVar("v3LightPos", (TupleNf<?>)computedLight);
            parametersSky.get(i).setUniformVar("v3LightPos", (TupleNf<?>)computedLight);
        }
        Vector3f.toPool((Vector3f)computedLight);
        Quaternion4f.toPool((Quaternion4f)rotate);
    }

    private void initShaderParameters(GLSLParameters paramsGround, GLSLParameters paramsSky) {
        paramsGround.setUniformVar("fInnerRadius", this.innerRadius);
        paramsGround.setUniformVar("fInnerRadius2", this.innerRadius * this.innerRadius);
        paramsGround.setUniformVar("fOuterRadius", this.outerRadius);
        paramsGround.setUniformVar("fOuterRadius2", this.outerRadius * this.outerRadius);
        paramsGround.setUniformVar("fKrESun", this.kr * this.eSun);
        paramsGround.setUniformVar("fKmESun", this.km * this.eSun);
        paramsGround.setUniformVar("fKr4PI", this.getKr4Pi());
        paramsGround.setUniformVar("fKm4PI", this.getKm4Pi());
        paramsGround.setUniformVar("fScale", this.getScale());
        paramsGround.setUniformVar("fScaleDepth", this.rayleighScaleDepth);
        paramsGround.setUniformVar("fScaleOverScaleDepth", 1.0f / (this.outerRadius - this.innerRadius) / this.rayleighScaleDepth);
        paramsGround.setUniformVar("g", this.g);
        paramsGround.setUniformVar("g2", this.g * this.g);
        paramsGround.setUniformVar("nSamples", this.nbSamples);
        paramsGround.setUniformVar("fSamples", (float)this.nbSamples);
        paramsGround.setUniformVar("s2Tex2", 0);
        paramsSky.setUniformVar("fInnerRadius", this.innerRadius);
        paramsSky.setUniformVar("fInnerRadius2", this.innerRadius * this.innerRadius);
        paramsSky.setUniformVar("fOuterRadius", this.outerRadius);
        paramsSky.setUniformVar("fOuterRadius2", this.outerRadius * this.outerRadius);
        paramsSky.setUniformVar("fKrESun", this.kr * this.eSun);
        paramsSky.setUniformVar("fKmESun", this.km * this.eSun);
        paramsSky.setUniformVar("fKr4PI", this.getKr4Pi());
        paramsSky.setUniformVar("fKm4PI", this.getKm4Pi());
        paramsSky.setUniformVar("fScale", this.getScale());
        paramsSky.setUniformVar("fScaleDepth", this.rayleighScaleDepth);
        paramsSky.setUniformVar("fScaleOverScaleDepth", 1.0f / (this.outerRadius - this.innerRadius) / this.rayleighScaleDepth);
        paramsSky.setUniformVar("g", this.g);
        paramsSky.setUniformVar("g2", this.g * this.g);
        paramsSky.setUniformVar("nSamples", this.nbSamples);
        paramsSky.setUniformVar("fSamples", (float)this.nbSamples);
    }

    private static URL getResource(String resName) throws IOException {
        URL url = GLSLAtmosphereFactory.class.getClassLoader().getResource(resName);
        if (url == null) {
            throw new IOException("Could not find resource \"" + resName + "\".");
        }
        return url;
    }

    private void loadShaderPrograms() throws IOException {
        GLSLFragmentShader fragShader;
        GLSLVertexShader vertShader;
        if (groundFromSpace == null) {
            vertShader = GLSLShaderLoader.getInstance().loadVertexShader(GLSLAtmosphereFactory.getResource("resources/org/xith3d/shaders/atmosphere/ground_from_space.glslvert"));
            groundFromSpace = new GLSLShaderProgram();
            groundFromSpace.addShader(vertShader);
            fragShader = GLSLShaderLoader.getInstance().loadFragmentShader(GLSLAtmosphereFactory.getResource("resources/org/xith3d/shaders/atmosphere/ground_from_space.glslfrag"));
            groundFromSpace.addShader(fragShader);
        }
        if (skyFromSpace == null) {
            vertShader = GLSLShaderLoader.getInstance().loadVertexShader(GLSLAtmosphereFactory.getResource("resources/org/xith3d/shaders/atmosphere/sky_from_space.glslvert"));
            skyFromSpace = new GLSLShaderProgram();
            skyFromSpace.addShader(vertShader);
            fragShader = GLSLShaderLoader.getInstance().loadFragmentShader(GLSLAtmosphereFactory.getResource("resources/org/xith3d/shaders/atmosphere/sky_from_space.glslfrag"));
            skyFromSpace.addShader(fragShader);
        }
    }

    protected void prepareAtmosphere(Sphere sphere, float atmosphereRadius, PointLight light) {
        try {
            this.loadShaderPrograms();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        this.innerRadius = sphere.getRadius();
        this.outerRadius = atmosphereRadius;
        Appearance appGround = sphere.getAppearance(true);
        GLSLContext prgGround = new GLSLContext(groundFromSpace);
        parametersGround.add(prgGround.getUniformParameters());
        appGround.setShaderProgramContext(prgGround);
        Sphere atmoSphere = new Sphere(this.outerRadius, 100, 100, Colorf.BLUE);
        GLSLContext prgSky = new GLSLContext(skyFromSpace);
        parametersSky.add(prgSky.getUniformParameters());
        Appearance appSky = atmoSphere.getAppearance(true);
        TransparencyAttributes attributes = new TransparencyAttributes();
        attributes.setMode(BlendMode.BLENDED);
        attributes.setSrcBlendFunction(BlendFunction.ONE);
        attributes.setDstBlendFunction(BlendFunction.ONE);
        appSky.setTransparencyAttributes(attributes);
        appSky.getPolygonAttributes(true).setFaceCullMode(FaceCullMode.BACK);
        appSky.getPolygonAttributes(true).setDrawMode(DrawMode.FILL);
        appSky.setShaderProgramContext(prgSky);
        this.initShaderParameters(prgGround.getUniformParameters(), prgSky.getUniformParameters());
        sphere.getParent().addChild(atmoSphere);
        this.updateShaderWavelength(null);
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.getSphere().getRoot() == null) {
            return;
        }
        Transform3D world = this.getSphere().getWorldTransform();
        Quaternion4f quat = Quaternion4f.fromPool();
        AxisAngle3f angle = AxisAngle3f.fromPool();
        world.get(quat);
        angle.set(quat);
        Vector3f translation = world.getTranslation();
        Quaternion4f.toPool((Quaternion4f)quat);
        Point3f cameraPos = this.getSphere().getRoot().getSceneGraph().getView().getPosition();
        this.setShaderCameraPos(cameraPos, translation, angle);
        Point3f lightPos = Point3f.fromPool();
        this.getLightPos(lightPos);
        this.setShaderLightPos((Tuple3f)lightPos, translation, angle);
        Point3f.toPool((Point3f)lightPos);
        AxisAngle3f.toPool((AxisAngle3f)angle);
    }
}

