/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.effects.bloom;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.effects.bloom.BloomFactory;
import org.xith3d.loaders.shaders.impl.glsl.GLSLShaderLoader;
import org.xith3d.loaders.texture.TextureCreator;
import org.xith3d.render.ForegroundRenderPass;
import org.xith3d.render.RenderPass;
import org.xith3d.render.TextureRenderTarget;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.GLSLFragmentShader;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.GLSLVertexShader;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.primitives.Rectangle;

public class GLSLBloomFactory
extends BloomFactory {
    private static final int TEXTURE_SIZE = 128;
    private GLSLContext brightpassFilter = null;
    private GLSLContext verticalGaussianFilter = null;
    private GLSLContext horizontalGaussianFilter = null;
    private GLSLContext blendFilter = null;
    private Texture2D inTex;
    private Texture2D brightTex;
    private Texture2D gaussianTex;
    private Texture2D outTex;
    private final Colorf bgColor = new Colorf(0.0f, 0.0f, 0.0f, 1.0f);

    private static URL getResource(String resName) throws IOException {
        URL url = GLSLBloomFactory.class.getClassLoader().getResource(resName);
        if (url == null) {
            throw new IOException("Could not find resource \"" + resName + "\".");
        }
        return url;
    }

    private void loadShaders() throws IOException {
        GLSLVertexShader vertexShader = GLSLShaderLoader.getInstance().loadVertexShader(GLSLBloomFactory.getResource("resources/org/xith3d/shaders/bloom/bloom.glslvert"));
        GLSLFragmentShader fragmentShader = GLSLShaderLoader.getInstance().loadFragmentShader(GLSLBloomFactory.getResource("resources/org/xith3d/shaders/bloom/brightness_filter.glslfrag"));
        GLSLShaderProgram program = new GLSLShaderProgram();
        program.addShader(vertexShader);
        program.addShader(fragmentShader);
        this.brightpassFilter = new GLSLContext(program);
        this.brightpassFilter.getUniformParameters().setUniformVar("tex", 0);
        fragmentShader = GLSLShaderLoader.getInstance().loadFragmentShader(GLSLBloomFactory.getResource("resources/org/xith3d/shaders/bloom/gaussian_v.glslfrag"));
        program = new GLSLShaderProgram();
        program.addShader(vertexShader);
        program.addShader(fragmentShader);
        this.verticalGaussianFilter = new GLSLContext(program);
        this.verticalGaussianFilter.getUniformParameters().setUniformVar("inTexture", 0);
        fragmentShader = GLSLShaderLoader.getInstance().loadFragmentShader(GLSLBloomFactory.getResource("resources/org/xith3d/shaders/bloom/gaussian_h.glslfrag"));
        program = new GLSLShaderProgram();
        program.addShader(vertexShader);
        program.addShader(fragmentShader);
        this.horizontalGaussianFilter = new GLSLContext(program);
        this.horizontalGaussianFilter.getUniformParameters().setUniformVar("inTexture", 0);
        fragmentShader = GLSLShaderLoader.getInstance().loadFragmentShader(GLSLBloomFactory.getResource("resources/org/xith3d/shaders/bloom/bloom.glslfrag"));
        program = new GLSLShaderProgram();
        program.addShader(vertexShader);
        program.addShader(fragmentShader);
        this.blendFilter = new GLSLContext(program);
    }

    private void initTextures(Sized2iRO resolution) {
        this.inTex = TextureCreator.createTexture(TextureFormat.RGBA, resolution.getWidth(), resolution.getHeight(), this.bgColor);
        this.inTex.enableAutoFreeLocalData();
        this.brightTex = TextureCreator.createTexture(TextureFormat.RGBA, 128, 128, this.bgColor);
        this.brightTex.enableAutoFreeLocalData();
        this.gaussianTex = TextureCreator.createTexture(TextureFormat.RGBA, 128, 128, this.bgColor);
        this.gaussianTex.enableAutoFreeLocalData();
        this.outTex = TextureCreator.createTexture(TextureFormat.RGBA, 128, 128, this.bgColor);
        this.outTex.enableAutoFreeLocalData();
    }

    private void createFilter(Xith3DEnvironment env, Sized2iRO res, GLSLContext program, Texture in, Texture out) {
        Texture2D empty = TextureCreator.createTexture(TextureFormat.RGBA, 1024, 1024, new Colorf(0.0f, 0.0f, 0.0f, 1.0f));
        Rectangle finalTarget = new Rectangle(2.0f, 2.0f / (float)res.getWidth() * (float)res.getHeight(), (Texture)empty);
        Appearance appearance = finalTarget.getAppearance(true);
        appearance.setTexture(0, in);
        appearance.setShaderProgramContext(program);
        ForegroundRenderPass finalPass = ForegroundRenderPass.createParallel();
        finalPass.getConfig().setViewTransform(Transform3D.IDENTITY);
        finalPass.getBranchGroup().addChild(finalTarget);
        TextureRenderTarget renderTarget = new TextureRenderTarget((GroupNode)finalPass.getBranchGroup(), out, this.bgColor);
        finalPass.setRenderTarget(renderTarget);
        env.addRenderPass(finalPass);
    }

    public void prepareForBloom(Xith3DEnvironment env, Sized2iRO resolution, GroupNode group) throws IOException {
        this.loadShaders();
        this.initTextures(resolution);
        List<RenderPass> passes = env.getRenderer().getRenderPasses(group.getRoot());
        TextureRenderTarget renderTarget1 = new TextureRenderTarget(group, (Texture)this.inTex, this.bgColor);
        passes.get(0).setRenderTarget(renderTarget1);
        this.createFilter(env, resolution, this.brightpassFilter, this.inTex, this.brightTex);
        this.createFilter(env, resolution, this.horizontalGaussianFilter, this.brightTex, this.gaussianTex);
        this.createFilter(env, resolution, this.verticalGaussianFilter, this.gaussianTex, this.outTex);
        Texture2D empty = TextureCreator.createTexture(TextureFormat.RGBA, 1024, 1024, new Colorf(0.0f, 0.0f, 0.0f, 1.0f));
        Rectangle finalTarget = new Rectangle(2.0f, 2.0f / (float)resolution.getWidth() * (float)resolution.getHeight(), (Texture)empty);
        Appearance appearance = finalTarget.getAppearance(true);
        appearance.setTexture(0, this.inTex);
        appearance.setTexture(1, this.outTex);
        this.blendFilter.getUniformParameters().setUniformVar("originalWeight", this.getSceneWeight());
        this.blendFilter.getUniformParameters().setUniformVar("bloomWeight", this.getBloomWeight());
        this.blendFilter.getUniformParameters().setUniformVar("originalTex", 0);
        this.blendFilter.getUniformParameters().setUniformVar("filteredTex", 1);
        appearance.setShaderProgramContext(this.blendFilter);
        appearance.setPolygonAttributes(new PolygonAttributes(FaceCullMode.BACK));
        ForegroundRenderPass finalPass = ForegroundRenderPass.createParallel();
        env.addRenderPass(finalPass);
        finalPass.getConfig().setViewTransform(Transform3D.IDENTITY);
        StaticTransform.translate(finalTarget, 0.0f, 0.0f, -1.0f);
        finalPass.getBranchGroup().addChild(finalTarget);
    }

    protected void updateBloomSettings() {
        if (this.blendFilter != null) {
            this.blendFilter.getUniformParameters().setUniformVar("originalWeight", this.getSceneWeight());
            this.blendFilter.getUniformParameters().setUniformVar("bloomWeight", this.getBloomWeight());
        }
    }
}

