/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.effects.bumpmapping;

import java.io.IOException;
import org.jagatoo.opengl.enums.TextureFormat;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.utility.geometry.TangentsFactory;

public abstract class BumpMappingFactory {
    private static final TangentsFactory tangentsFactory = TangentsFactory.getInstance();
    private int normalMapTextureUnit = 1;
    private int tangentsTextureUnit = 1;
    private int bitangentsTextureUnit = 2;
    private int tangentsVertexAttribute = 5;
    private int bitangentsVertexAttribute = 7;
    private TangentsFactory.TangentsStoreMode tangentsStoreMode = TangentsFactory.TangentsStoreMode.VERTEX_ATTRIBUTES;
    private Light bumpLight = null;

    public static final TangentsFactory getTangentsFactory() {
        return tangentsFactory;
    }

    public void setNormalMapTextureUnit(int textureUnit) {
        this.normalMapTextureUnit = textureUnit;
    }

    public int getNormalMapTextureUnit() {
        return this.normalMapTextureUnit;
    }

    public void setTangentsTextureUnit(int textureUnit) {
        this.tangentsTextureUnit = textureUnit;
    }

    public int getTangentsTextureUnit() {
        return this.tangentsTextureUnit;
    }

    public void setBiTangentsTextureUnit(int textureUnit) {
        this.bitangentsTextureUnit = textureUnit;
    }

    public int getBiTangentsTextureUnit() {
        return this.bitangentsTextureUnit;
    }

    public void setTangentsVertexAttribute(int vertexAttribIndex) {
        this.tangentsVertexAttribute = vertexAttribIndex;
    }

    public int getTangentsVertexAttribute() {
        return this.tangentsVertexAttribute;
    }

    public void setBiTangentsVertexAttribute(int vertexAttribIndex) {
        this.bitangentsVertexAttribute = vertexAttribIndex;
    }

    public int getBiTangentsVertexAttribute() {
        return this.bitangentsVertexAttribute;
    }

    public void setTangentsStoreMode(TangentsFactory.TangentsStoreMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode must not be null");
        }
        this.tangentsStoreMode = mode;
    }

    public TangentsFactory.TangentsStoreMode getTangentsStoreMode() {
        return this.tangentsStoreMode;
    }

    protected int getStoreIndex1() {
        if (this.getTangentsStoreMode() == TangentsFactory.TangentsStoreMode.VERTEX_ATTRIBUTES) {
            return this.getTangentsVertexAttribute();
        }
        if (this.getTangentsStoreMode() == TangentsFactory.TangentsStoreMode.TEXTURE_COORDINATES) {
            return this.getTangentsTextureUnit();
        }
        throw new Error("Invalid store-mode.");
    }

    protected int getStoreIndex2() {
        if (this.getTangentsStoreMode() == TangentsFactory.TangentsStoreMode.VERTEX_ATTRIBUTES) {
            return this.getBiTangentsVertexAttribute();
        }
        if (this.getTangentsStoreMode() == TangentsFactory.TangentsStoreMode.TEXTURE_COORDINATES) {
            return this.getBiTangentsTextureUnit();
        }
        throw new Error("Invalid store-mode.");
    }

    public void setLight(Light light) {
        this.bumpLight = light;
        System.err.println("Warning: the light-source is not yet taken into account!");
    }

    public Light getLight() {
        return this.bumpLight;
    }

    public static Texture loadNormalMap(String textureName) {
        Texture2D tex = TextureLoader.getInstance().getTexture(textureName, TextureFormat.RGB, Texture.MipmapMode.BASE_LEVEL);
        return tex;
    }

    public abstract void prepareForBumpMapping(Shape3D var1, Texture var2) throws IOException;

    public final void prepareForBumpMapping(Shape3D shape, String normalMapTex) throws IOException {
        this.prepareForBumpMapping(shape, BumpMappingFactory.loadNormalMap(normalMapTex));
    }
}

