/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.effects.bumpmapping;

import java.io.IOException;
import java.net.URL;
import org.xith3d.effects.bumpmapping.BumpMappingFactory;
import org.xith3d.loaders.shaders.impl.glsl.GLSLShaderLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.GLSLFragmentShader;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.GLSLVertexShader;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.utility.geometry.TangentsFactory;

public class GLSLBumpMappingFactory
extends BumpMappingFactory {
    private static GLSLShaderProgram shaderProgram = null;

    private static URL getResource(String resName) throws IOException {
        URL url = GLSLBumpMappingFactory.class.getClassLoader().getResource(resName);
        if (url == null) {
            throw new IOException("Could not find resource \"" + resName + "\".");
        }
        return url;
    }

    private GLSLShaderProgram getShaderProgram() throws IOException {
        if (shaderProgram != null) {
            return shaderProgram;
        }
        URL url = GLSLBumpMappingFactory.getResource("resources/org/xith3d/shaders/bumpmapping/shader.bumpmapping.glslvert");
        GLSLVertexShader vertexShader = GLSLShaderLoader.getInstance().loadVertexShader(url);
        if (this.getTangentsStoreMode() == TangentsFactory.TangentsStoreMode.VERTEX_ATTRIBUTES) {
            vertexShader.setVertexAttributeMapping(this.getTangentsVertexAttribute(), "tangent");
            vertexShader.setVertexAttributeMapping(this.getBiTangentsVertexAttribute(), "bitangent");
        }
        url = GLSLBumpMappingFactory.getResource("resources/org/xith3d/shaders/bumpmapping/shader.bumpmapping.glslfrag");
        GLSLFragmentShader fragmentShader = GLSLShaderLoader.getInstance().loadFragmentShader(url);
        shaderProgram = new GLSLShaderProgram(vertexShader, fragmentShader);
        return shaderProgram;
    }

    public void prepareForBumpMapping(Shape3D shape, Texture normalMapTex) throws IOException {
        GLSLBumpMappingFactory.getTangentsFactory().calculateTangents(shape.getGeometry(), this.getTangentsStoreMode(), this.getStoreIndex1(), this.getStoreIndex2());
        Appearance app = shape.getAppearance(true);
        app.setTexture(this.getNormalMapTextureUnit(), normalMapTex);
        GLSLContext shaderProgram = new GLSLContext(this.getShaderProgram());
        shaderProgram.getUniformParameters().setUniformVar("mainTex", 0);
        shaderProgram.getUniformParameters().setUniformVar("normalTex", this.getNormalMapTextureUnit());
        if (this.getTangentsStoreMode() == TangentsFactory.TangentsStoreMode.VERTEX_ATTRIBUTES && shape.getGeometry().getOptimization() == Geometry.Optimization.USE_DISPLAY_LISTS) {
            shape.getGeometry().setOptimization(Geometry.Optimization.USE_VBOS);
        }
        app.setShaderProgramContext(shaderProgram);
    }

    public GLSLBumpMappingFactory() {
        this.setTangentsStoreMode(TangentsFactory.TangentsStoreMode.VERTEX_ATTRIBUTES);
    }
}

