/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.input;

import java.util.ArrayList;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.actions.InputAction;
import org.jagatoo.input.devices.components.InputState;
import org.jagatoo.input.events.MouseMovedEvent;
import org.jagatoo.input.handlers.InputHandler;
import org.jagatoo.input.listeners.MouseAdapter;
import org.jagatoo.input.listeners.MouseListener;
import org.jagatoo.input.managers.InputBindingsManager;
import org.openmali.spatial.AxisIndicator;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.input.modules.fpih.FPIHConfig;
import org.xith3d.input.modules.fpih.FPIHInputAction;
import org.xith3d.input.modules.fpih.FPIHInputBindingsManager;
import org.xith3d.input.modules.fpih.FPIHInputStatesManager;
import org.xith3d.input.modules.fpih.FPIHMovementConstraints;
import org.xith3d.input.modules.fpih.FPIHPhysics;
import org.xith3d.input.modules.fpih.MovementListener;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.avatar.AvatarTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirstPersonInputHandler
extends InputHandler<FPIHInputAction> {
    public static final float DEFAULT_MOUSE_X_SPEED = 1.0f;
    public static final float DEFAULT_MOUSE_Y_SPEED = 1.0f;
    public static final boolean DEFAULT_MOUSE_Y_INVERTED = true;
    public static final float DEFAULT_MOVEMENT_FORWARD_SPEED = 1.0f;
    public static final float DEFAULT_MOVEMENT_BACKWARD_SPEED = 1.0f;
    public static final float DEFAULT_MOVEMENT_SIDEWARD_SPEED = 1.0f;
    public static final float DEFAULT_MAX_ANGLE_UP_DOWN = FPIHConfig.DEFAULT_MAX_ANGLE_UP_DOWN;
    private AxisIndicator upAxis = AxisIndicator.POSITIVE_Y_AXIS;
    private Matrix3f rotMat = new Matrix3f();
    private MouseLstnr mouseListener;
    private int canvasWidth;
    private int canvasHeight;
    private float mouseXSpeed = 1.0f;
    private float mouseYSpeed = 1.0f;
    private float movementSpeedForward = 1.0f;
    private float movementSpeedBackward = 1.0f;
    private float movementSpeedSideward = 1.0f;
    private float crouchSizeRegression = 2.0f;
    private int discreteZoomDelta = 0;
    private final Transformable view;
    private final Vector3f DEFAULT_TP_OFFSET = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f org_tpOffset = null;
    private Vector3f tpOffset = null;
    private final Vector3f tpOffset_transformed = new Vector3f();
    private float minTPDistance = 0.0f;
    private float maxTPDistance = 7.0f;
    private float discreteTPStepSize = 0.5f;
    private final Point3f viewPosition = new Point3f();
    private final Tuple3f viewEuler;
    private int mouseDX = 0;
    private int mouseDY = 0;
    private long lastMouseQueryTime = -1L;
    private FPIHPhysics physicsObject = null;
    private final ArrayList<AvatarTransform> avatarTransforms = new ArrayList();
    private boolean mouseMoved = false;
    private ArrayList<MovementListener> movementListeners;
    private boolean isFirst = true;
    private FPIHConfig config = null;
    private FPIHMovementConstraints constraints = new FPIHMovementConstraints();

    public void setUpAxis(AxisIndicator upAxis) {
        if (upAxis == null) {
            throw new IllegalArgumentException("upAxis must not be null!");
        }
        this.upAxis = upAxis;
    }

    public final AxisIndicator getUpAxis() {
        return this.upAxis;
    }

    public final Transformable getTransformNode() {
        return this.view;
    }

    public final View getView() {
        return (View)this.view;
    }

    public void addMovementListener(MovementListener l) {
        this.movementListeners.add(l);
    }

    public void removeMovementListener(MovementListener l) {
        this.movementListeners.remove(l);
    }

    public void startMovement(FPIHInputAction command) {
    }

    public void stopMovement(FPIHInputAction command) {
    }

    public void startCrouch() {
        if (this.crouchSizeRegression > 0.0f) {
            Point3f currPos = this.view.getPosition();
            this.view.setPosition((Tuple3f)new Vector3f(currPos.getX(), currPos.getY() - this.crouchSizeRegression, currPos.getZ()));
        }
    }

    public void stopCrouch() {
        if (this.crouchSizeRegression > 0.0f) {
            Point3f currPos = this.view.getPosition();
            this.view.setPosition((Tuple3f)new Vector3f(currPos.getX(), currPos.getY() + this.crouchSizeRegression, currPos.getZ()));
        }
    }

    public boolean startJump() {
        if (this.getPhysicsObject() != null) {
            return this.getPhysicsObject().startJump(this.getUpAxis());
        }
        return true;
    }

    public void updateViewInverse() {
        this.view.getTransform().getEuler(this.viewEuler);
        this.view.getTransform().getTranslation(this.viewPosition);
        if (this.getPhysicsObject() != null) {
            this.getPhysicsObject().updateFromView((Tuple3f)this.viewPosition);
        }
        if (this.tpOffset != null) {
            this.view.getTransform().getMatrix4f().transform(this.tpOffset, this.tpOffset_transformed);
            this.viewPosition.add((TupleNf)this.tpOffset_transformed);
        } else {
            this.tpOffset_transformed.set(0.0f, 0.0f, 0.0f);
        }
        this.isFirst = true;
    }

    public final FPIHInputBindingsManager getBindingsManager() {
        return (FPIHInputBindingsManager)super.getBindingsManager();
    }

    public final FPIHInputStatesManager getStatesManager() {
        return (FPIHInputStatesManager)super.getStatesManager();
    }

    public void setThirdPersonOffset(float tpDirectionX, float tpDirectionY, float tpDirectionZ, float distance) {
        if (tpDirectionX == 0.0f && tpDirectionY == 0.0f && tpDirectionZ == 0.0f) {
            this.org_tpOffset = null;
            this.tpOffset = null;
            this.updateViewInverse();
            return;
        }
        if (this.tpOffset == null) {
            this.tpOffset = new Vector3f(tpDirectionX, tpDirectionY, tpDirectionZ);
        } else {
            this.tpOffset.set(tpDirectionX, tpDirectionY, tpDirectionZ);
        }
        if (distance >= 0.0f) {
            this.tpOffset.normalize();
            this.tpOffset.scale(distance);
        }
        if (this.org_tpOffset == null) {
            this.org_tpOffset = new Vector3f((Tuple3f)this.tpOffset);
        } else {
            this.org_tpOffset.set((TupleNf)this.tpOffset);
        }
        this.updateViewInverse();
    }

    public void setThirdPersonDistance(float dist) {
        this.discreteZoomDelta = (int)(dist / this.discreteTPStepSize);
    }

    public void setThirdPersonOffset(float tpOffsetX, float tpOffsetY, float tpOffsetZ) {
        this.setThirdPersonOffset(tpOffsetX, tpOffsetY, tpOffsetZ, -1.0f);
    }

    public void setThirdPersonOffset(Tuple3f tpDirection, float distance) {
        if (tpDirection == null) {
            this.org_tpOffset = null;
            this.tpOffset = null;
            this.updateViewInverse();
            return;
        }
        this.setThirdPersonOffset(tpDirection.getX(), tpDirection.getY(), tpDirection.getZ(), distance);
    }

    public void setThirdPersonOffset(Tuple3f tpOffset) {
        this.setThirdPersonOffset(tpOffset, -1.0f);
    }

    public final Vector3f getThirdPersonOffset() {
        return this.tpOffset;
    }

    public void setMinThirdPersonDistance(float minDist) {
        this.minTPDistance = minDist;
    }

    public final float getMinThirdPersonDistance() {
        return this.minTPDistance;
    }

    public void setMaxThirdPersonDistance(float maxDist) {
        this.maxTPDistance = maxDist;
    }

    public final float getMaxThirdPersonDistance() {
        return this.maxTPDistance;
    }

    public void setDiscreteThirdPersonStepSize(float stepSize) {
        this.discreteTPStepSize = stepSize;
    }

    public final float getDiscreteThirdPersonStepSize() {
        return this.discreteTPStepSize;
    }

    public void setMouseXSpeed(float speedX) {
        this.mouseXSpeed = speedX;
        if (this.config != null) {
            this.config.setMouseXSpeed(speedX);
        }
    }

    public final float getMouseXSpeed() {
        return this.mouseXSpeed;
    }

    public void setMouseYSpeed(float speedY) {
        this.mouseYSpeed = speedY;
        if (this.config != null) {
            this.config.setMouseYSpeed(speedY);
        }
    }

    public final float getMouseYSpeed() {
        return this.mouseYSpeed;
    }

    public void flipMouseYAxis() {
        this.setMouseYSpeed(-this.getMouseYSpeed());
    }

    public void setMovementSpeed(float speed) {
        this.movementSpeedForward = speed;
        this.movementSpeedBackward = speed;
        this.movementSpeedSideward = speed;
        if (this.config != null) {
            this.config.setMovementSpeed(speed);
        }
    }

    public final float getMovementSpeed() {
        return (this.movementSpeedForward + this.movementSpeedBackward + this.movementSpeedSideward) / 3.0f;
    }

    public void setMovementSpeedForward(float speed) {
        this.movementSpeedForward = speed;
        if (this.config != null) {
            this.config.setMovementSpeedForward(speed);
        }
    }

    public final float getMovementSpeedForward() {
        return this.movementSpeedForward;
    }

    public void setMovementSpeedBackward(float speed) {
        this.movementSpeedBackward = speed;
        if (this.config != null) {
            this.config.setMovementSpeedBackward(speed);
        }
    }

    public final float getMovementSpeedBackward() {
        return this.movementSpeedBackward;
    }

    public void setMovementSpeedSideward(float speed) {
        this.movementSpeedSideward = speed;
        if (this.config != null) {
            this.config.setMovementSpeedSideward(speed);
        }
    }

    public final float getMovementSpeedSideward() {
        return this.movementSpeedSideward;
    }

    public void applyConfig(FPIHConfig config) {
        this.config = null;
        this.setMouseXSpeed(config.getMouseXSpeed());
        this.setMouseYSpeed(config.getMouseYSpeed());
        this.setMovementSpeedForward(config.getMovementSpeedForward());
        this.setMovementSpeedBackward(config.getMovementSpeedBackward());
        this.setMovementSpeedSideward(config.getMovementSpeedSideward());
        this.config = config;
    }

    public void extractConfig(FPIHConfig config) {
        this.config = null;
        this.setMouseXSpeed(config.getMouseXSpeed());
        this.setMouseYSpeed(config.getMouseYSpeed());
        this.setMovementSpeedForward(config.getMovementSpeedForward());
        this.setMovementSpeedBackward(config.getMovementSpeedBackward());
        this.setMovementSpeedSideward(config.getMovementSpeedSideward());
        this.config = config;
    }

    public void setPlayerCrouchSizeRegression(float sizeDelta) {
        this.crouchSizeRegression = sizeDelta;
    }

    public float getPlayerCrouchSizeRegression() {
        return this.crouchSizeRegression;
    }

    public void setMovementConstraints(FPIHMovementConstraints constraints) {
        if (constraints == null) {
            throw new IllegalArgumentException("constraints must not be null");
        }
        this.constraints = constraints;
    }

    public final FPIHMovementConstraints getMovementConstraints() {
        return this.constraints;
    }

    public boolean setSuspendMask(int suspendMask) {
        boolean imms = this.isMouseMovementSuspended();
        if (super.setSuspendMask(suspendMask)) {
            if (this.getInputSystem() != null) {
                try {
                    if (this.getInputSystem().hasMouse()) {
                        this.getInputSystem().getMouse().setAbsolute(this.isMouseMovementSuspended());
                    }
                }
                catch (InputSystemException e) {
                    throw new RuntimeException(e);
                }
            }
            if (imms && !this.isMouseMovementSuspended()) {
                this.updateViewInverse();
            }
            return true;
        }
        return false;
    }

    public void addAvatar(AvatarTransform at) {
        if (at == null) {
            throw new NullPointerException("at must not be null");
        }
        this.avatarTransforms.add(at);
        this.updateViewInverse();
    }

    public void removeAvatar(AvatarTransform at) {
        if (at == null) {
            throw new NullPointerException("at must not be null");
        }
        this.avatarTransforms.remove(at);
    }

    public void setPhysicsObject(FPIHPhysics physicsObject) {
        this.physicsObject = physicsObject;
        if (physicsObject != null) {
            physicsObject.init(this.getTransformNode(), this.getThirdPersonOffset());
            if (!this.isSuspended()) {
                this.updateViewInverse();
            }
        }
    }

    public final FPIHPhysics getPhysicsObject() {
        return this.physicsObject;
    }

    protected void updateAvatars(long gameMicros, long frameMicros, Transformable view, Vector3f viewTranslation, float rotX, float rotY, Vector3f thirdPersonOffset) {
        if (this.getPhysicsObject() != null) {
            this.getPhysicsObject().update(gameMicros, frameMicros, view, viewTranslation, rotX, rotY, thirdPersonOffset);
            this.isFirst = true;
        }
        for (int i = 0; i < this.avatarTransforms.size(); ++i) {
            this.avatarTransforms.get(i).transform(view.getTransform(), rotX, rotY, thirdPersonOffset);
        }
    }

    public void update(long nanoSeconds, float seconds, long nanoFrame, float frameSeconds) throws InputSystemException {
        boolean mouseWasMoved;
        FPIHInputStatesManager statesManager;
        long gameMicros = nanoSeconds / 1000L;
        long frameMicros = nanoFrame / 1000L;
        if (this.getPhysicsObject() != null) {
            this.getPhysicsObject().updateGameTime(gameMicros);
        }
        if ((statesManager = this.getStatesManager()).getInputState((InputAction)FPIHInputAction.DISCRETE_ZOOM_IN) == InputState.MADE_POSITIVE) {
            --this.discreteZoomDelta;
        }
        if (statesManager.getInputState((InputAction)FPIHInputAction.DISCRETE_ZOOM_OUT) == InputState.MADE_POSITIVE) {
            ++this.discreteZoomDelta;
        }
        boolean wasZooming = this.discreteZoomDelta != 0 || statesManager.isZooming();
        Vector3f viewTranslation = Vector3f.fromPool();
        if (statesManager.isMoving() || statesManager.isTurning() || this.mouseMoved || wasZooming) {
            this.view.getTransform().getTranslation(this.viewPosition);
            viewTranslation.setZero();
        }
        if (this.tpOffset != null && (statesManager.isMoving() || statesManager.isTurning() || this.mouseMoved || wasZooming)) {
            this.view.getTransform().getMatrix4f().transform(this.tpOffset, this.tpOffset_transformed);
            this.viewPosition.sub((TupleNf)this.tpOffset_transformed);
        }
        if (statesManager.isTurning()) {
            float turnH = this.mouseXSpeed * 5.0f * frameSeconds;
            float turnV = this.mouseYSpeed * 5.0f * frameSeconds;
            if (statesManager.isTurningLeft()) {
                this.viewEuler.addY(turnH);
            }
            if (statesManager.isTurningRight()) {
                this.viewEuler.subY(turnH);
            }
            if (statesManager.isAimingUp()) {
                this.viewEuler.addX(turnV);
            }
            if (statesManager.isAimingDown()) {
                this.viewEuler.subX(turnV);
            }
            this.constraints.applyRotationalConstraints(this.viewEuler, this.getUpAxis());
            this.view.getTransform().setEuler(this.viewEuler);
        }
        if (!this.isMouseMovementSuspended()) {
            if (this.mouseMoved) {
                mouseWasMoved = true;
                float dx = (float)this.mouseDX * 1.0f * ((float)Math.PI * 2) / (this.mouseXSpeed * (float)this.canvasWidth);
                float dy = (float)this.mouseDY * 1.0f * ((float)Math.PI * 2) / (this.mouseYSpeed * (float)this.canvasHeight);
                if (this.isMouseSmoothingEnabled()) {
                    if (this.lastMouseQueryTime != -1L) {
                        float dt = 100.0f * Math.min(0.3f, (float)(nanoSeconds - this.lastMouseQueryTime) / 1.0E9f);
                        dx /= dt;
                        dy /= dt;
                    }
                    this.lastMouseQueryTime = nanoSeconds;
                }
                switch (this.getUpAxis()) {
                    case POSITIVE_X_AXIS: {
                        this.viewEuler.sub(dx, dy, 0.0f);
                        break;
                    }
                    case NEGATIVE_X_AXIS: {
                        this.viewEuler.add(dx, dy, 0.0f);
                        break;
                    }
                    case POSITIVE_Y_AXIS: {
                        this.viewEuler.sub(dy, dx, 0.0f);
                        break;
                    }
                    case NEGATIVE_Y_AXIS: {
                        this.viewEuler.add(dy, dx, 0.0f);
                        break;
                    }
                    case POSITIVE_Z_AXIS: {
                        this.viewEuler.sub(dy, 0.0f, dx);
                        break;
                    }
                    case NEGATIVE_Z_AXIS: {
                        this.viewEuler.add(dy, 0.0f, dx);
                    }
                }
                this.constraints.applyRotationalConstraints(this.viewEuler, this.getUpAxis());
                this.view.getTransform().setEuler(this.viewEuler);
                this.mouseDX = 0;
                this.mouseDY = 0;
                this.mouseMoved = false;
            } else {
                mouseWasMoved = false;
            }
        } else {
            mouseWasMoved = false;
        }
        if (statesManager.isMoving() && nanoFrame > 0L) {
            Vector3f viewFacingDirection = Vector3f.fromPool();
            Vector3f viewRightDirection = Vector3f.fromPool();
            this.view.getTransform().getRotation(this.rotMat);
            this.rotMat.mul((Tuple3f)Vector3f.NEGATIVE_Z_AXIS, (Tuple3f)viewFacingDirection);
            this.view.getTransform().getRotation(this.rotMat);
            this.rotMat.mul((Tuple3f)Vector3f.POSITIVE_X_AXIS, (Tuple3f)viewRightDirection);
            boolean isMovingF = statesManager.isMovingForward();
            boolean isMovingB = statesManager.isMovingBackward();
            boolean isMovingL = statesManager.isMovingLeft();
            boolean isMovingR = statesManager.isMovingRight();
            float distF = isMovingF && (isMovingL || isMovingR) ? this.movementSpeedForward * 7.072136f * frameSeconds : this.movementSpeedForward * 10.0f * frameSeconds;
            float distB = isMovingB && (isMovingL || isMovingR) ? this.movementSpeedBackward * 7.072136f * frameSeconds : this.movementSpeedBackward * 10.0f * frameSeconds;
            float distS = !(!isMovingL && !isMovingR || !isMovingF && !isMovingB) ? this.movementSpeedSideward * 7.072136f * frameSeconds : this.movementSpeedSideward * 10.0f * frameSeconds;
            Vector3f tmpVec = Vector3f.fromPool();
            if (isMovingF) {
                tmpVec.set((TupleNf)viewFacingDirection);
                tmpVec.normalize();
                tmpVec.mul(distF);
                viewTranslation.add((TupleNf)tmpVec);
            }
            if (isMovingB) {
                tmpVec.set((TupleNf)viewFacingDirection);
                tmpVec.normalize();
                tmpVec.mul(-distB);
                viewTranslation.add((TupleNf)tmpVec);
            }
            if (isMovingR) {
                tmpVec.set((TupleNf)viewRightDirection);
                tmpVec.normalize();
                tmpVec.mul(distS);
                viewTranslation.add((TupleNf)tmpVec);
            }
            if (isMovingL) {
                tmpVec.set((TupleNf)viewRightDirection);
                tmpVec.normalize();
                tmpVec.mul(-distS);
                viewTranslation.add((TupleNf)tmpVec);
            }
            Vector3f.toPool((Vector3f)tmpVec);
            Vector3f.toPool((Vector3f)viewRightDirection);
            Vector3f.toPool((Vector3f)viewFacingDirection);
            this.constraints.applyMovementDeltaConstraints(viewTranslation, this.getUpAxis());
            this.viewPosition.add((TupleNf)viewTranslation);
            this.constraints.applyMovementConstraints((Tuple3f)this.viewPosition, this.getUpAxis());
        }
        if (wasZooming) {
            float delta = (float)this.discreteZoomDelta * this.discreteTPStepSize;
            this.discreteZoomDelta = 0;
            if (statesManager.isZoomingIn()) {
                delta -= this.discreteTPStepSize * 8.0f * frameSeconds;
            }
            if (statesManager.isZoomingOut()) {
                delta += this.discreteTPStepSize * 8.0f * frameSeconds;
            }
            if (delta > 0.0f || this.tpOffset != null) {
                float dist;
                if (this.tpOffset == null) {
                    if (this.org_tpOffset == null) {
                        this.org_tpOffset = new Vector3f((Tuple3f)this.DEFAULT_TP_OFFSET);
                    }
                    this.tpOffset = new Vector3f(0.0f, 0.0f, 0.0f);
                }
                if (Float.isNaN(dist = this.tpOffset.length())) {
                    dist = this.minTPDistance;
                }
                if ((dist += delta) < this.minTPDistance) {
                    dist = this.minTPDistance;
                } else if (dist > this.maxTPDistance) {
                    dist = this.maxTPDistance;
                }
                if (dist > 0.0f) {
                    this.tpOffset.normalize(this.org_tpOffset);
                    this.tpOffset.scale(dist);
                } else {
                    this.tpOffset = null;
                }
            }
        }
        if (this.tpOffset != null && (statesManager.isMoving() || statesManager.isTurning() || mouseWasMoved || wasZooming)) {
            this.view.getTransform().getMatrix4f().transform(this.tpOffset, this.tpOffset_transformed);
            this.viewPosition.add((TupleNf)this.tpOffset_transformed);
        }
        if (this.tpOffset == null) {
            this.tpOffset_transformed.set(0.0f, 0.0f, 0.0f);
        }
        if (statesManager.isMoving() || statesManager.isTurning() || mouseWasMoved || wasZooming) {
            this.view.getTransform().setTranslation((Tuple3f)this.viewPosition);
            this.view.setTransform(this.view.getTransform());
        }
        if (statesManager.isMoving() || statesManager.isTurning() || mouseWasMoved || this.isFirst || this.getPhysicsObject() != null) {
            this.updateAvatars(gameMicros, frameMicros, this.view, viewTranslation, this.viewEuler.getX(), this.viewEuler.getY(), this.tpOffset_transformed);
        }
        Vector3f.toPool((Vector3f)viewTranslation);
        this.isFirst = false;
    }

    public void setInputSystem(InputSystem inputSystem) {
        try {
            if (inputSystem != this.getInputSystem()) {
                if (this.getInputSystem() != null && this.mouseListener != null) {
                    if (!this.isMouseMovementSuspended()) {
                        this.getInputSystem().getMouse().setAbsolute(true);
                    }
                    this.getInputSystem().getMouse().removeMouseListener((MouseListener)this.mouseListener);
                }
                if (inputSystem != null) {
                    super.setInputSystem(inputSystem);
                    if (this.mouseListener == null) {
                        this.mouseListener = new MouseLstnr();
                    }
                    inputSystem.getMouse().addMouseListener((MouseListener)this.mouseListener);
                    inputSystem.getMouse().setAbsolute(this.isMouseMovementSuspended());
                }
            }
        }
        catch (Throwable t) {
            Error e = new Error("You must register a mouse before the FirstPersonInputHandler can be added to the InputHandler.");
            e.initCause(t);
            throw e;
        }
    }

    protected FPIHInputStatesManager createInputStatesManager(InputBindingsManager<FPIHInputAction> bindingsManager) {
        this.movementListeners = new ArrayList(1);
        return new FPIHInputStatesManager(this, this.movementListeners);
    }

    public FirstPersonInputHandler(Transformable view, int resolutionX, int resolutionY, float mouseXSpeed, float mouseYSpeed, float movementSpeedForeward, float movementSpeedBackward, float movementSpeedSideward) {
        super((InputBindingsManager)new FPIHInputBindingsManager());
        this.view = view;
        this.viewEuler = new Tuple3f(0.0f, 0.0f, 0.0f);
        this.updateViewInverse();
        this.canvasWidth = resolutionX;
        this.canvasHeight = resolutionY;
        this.setMouseXSpeed(mouseXSpeed);
        this.setMouseYSpeed(mouseYSpeed);
        this.setMovementSpeedForward(movementSpeedForeward);
        this.setMovementSpeedBackward(movementSpeedBackward);
        this.setMovementSpeedSideward(movementSpeedSideward);
        this.setMouseSmoothingEnabled(true);
    }

    public FirstPersonInputHandler(Transformable view, int resolutionX, int resolutionY, float mouseXSpeed, float mouseYSpeed, float movementSpeed) {
        this(view, resolutionX, resolutionY, mouseXSpeed, mouseYSpeed, movementSpeed, movementSpeed, movementSpeed);
    }

    public FirstPersonInputHandler(Transformable view, int resolutionX, int resolutionY, float mouseXSpeed, float mouseYSpeed, boolean mouseYInverted, float movementSpeed) {
        this(view, resolutionX, resolutionY, mouseXSpeed, mouseYInverted ? -mouseYSpeed : mouseYSpeed, movementSpeed, movementSpeed, movementSpeed);
    }

    public FirstPersonInputHandler(Transformable view, Sized2iRO resolution, float mouseXSpeed, float mouseYSpeed, float movementSpeedForeward, float movementSpeedBackward, float movementSpeedSideward) {
        this(view, resolution.getWidth(), resolution.getHeight(), mouseXSpeed, mouseYSpeed, movementSpeedForeward, movementSpeedBackward, movementSpeedSideward);
    }

    public FirstPersonInputHandler(Transformable view, Sized2iRO resolution, float mouseXSpeed, float mouseYSpeed, float movementSpeed) {
        this(view, resolution.getWidth(), resolution.getHeight(), mouseXSpeed, mouseYSpeed, movementSpeed);
    }

    public FirstPersonInputHandler(Transformable view, Sized2iRO resolution, float mouseXSpeed, float mouseYSpeed, boolean yInverted, float movementSpeed) {
        this(view, resolution.getWidth(), resolution.getHeight(), mouseXSpeed, mouseYSpeed, yInverted, movementSpeed);
    }

    public FirstPersonInputHandler(Transformable view, int resolutionX, int resolutionY) {
        this(view, resolutionX, resolutionY, 1.0f, 1.0f, true, 1.0f);
    }

    public FirstPersonInputHandler(Transformable view, Sized2iRO resolution) {
        this(view, resolution.getWidth(), resolution.getHeight());
    }

    public FirstPersonInputHandler(Transformable view, int resolutionX, int resolutionY, FPIHConfig config) {
        this(view, resolutionX, resolutionY);
        this.applyConfig(config);
    }

    public FirstPersonInputHandler(Transformable view, Sized2iRO resolution, FPIHConfig config) {
        this(view, resolution.getWidth(), resolution.getHeight(), config);
    }

    public static final FirstPersonInputHandler createDefault(Transformable view, int resolutionX, int resolutionY, float mouseXSpeed, float mouseYSpeed, float movementSpeedForeward, float movementSpeedBackward, float movementSpeedSideward) {
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler(view, resolutionX, resolutionY, mouseXSpeed, mouseYSpeed, movementSpeedForeward, movementSpeedBackward, movementSpeedSideward);
        fpHandler.getBindingsManager().createDefaultBindings();
        return fpHandler;
    }

    public static final FirstPersonInputHandler createDefault(Transformable view, int resolutionX, int resolutionY, float mouseXSpeed, float mouseYSpeed, float movementSpeed) {
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler(view, resolutionX, resolutionY, mouseXSpeed, mouseYSpeed, movementSpeed, movementSpeed, movementSpeed);
        fpHandler.getBindingsManager().createDefaultBindings();
        return fpHandler;
    }

    public static final FirstPersonInputHandler createDefault(Transformable view, Sized2iRO resolution, float mouseXSpeed, float mouseYSpeed, float movementSpeedForeward, float movementSpeedBackward, float movementSpeedSideward) {
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler(view, resolution.getWidth(), resolution.getHeight(), mouseXSpeed, mouseYSpeed, movementSpeedForeward, movementSpeedBackward, movementSpeedSideward);
        fpHandler.getBindingsManager().createDefaultBindings();
        return fpHandler;
    }

    public static final FirstPersonInputHandler createDefault(Transformable view, Sized2iRO resolution, float mouseXSpeed, float mouseYSpeed, float movementSpeed) {
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler(view, resolution.getWidth(), resolution.getHeight(), mouseXSpeed, mouseYSpeed, movementSpeed);
        fpHandler.getBindingsManager().createDefaultBindings();
        return fpHandler;
    }

    public static final FirstPersonInputHandler createDefault(Transformable view, Sized2iRO resolution, float mouseXSpeed, float mouseYSpeed, boolean mouseYInverted, float movementSpeed) {
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler(view, resolution.getWidth(), resolution.getHeight(), mouseXSpeed, mouseYSpeed, mouseYInverted, movementSpeed);
        fpHandler.getBindingsManager().createDefaultBindings();
        return fpHandler;
    }

    public static final FirstPersonInputHandler createDefault(Transformable view, int resolutionX, int resolutionY, boolean mouseYInverted) {
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler(view, resolutionX, resolutionY, 1.0f, 1.0f, mouseYInverted, 1.0f);
        fpHandler.getBindingsManager().createDefaultBindings();
        return fpHandler;
    }

    public static final FirstPersonInputHandler createDefault(Transformable view, int resolutionX, int resolutionY) {
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler(view, resolutionX, resolutionY, 1.0f, 1.0f, true, 1.0f);
        fpHandler.getBindingsManager().createDefaultBindings();
        return fpHandler;
    }

    public static final FirstPersonInputHandler createDefault(Transformable view, Sized2iRO resolution, boolean mouseYInverted) {
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler(view, resolution.getWidth(), resolution.getHeight(), 1.0f, 1.0f, mouseYInverted, 1.0f);
        fpHandler.getBindingsManager().createDefaultBindings();
        return fpHandler;
    }

    public static final FirstPersonInputHandler createDefault(Transformable view, Sized2iRO resolution) {
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler(view, resolution.getWidth(), resolution.getHeight());
        fpHandler.getBindingsManager().createDefaultBindings();
        return fpHandler;
    }

    public static final FirstPersonInputHandler createDefault(Transformable view, int resolutionX, int resolutionY, FPIHConfig config) {
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler(view, resolutionX, resolutionY, 1.0f, 1.0f, true, 1.0f);
        fpHandler.getBindingsManager().createDefaultBindings();
        fpHandler.applyConfig(config);
        return fpHandler;
    }

    public static final FirstPersonInputHandler createDefault(Transformable view, Sized2iRO resolution, FPIHConfig config) {
        return FirstPersonInputHandler.createDefault(view, resolution.getWidth(), resolution.getHeight(), config);
    }

    private class MouseLstnr
    extends MouseAdapter {
        private MouseLstnr() {
        }

        public void onMouseMoved(MouseMovedEvent e, int x, int y, int dx, int dy) {
            if (FirstPersonInputHandler.this.isMouseMovementSuspended()) {
                return;
            }
            FirstPersonInputHandler.this.mouseDX += dx;
            FirstPersonInputHandler.this.mouseDY += dy;
            FirstPersonInputHandler.this.mouseMoved = true;
        }
    }
}

