/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.input.modules.fpih;

import java.util.ArrayList;
import org.jagatoo.input.actions.InputAction;
import org.jagatoo.input.managers.InputBindingsManager;
import org.jagatoo.input.managers.InputStatesManager;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.input.modules.fpih.FPIHInputAction;
import org.xith3d.input.modules.fpih.MovementListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FPIHInputStatesManager
extends InputStatesManager {
    private final FirstPersonInputHandler fpih;
    private boolean isMovingForward = false;
    private boolean isMovingBackward = false;
    private boolean isMovingLeft = false;
    private boolean isMovingRight = false;
    private boolean isTurningLeft = false;
    private boolean isTurningRight = false;
    private boolean isAimingUp = false;
    private boolean isAimingDown = false;
    private boolean isJumping = false;
    private boolean isCrouching = false;
    private boolean isZoomingIn = false;
    private boolean isZoomingOut = false;
    private final ArrayList<MovementListener> movementListeners;

    private final void notifyMovementStarted(FPIHInputAction action) {
        if (this.movementListeners.size() > 0 && action.isRepositioning()) {
            for (int i = 0; i < this.movementListeners.size(); ++i) {
                this.movementListeners.get(i).onPlayerMovementStarted(action);
            }
        }
    }

    private final void notifyMovementStopped(FPIHInputAction action) {
        if (this.movementListeners.size() > 0 && action.isRepositioning()) {
            for (int i = 0; i < this.movementListeners.size(); ++i) {
                this.movementListeners.get(i).onPlayerMovementStopped(action);
            }
        }
    }

    private final void notifyJumped() {
        for (int i = 0; i < this.movementListeners.size(); ++i) {
            this.movementListeners.get(i).onPlayerJumped();
        }
    }

    private final void notifyCrouchStarted() {
        for (int i = 0; i < this.movementListeners.size(); ++i) {
            this.movementListeners.get(i).onPlayerCrouched();
        }
    }

    private final void notifyCrouchStopped() {
        for (int i = 0; i < this.movementListeners.size(); ++i) {
            this.movementListeners.get(i).onPlayerStoodUp();
        }
    }

    protected void startMovement(FPIHInputAction action) {
        this.notifyMovementStarted(action);
    }

    protected void stopMovement(FPIHInputAction action) {
        this.notifyMovementStopped(action);
    }

    protected boolean startJump() {
        boolean accepted = this.fpih.startJump();
        if (accepted) {
            this.notifyJumped();
        }
        return accepted;
    }

    protected void startCrouch() {
        this.fpih.startCrouch();
        this.notifyCrouchStarted();
    }

    protected void stopCrouch() {
        this.fpih.startCrouch();
        this.notifyCrouchStopped();
    }

    public final boolean isMovingForward() {
        return this.isMovingForward && this.getSimpleInputState((InputAction)FPIHInputAction.WALK_FORWARD) > 0;
    }

    public final boolean isMovingBackward() {
        return this.isMovingBackward && this.getSimpleInputState((InputAction)FPIHInputAction.WALK_BACKWARD) > 0;
    }

    public final boolean isMovingLeft() {
        return this.isMovingLeft && this.getSimpleInputState((InputAction)FPIHInputAction.STRAFE_LEFT) > 0;
    }

    public final boolean isMovingRight() {
        return this.isMovingRight && this.getSimpleInputState((InputAction)FPIHInputAction.STRAFE_RIGHT) > 0;
    }

    public final boolean isMoving() {
        return this.isMovingForward() || this.isMovingBackward() || this.isMovingLeft() || this.isMovingRight();
    }

    public final boolean isTurningLeft() {
        return this.isTurningLeft && this.getSimpleInputState((InputAction)FPIHInputAction.TURN_LEFT) > 0;
    }

    public final boolean isTurningRight() {
        return this.isTurningRight && this.getSimpleInputState((InputAction)FPIHInputAction.TURN_RIGHT) > 0;
    }

    public final boolean isTurning() {
        return this.isTurningLeft() || this.isTurningRight() || this.isAimingUp() || this.isAimingDown();
    }

    public final boolean isAimingUp() {
        return this.isAimingUp && this.getSimpleInputState((InputAction)FPIHInputAction.AIM_UP) > 0;
    }

    public final boolean isAimingDown() {
        return this.isAimingDown && this.getSimpleInputState((InputAction)FPIHInputAction.AIM_DOWN) > 0;
    }

    public final boolean isJumping() {
        return this.isJumping && this.getSimpleInputState((InputAction)FPIHInputAction.JUMP) > 0;
    }

    public final boolean isCrouching() {
        return this.isCrouching && this.getSimpleInputState((InputAction)FPIHInputAction.CROUCH) > 0;
    }

    public final boolean isZoomingIn() {
        return this.isZoomingIn && this.getSimpleInputState((InputAction)FPIHInputAction.ZOOM_IN) > 0;
    }

    public final boolean isZoomingOut() {
        return this.isZoomingOut && this.getSimpleInputState((InputAction)FPIHInputAction.ZOOM_OUT) > 0;
    }

    public final boolean isZooming() {
        return this.isZoomingIn() || this.isZoomingOut();
    }

    public void update(long nanoTime) {
        super.update(nanoTime);
        switch (this.getInputState((InputAction)FPIHInputAction.WALK_FORWARD)) {
            case MADE_POSITIVE: {
                this.isMovingForward = true;
                this.startMovement(FPIHInputAction.WALK_FORWARD);
                break;
            }
            case POSITIVE: {
                break;
            }
            case MADE_NEGATIVE: {
                this.isMovingForward = false;
                this.stopMovement(FPIHInputAction.WALK_FORWARD);
                break;
            }
            case NEGATIVE: {
                if (!this.isMovingForward) break;
                this.stopMovement(FPIHInputAction.WALK_FORWARD);
            }
        }
        switch (this.getInputState((InputAction)FPIHInputAction.WALK_BACKWARD)) {
            case MADE_POSITIVE: {
                this.isMovingBackward = true;
                this.startMovement(FPIHInputAction.WALK_BACKWARD);
                break;
            }
            case POSITIVE: {
                break;
            }
            case MADE_NEGATIVE: {
                this.isMovingBackward = false;
                this.stopMovement(FPIHInputAction.WALK_BACKWARD);
                break;
            }
            case NEGATIVE: {
                if (!this.isMovingBackward) break;
                this.stopMovement(FPIHInputAction.WALK_BACKWARD);
            }
        }
        switch (this.getInputState((InputAction)FPIHInputAction.STRAFE_LEFT)) {
            case MADE_POSITIVE: {
                this.isMovingLeft = true;
                this.startMovement(FPIHInputAction.STRAFE_LEFT);
                break;
            }
            case POSITIVE: {
                break;
            }
            case MADE_NEGATIVE: {
                this.isMovingLeft = false;
                this.stopMovement(FPIHInputAction.STRAFE_LEFT);
                break;
            }
            case NEGATIVE: {
                if (!this.isMovingLeft) break;
                this.stopMovement(FPIHInputAction.STRAFE_LEFT);
            }
        }
        switch (this.getInputState((InputAction)FPIHInputAction.STRAFE_RIGHT)) {
            case MADE_POSITIVE: {
                this.isMovingRight = true;
                this.startMovement(FPIHInputAction.STRAFE_RIGHT);
                break;
            }
            case POSITIVE: {
                break;
            }
            case MADE_NEGATIVE: {
                this.isMovingRight = false;
                this.stopMovement(FPIHInputAction.STRAFE_RIGHT);
                break;
            }
            case NEGATIVE: {
                if (!this.isMovingRight) break;
                this.stopMovement(FPIHInputAction.STRAFE_RIGHT);
            }
        }
        switch (this.getInputState((InputAction)FPIHInputAction.TURN_LEFT)) {
            case MADE_POSITIVE: {
                this.isTurningLeft = true;
                this.startMovement(FPIHInputAction.TURN_LEFT);
                break;
            }
            case POSITIVE: {
                break;
            }
            case MADE_NEGATIVE: {
                this.isTurningLeft = false;
                this.stopMovement(FPIHInputAction.TURN_LEFT);
                break;
            }
            case NEGATIVE: {
                if (!this.isTurningLeft) break;
                this.stopMovement(FPIHInputAction.TURN_LEFT);
            }
        }
        switch (this.getInputState((InputAction)FPIHInputAction.TURN_RIGHT)) {
            case MADE_POSITIVE: {
                this.isTurningRight = true;
                this.startMovement(FPIHInputAction.TURN_RIGHT);
                break;
            }
            case POSITIVE: {
                break;
            }
            case MADE_NEGATIVE: {
                this.isTurningRight = false;
                this.stopMovement(FPIHInputAction.TURN_RIGHT);
                break;
            }
            case NEGATIVE: {
                if (!this.isTurningRight) break;
                this.stopMovement(FPIHInputAction.TURN_RIGHT);
            }
        }
        switch (this.getInputState((InputAction)FPIHInputAction.AIM_UP)) {
            case MADE_POSITIVE: {
                this.isAimingUp = true;
                this.startMovement(FPIHInputAction.AIM_UP);
                break;
            }
            case POSITIVE: {
                break;
            }
            case MADE_NEGATIVE: {
                this.isAimingUp = false;
                this.stopMovement(FPIHInputAction.AIM_UP);
                break;
            }
            case NEGATIVE: {
                if (!this.isAimingUp) break;
                this.stopMovement(FPIHInputAction.AIM_UP);
            }
        }
        switch (this.getInputState((InputAction)FPIHInputAction.AIM_DOWN)) {
            case MADE_POSITIVE: {
                this.isAimingDown = true;
                this.startMovement(FPIHInputAction.AIM_DOWN);
                break;
            }
            case POSITIVE: {
                break;
            }
            case MADE_NEGATIVE: {
                this.isAimingDown = false;
                this.stopMovement(FPIHInputAction.AIM_DOWN);
                break;
            }
            case NEGATIVE: {
                if (!this.isAimingDown) break;
                this.stopMovement(FPIHInputAction.AIM_DOWN);
            }
        }
        switch (this.getInputState((InputAction)FPIHInputAction.JUMP)) {
            case MADE_POSITIVE: {
                if (!this.startJump()) break;
                this.isJumping = true;
                break;
            }
            case POSITIVE: {
                break;
            }
            case MADE_NEGATIVE: {
                this.isJumping = false;
                break;
            }
        }
        switch (this.getInputState((InputAction)FPIHInputAction.CROUCH)) {
            case MADE_POSITIVE: {
                this.isCrouching = true;
                this.startCrouch();
                break;
            }
            case POSITIVE: {
                break;
            }
            case MADE_NEGATIVE: {
                this.isCrouching = false;
                this.stopCrouch();
                break;
            }
            case NEGATIVE: {
                if (!this.isCrouching) break;
                this.stopCrouch();
            }
        }
    }

    public FPIHInputStatesManager(FirstPersonInputHandler fpih, ArrayList<MovementListener> movementListeners) {
        super((InputBindingsManager)fpih.getBindingsManager());
        this.fpih = fpih;
        this.movementListeners = movementListeners;
    }
}

