/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.xith3d.io.InvalidFormat;
import org.xith3d.io.Scribable;
import org.xith3d.io.ScribeGeometryArray;
import org.xith3d.io.ScribeInputStream;
import org.xith3d.io.ScribeOutputStream;
import org.xith3d.io.UnscribableNodeEncountered;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.SceneGraphObject;
import org.xith3d.utility.logging.X3DLog;

public class Scribe {
    public static final byte SCRIBE_GEOMETRY_ARRAY = 1;
    public static final byte SCRIBE_EXT = 2;
    public static boolean useNIO = true;

    public static SceneGraphObject read(ScribeInputStream in) throws IOException, InvalidFormat {
        Scribable s = in.readScribable();
        if (!(s instanceof SceneGraphObject)) {
            throw new InvalidFormat();
        }
        return (SceneGraphObject)((Object)s);
    }

    public static void writeSceneToFile(String filename, Scribable object) throws IOException {
        ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        zip.putNextEntry(new ZipEntry("object"));
        ScribeOutputStream out = new ScribeOutputStream(zip);
        try {
            out.writeScribable(object);
        }
        catch (UnscribableNodeEncountered e) {
            X3DLog.print(e);
            throw new IOException(e.getMessage());
        }
        out.flush();
        out.close();
    }

    public static void write(String filename, Scribable object) throws IOException {
        ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        zip.putNextEntry(new ZipEntry("object"));
        ScribeOutputStream out = new ScribeOutputStream(zip);
        try {
            out.writeScribable(object);
        }
        catch (UnscribableNodeEncountered e) {
            throw new IOException(e.getMessage());
        }
        out.flush();
        out.close();
    }

    public static void writeGeometryToFile(String filename, Geometry g) throws IOException {
        ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        zip.putNextEntry(new ZipEntry("object"));
        ScribeOutputStream out = new ScribeOutputStream(zip);
        ScribeGeometryArray.writeGeometryArray(out, g);
        out.flush();
        out.close();
    }

    public static SceneGraphObject readSceneFromFile(String filename) throws IOException, ClassNotFoundException, InvalidFormat {
        ZipInputStream zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(filename)));
        zip.getNextEntry();
        ScribeInputStream in = new ScribeInputStream(zip);
        SceneGraphObject object = (SceneGraphObject)((Object)in.readScribable());
        return object;
    }

    public static Scribable read(String filename) throws IOException, ClassNotFoundException, InvalidFormat {
        ZipInputStream zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(filename)));
        zip.getNextEntry();
        ScribeInputStream in = new ScribeInputStream(zip);
        Scribable object = in.readScribable();
        return object;
    }

    public static Scribable readHeader(String filename) throws IOException, ClassNotFoundException, InvalidFormat {
        ZipInputStream zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(filename)));
        zip.getNextEntry();
        ScribeInputStream in = new ScribeInputStream(zip);
        in.setReadHeaderOnly(true);
        Scribable object = in.readScribable();
        return object;
    }

    public static Geometry readGeometryFromFile(String filename) throws IOException, ClassNotFoundException, InvalidFormat {
        ZipInputStream zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(filename)));
        zip.getNextEntry();
        ScribeInputStream in = new ScribeInputStream(zip);
        Geometry g = ScribeGeometryArray.readGeometryArray(in);
        return g;
    }
}

