/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.io;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import org.jagatoo.image.DirectBufferedImage;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.io.InvalidFormat;
import org.xith3d.io.Scribable;
import org.xith3d.io.Scribe;
import org.xith3d.utility.logging.X3DLog;

public class ScribeInputStream
extends DataInputStream {
    private static final boolean USE_NEW = false;
    private ArrayList<String> map = new ArrayList();
    private byte[] byteBuffer = null;
    private FloatBuffer floatBuffer = null;
    private ByteBuffer bBuffer = null;
    private IntBuffer intBuffer = null;
    private ShortBuffer shortBuffer = null;
    private boolean readHeaderOnly = false;

    public ScribeInputStream(InputStream in) {
        super(in);
    }

    public void setReadHeaderOnly(boolean header) {
        this.readHeaderOnly = header;
    }

    public boolean shouldReadHeaderOnly() {
        return this.readHeaderOnly;
    }

    private boolean clutchByteBuffer(int size) {
        if (size < 1000) {
            size = 1000;
        }
        if (this.bBuffer != null && this.bBuffer.capacity() >= size) {
            this.bBuffer.rewind();
            return false;
        }
        this.byteBuffer = new byte[size];
        this.bBuffer = ByteBuffer.wrap(this.byteBuffer);
        this.floatBuffer = this.bBuffer.asFloatBuffer();
        this.intBuffer = this.bBuffer.asIntBuffer();
        return true;
    }

    private void clutchFloatBuffer(int size) {
        this.clutchByteBuffer(size * 4);
    }

    private void clutchIntBuffer(int size) {
        this.clutchByteBuffer(size * 4);
    }

    private void clutchShortBuffer(int size) {
        this.clutchByteBuffer(size * 2);
        this.shortBuffer = this.bBuffer.asShortBuffer();
    }

    public Scribable readScribable() throws IOException, InvalidFormat {
        int c = this.readInt();
        String className = null;
        if (c == 10001) {
            className = this.readUTF();
            this.map.add(className);
            X3DLog.debug("Reading class ", className);
        } else {
            int ref = this.readInt();
            X3DLog.debug("Reading class ref ", ref);
            className = this.map.get(ref);
            X3DLog.debug("  Class is ", className);
        }
        Scribable s = null;
        try {
            s = (Scribable)Class.forName(className).newInstance();
            s.load(this);
        }
        catch (ClassNotFoundException e1) {
            X3DLog.print(e1);
            throw new InvalidFormat(e1.getMessage());
        }
        catch (IllegalAccessException e2) {
            X3DLog.print(e2);
            throw new InvalidFormat(e2.getMessage());
        }
        catch (InstantiationException e3) {
            X3DLog.print(e3);
            throw new InvalidFormat(e3.getMessage());
        }
        return s;
    }

    private void readFloatArray(float[] data, int size) throws IOException {
        if (data.length < size) {
            IOException e = new IOException("Array not big enough to read " + size + " data elements");
            X3DLog.print(e);
            throw e;
        }
        if (Scribe.useNIO) {
            this.clutchFloatBuffer(size);
            this.readFully(this.byteBuffer, 0, size * 4);
            this.floatBuffer.rewind();
            this.floatBuffer.get(data, 0, size);
        } else {
            for (int i = 0; i < size; ++i) {
                data[i] = this.readFloat();
            }
        }
    }

    public int readFloatArray(float[] data) throws IOException {
        int size = this.readInt();
        this.readFloatArray(data, size);
        return size;
    }

    public float[] readFloatArray() throws IOException {
        int size = this.readInt();
        float[] data = new float[size];
        this.readFloatArray(data, size);
        return data;
    }

    private void readByteArray(byte[] data, int size) throws IOException {
        if (data.length < size) {
            throw new IOException("Array not big enough to read " + size + " data elements");
        }
        if (Scribe.useNIO) {
            this.readFully(data, 0, size);
        } else {
            for (int i = 0; i < size; ++i) {
                data[i] = this.readByte();
            }
        }
    }

    public int readByteArray(byte[] data) throws IOException {
        int size = this.readInt();
        this.readByteArray(data, size);
        return size;
    }

    public byte[] readByteArray() throws IOException {
        int size = this.readInt();
        byte[] data = new byte[size];
        this.readByteArray(data, size);
        return data;
    }

    private void readVectorArray(Vector3f[] data, int size) throws IOException {
        if (data.length < size) {
            throw new IOException("Array not big enough to read " + size + " data elements");
        }
        for (int i = 0; i < size; ++i) {
            data[i] = this.readVector();
        }
    }

    public int readVectorArray(Vector3f[] data) throws IOException {
        int size = this.readInt();
        this.readVectorArray(data, size);
        return size;
    }

    public Vector3f[] readVectorArray() throws IOException {
        int size = this.readInt();
        Vector3f[] data = new Vector3f[size];
        this.readVectorArray(data, size);
        return data;
    }

    private void readIntArray(int[] data, int size) throws IOException {
        if (data.length < size) {
            throw new IOException("Array not big enough to read " + size + " data elements");
        }
        if (Scribe.useNIO) {
            this.clutchIntBuffer(size);
            this.readFully(this.byteBuffer, 0, size * 4);
            this.intBuffer.rewind();
            this.intBuffer.get(data, 0, size);
        } else {
            for (int i = 0; i < size; ++i) {
                data[i] = this.readInt();
            }
        }
    }

    private void readShortArray(short[] data, int size) throws IOException {
        if (data.length < size) {
            throw new IOException("Array not big enough to read " + size + " data elements");
        }
        if (Scribe.useNIO) {
            this.clutchShortBuffer(size);
            this.readFully(this.byteBuffer, 0, size * 2);
            this.shortBuffer.get(data, 0, size);
        } else {
            for (int i = 0; i < size; ++i) {
                data[i] = this.readShort();
            }
        }
    }

    public int readIntArray(int[] data) throws IOException {
        int size = this.readInt();
        this.readIntArray(data, size);
        return size;
    }

    public int readShortArray(short[] data) throws IOException {
        int size = this.readInt();
        this.readShortArray(data, size);
        return size;
    }

    public int[] readIntArray() throws IOException {
        int size = this.readInt();
        int[] data = new int[size];
        this.readIntArray(data, size);
        return data;
    }

    public short[] readShortArray() throws IOException {
        int size = this.readInt();
        short[] data = new short[size];
        this.readShortArray(data, size);
        return data;
    }

    public void readPoint(Point3f p) throws IOException {
        p.setX(this.readFloat());
        p.setY(this.readFloat());
        p.setZ(this.readFloat());
    }

    public void readVector(Vector3f v) throws IOException {
        v.setX(this.readFloat());
        v.setY(this.readFloat());
        v.setZ(this.readFloat());
    }

    public Vector3f readVector() throws IOException {
        Vector3f v = new Vector3f();
        this.readVector(v);
        return v;
    }

    public void readColor3f(Colorf v) throws IOException {
        v.setRed(this.readFloat());
        v.setGreen(this.readFloat());
        v.setBlue(this.readFloat());
    }

    public Colorf readColor3f() throws IOException {
        Colorf v = new Colorf();
        this.readColor3f(v);
        return v;
    }

    public void readQuat(Quaternion4f v) throws IOException {
        v.setA(this.readFloat());
        v.setB(this.readFloat());
        v.setC(this.readFloat());
        v.setD(this.readFloat());
    }

    public Quaternion4f readQuat4f() throws IOException {
        Quaternion4f v = new Quaternion4f();
        this.readQuat(v);
        return v;
    }

    public void readMatrix(Matrix3f v) throws IOException {
        v.m00(this.readFloat());
        v.m01(this.readFloat());
        v.m02(this.readFloat());
        v.m10(this.readFloat());
        v.m11(this.readFloat());
        v.m12(this.readFloat());
        v.m20(this.readFloat());
        v.m21(this.readFloat());
        v.m22(this.readFloat());
    }

    public void readMatrix(Matrix4f v) throws IOException {
        v.m00(this.readFloat());
        v.m01(this.readFloat());
        v.m02(this.readFloat());
        v.m03(this.readFloat());
        v.m10(this.readFloat());
        v.m11(this.readFloat());
        v.m12(this.readFloat());
        v.m13(this.readFloat());
        v.m20(this.readFloat());
        v.m21(this.readFloat());
        v.m22(this.readFloat());
        v.m23(this.readFloat());
        v.m30(this.readFloat());
        v.m31(this.readFloat());
        v.m32(this.readFloat());
        v.m33(this.readFloat());
    }

    public Matrix3f readMatrix3f() throws IOException {
        Matrix3f m = new Matrix3f();
        this.readMatrix(m);
        return m;
    }

    public Matrix4f readMatrix4f() throws IOException {
        Matrix4f m = new Matrix4f();
        this.readMatrix(m);
        return m;
    }

    public void readTexCoord(TexCoord2f v) throws IOException {
        v.setS(this.readFloat());
        v.setT(this.readFloat());
    }

    public TexCoord2f readTexCoord() throws IOException {
        TexCoord2f c = new TexCoord2f();
        this.readTexCoord(c);
        return c;
    }

    public BufferedImage readImage() throws IOException {
        BufferedImage b = null;
        int w = this.readInt();
        if (w != 0) {
            int h = this.readInt();
            int ttype = this.readInt();
            int[] pixels = this.readIntArray();
            b = new BufferedImage(w, h, ttype);
            b.setRGB(0, 0, w, h, pixels, 0, w);
        }
        return b;
    }

    public DirectBufferedImage readDirectImage() throws IOException {
        DirectBufferedImage dbi = null;
        int w = this.readInt();
        if (w != 0) {
            int h = this.readInt();
            int ttype = this.readInt();
            switch (ttype) {
                case 0: {
                    dbi = DirectBufferedImage.makeDirectImageRGB((int)w, (int)h);
                    break;
                }
                case 1: {
                    dbi = DirectBufferedImage.makeDirectImageRGBA((int)w, (int)h);
                    break;
                }
                case 2: {
                    dbi = DirectBufferedImage.makeDirectImageOneByte((int)w, (int)h);
                }
            }
            int numBytes = dbi.getNumBytes();
            ByteBuffer bb = dbi.getByteBuffer();
            for (int i = 0; i < numBytes; ++i) {
                byte b = this.readByte();
                bb.put(i, b);
            }
        }
        return dbi;
    }

    public BufferedImage readLossyImage() throws IOException {
        BufferedImage b = null;
        int w = this.readInt();
        if (w != 0) {
            int size = this.readInt();
            byte[] buf = new byte[size];
            this.readFully(buf);
            ByteArrayInputStream in = new ByteArrayInputStream(buf, 0, size);
            JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
            b = decoder.decodeAsBufferedImage();
        }
        return b;
    }
}

