/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.io;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;
import org.jagatoo.image.DirectBufferedImage;
import org.jagatoo.util.image.ImageUtility;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.io.Scribable;
import org.xith3d.io.Scribe;
import org.xith3d.io.UnscribableNodeEncountered;
import org.xith3d.utility.logging.X3DLog;

public class ScribeOutputStream
extends DataOutputStream {
    protected static final int CLASS_REF = 10000;
    protected static final int CLASS_DEF = 10001;
    private Map<String, Integer> map = new HashMap<String, Integer>();
    private byte[] byteBuffer = null;
    private FloatBuffer floatBuffer = null;
    private ByteBuffer bBuffer = null;
    private IntBuffer intBuffer = null;
    private ShortBuffer shortBuffer = null;

    public ScribeOutputStream(OutputStream stream) {
        super(stream);
    }

    private void clutchByteBuffer(int size) {
        if (this.bBuffer != null && this.bBuffer.capacity() >= size) {
            return;
        }
        this.byteBuffer = new byte[size];
        this.bBuffer = ByteBuffer.wrap(this.byteBuffer);
        this.floatBuffer = null;
        this.intBuffer = null;
        this.shortBuffer = null;
    }

    private void clutchFloatBuffer(int size) {
        this.clutchByteBuffer(size * 4);
        if (this.floatBuffer != null && this.floatBuffer.capacity() >= size) {
            this.floatBuffer.rewind();
            return;
        }
        this.floatBuffer = this.bBuffer.asFloatBuffer();
    }

    private void clutchIntBuffer(int size) {
        this.clutchByteBuffer(size * 4);
        if (this.intBuffer != null && this.intBuffer.capacity() >= size) {
            this.intBuffer.rewind();
            return;
        }
        this.intBuffer = this.bBuffer.asIntBuffer();
    }

    private void clutchShortBuffer(int size) {
        this.clutchByteBuffer(size * 2);
        if (this.shortBuffer != null && this.shortBuffer.capacity() >= size) {
            this.shortBuffer.rewind();
            return;
        }
        this.shortBuffer = this.bBuffer.asShortBuffer();
    }

    public void writeScribable(Scribable o) throws IOException, UnscribableNodeEncountered {
        String key = o.getClass().getName();
        X3DLog.debug("Saving class ", key);
        Integer ref = this.map.get(key);
        if (ref == null) {
            ref = new Integer(this.map.size());
            X3DLog.debug("   Not found, assigning to ref ", ref);
            this.map.put(key, ref);
            this.writeInt(10001);
            this.writeUTF(key);
        } else {
            X3DLog.debug("   Found, assigning to ref ", ref);
            this.writeInt(10000);
            this.writeInt(ref);
        }
        o.save(this);
    }

    public void writeFloatArray(float[] data, int len) throws IOException {
        this.writeInt(len);
        if (Scribe.useNIO) {
            this.clutchFloatBuffer(len);
            this.floatBuffer.put(data, 0, len);
            this.write(this.byteBuffer, 0, len * 4);
        } else {
            for (int i = 0; i < len; ++i) {
                this.writeFloat(data[i]);
            }
        }
    }

    public void writeFloatArray(float[] data) throws IOException {
        this.writeFloatArray(data, data.length);
    }

    public void writeByteArray(byte[] data, int len) throws IOException {
        this.writeInt(len);
        if (Scribe.useNIO) {
            this.write(data, 0, len);
        } else {
            for (int i = 0; i < len; ++i) {
                this.writeByte(data[i]);
            }
        }
    }

    public void writeByteArray(byte[] data) throws IOException {
        this.writeByteArray(data, data.length);
    }

    public void writeVectorArray(Vector3f[] data, int len) throws IOException {
        this.writeInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeVector(data[i]);
        }
    }

    public void writeVectorArray(Vector3f[] data) throws IOException {
        this.writeVectorArray(data, data.length);
    }

    public void writeIntArray(int[] data, int len) throws IOException {
        this.writeInt(len);
        if (Scribe.useNIO) {
            this.clutchIntBuffer(len);
            this.intBuffer.put(data, 0, len);
            this.write(this.byteBuffer, 0, len * 4);
        } else {
            for (int i = 0; i < len; ++i) {
                this.writeInt(data[i]);
            }
        }
    }

    public void writeShortArray(short[] data, int len) throws IOException {
        this.writeInt(len);
        if (Scribe.useNIO) {
            this.clutchShortBuffer(len);
            this.shortBuffer.put(data, 0, len);
            this.write(this.byteBuffer, 0, len * 2);
        } else {
            for (int i = 0; i < len; ++i) {
                this.writeFloat(data[i]);
            }
        }
    }

    public void writeIntArray(int[] data) throws IOException {
        this.writeIntArray(data, data.length);
    }

    public void writeShortArray(short[] data) throws IOException {
        this.writeShortArray(data, data.length);
    }

    public void writeString(String s) throws IOException {
        this.writeInt(s.length());
        this.writeBytes(s);
    }

    public void writePoint(Point3f p) throws IOException {
        this.writeFloat(p.getX());
        this.writeFloat(p.getY());
        this.writeFloat(p.getZ());
    }

    public void writeVector(Vector3f v) throws IOException {
        this.writeFloat(v.getX());
        this.writeFloat(v.getY());
        this.writeFloat(v.getZ());
    }

    public void writeColor3f(Colorf v) throws IOException {
        this.writeFloat(v.getRed());
        this.writeFloat(v.getGreen());
        this.writeFloat(v.getBlue());
    }

    public void writeQuat(Quaternion4f v) throws IOException {
        this.writeFloat(v.getA());
        this.writeFloat(v.getB());
        this.writeFloat(v.getC());
        this.writeFloat(v.getD());
    }

    public void writeTexCoord(TexCoord2f v) throws IOException {
        this.writeFloat(v.getS());
        this.writeFloat(v.getT());
    }

    public void writeMatrix(Matrix3f v) throws IOException {
        this.writeFloat(v.m00());
        this.writeFloat(v.m01());
        this.writeFloat(v.m02());
        this.writeFloat(v.m10());
        this.writeFloat(v.m11());
        this.writeFloat(v.m12());
        this.writeFloat(v.m20());
        this.writeFloat(v.m21());
        this.writeFloat(v.m22());
    }

    public void writeMatrix(Matrix4f v) throws IOException {
        this.writeFloat(v.m00());
        this.writeFloat(v.m01());
        this.writeFloat(v.m02());
        this.writeFloat(v.m03());
        this.writeFloat(v.m10());
        this.writeFloat(v.m11());
        this.writeFloat(v.m12());
        this.writeFloat(v.m13());
        this.writeFloat(v.m20());
        this.writeFloat(v.m21());
        this.writeFloat(v.m22());
        this.writeFloat(v.m23());
        this.writeFloat(v.m30());
        this.writeFloat(v.m31());
        this.writeFloat(v.m32());
        this.writeFloat(v.m33());
    }

    public void writeDirectImage(DirectBufferedImage dbi) throws IOException {
        if (dbi != null) {
            int w = dbi.getWidth();
            int h = dbi.getHeight();
            this.writeInt(w);
            this.writeInt(h);
            this.writeInt(dbi.getDirectType().ordinal());
            byte[] bytes = ImageUtility.toByteArray((BufferedImage)dbi);
            this.write(bytes, 0, bytes.length);
        } else {
            this.writeInt(0);
        }
    }

    public void writeImage(BufferedImage b) throws IOException {
        if (b != null) {
            int w = b.getWidth();
            int h = b.getHeight();
            int[] pixels = new int[w * h];
            b.getRGB(0, 0, w, h, pixels, 0, w);
            this.writeInt(w);
            this.writeInt(h);
            this.writeInt(b.getType());
            this.writeIntArray(pixels);
        } else {
            this.writeInt(0);
        }
    }

    public void writeLossyImage(BufferedImage b, float quality) throws IOException {
        if (b != null) {
            this.writeInt(1);
            int w = b.getWidth();
            int h = b.getHeight();
            ByteArrayOutputStream out = new ByteArrayOutputStream(w * h * 4);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(b);
            param.setQuality(quality, false);
            encoder.setJPEGEncodeParam(param);
            encoder.encode(b);
            byte[] buf = out.toByteArray();
            int size = out.size();
            this.writeInt(size);
            this.write(buf, 0, size);
            out.close();
        } else {
            this.writeInt(0);
        }
    }
}

