/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.io;

import java.io.IOException;
import java.util.Random;
import org.xith3d.io.Scribable;
import org.xith3d.io.ScribeInputStream;
import org.xith3d.io.ScribeOutputStream;

public class TestScribable
implements Scribable {
    private byte[] buffer;
    private long checksum;
    private int size;

    public long getCheckSum() {
        return this.checksum;
    }

    public void save(ScribeOutputStream out) throws IOException {
        out.writeInt(this.size);
        out.write(this.buffer);
        out.writeLong(this.checksum);
    }

    public void load(ScribeInputStream in) throws IOException {
        this.size = in.readInt();
        this.buffer = new byte[this.size];
        in.read(this.buffer);
        this.checksum = in.readLong();
        long cs = 0L;
        for (int i = 0; i < this.size; ++i) {
            cs += (long)this.buffer[i];
        }
        if (cs != this.checksum) {
            throw new Error("corrupted scribable object");
        }
    }

    public TestScribable(int size) throws IOException {
        this.buffer = new byte[size];
        this.size = size;
        Random r = new Random(1289428L);
        this.checksum = 0L;
        for (int i = 0; i < size; ++i) {
            this.buffer[i] = (byte)r.nextInt(255);
            this.checksum += (long)this.buffer[i];
        }
    }

    public TestScribable() {
    }
}

