/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jagatoo.datatypes.NamedObject;
import org.openmali.spatial.bodies.Frustum;
import org.openmali.vecmath2.Matrix4f;
import org.xith3d.loaders.models.animations.AnimationListener;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.loaders.models.animations._Anim_PrivilegedAccess;
import org.xith3d.loaders.models.util.meta.ModelMetaData;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.scenegraph.Fog;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Sound;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.UpdatableNode;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.SkyBox;
import org.xith3d.scenegraph.utils.CopyListener;
import org.xith3d.utility.geometry.NormalsVisualizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model
extends Group
implements UpdatableNode {
    private static final boolean debug = false;
    private static boolean defaultPickHostValue = true;
    private TransformGroup[] nestedTransforms = null;
    private Shape3D[] shapes = null;
    private NormalsVisualizer[] nvs;
    private Light[] lights = null;
    private Fog[] fogs = null;
    private Sound[] sounds = null;
    private View[] cameras = null;
    private Matrix4f[] spawnTransforms = null;
    private GroupNode mainSceneGroup = null;
    private SkyBox skyBox = null;
    private TreeMap<String, NamedObject> namedObjects = null;
    private final HashMap<String, ModelAnimation> animsMap = new HashMap();
    private ModelAnimation[] anims = null;
    private TransformGroup[] mountTransforms = null;
    private ModelMetaData metaData = null;
    private float animationStartTime = -1.0f;
    private ModelAnimation currentAnimation = null;
    private final ArrayList<AnimationListener> animListeners = new ArrayList();
    private boolean finishedFired = false;

    public static void setDefaultPickHost(boolean value) {
        defaultPickHostValue = value;
    }

    public static boolean getDefaultPickHost() {
        return defaultPickHostValue;
    }

    protected void setNestedTransforms(TransformGroup[] nestedTransforms) {
        this.nestedTransforms = nestedTransforms;
    }

    public final TransformGroup getNestedTransform(int index) {
        return this.nestedTransforms[index];
    }

    public final TransformGroup[] getNestedTransforms() {
        return this.nestedTransforms;
    }

    protected void setShapes(Shape3D[] shapes) {
        this.shapes = shapes;
    }

    public final int getShapesCount() {
        if (this.shapes == null) {
            return 0;
        }
        return this.shapes.length;
    }

    public final Shape3D getShape(int index) {
        return this.shapes[index];
    }

    public final Shape3D[] getShapes() {
        return this.shapes;
    }

    protected void setLights(Light[] lights) {
        this.lights = lights;
    }

    public final int getLightsCount() {
        if (this.lights == null) {
            return 0;
        }
        return this.lights.length;
    }

    public final Light getLight(int index) {
        return this.lights[index];
    }

    public final Light[] getLights() {
        return this.lights;
    }

    protected void setFogs(Fog[] fogs) {
        this.fogs = fogs;
    }

    public final int getFogsCount() {
        if (this.fogs == null) {
            return 0;
        }
        return this.fogs.length;
    }

    public final Fog getFog(int index) {
        return this.fogs[index];
    }

    public final Fog[] getFogs() {
        return this.fogs;
    }

    protected void setSounds(Sound[] sounds) {
        this.sounds = sounds;
    }

    public final int getSoundsCount() {
        if (this.sounds == null) {
            return 0;
        }
        return this.sounds.length;
    }

    public final Sound getSound(int index) {
        return this.sounds[index];
    }

    public final Sound[] getSounds() {
        return this.sounds;
    }

    protected void setCameras(View[] cameras) {
        this.cameras = cameras;
    }

    public final int getCamerasCount() {
        if (this.cameras == null) {
            return 0;
        }
        return this.cameras.length;
    }

    public final View getCamera(int index) {
        return this.cameras[index];
    }

    public final View[] getCameras() {
        return this.cameras;
    }

    protected void setSpawnTransforms(Matrix4f[] spawnTransforms) {
        this.spawnTransforms = spawnTransforms;
    }

    public final int getSpawnTransformsCount() {
        if (this.spawnTransforms == null) {
            return 0;
        }
        return this.spawnTransforms.length;
    }

    public final Matrix4f getSpawnTransform(int index) {
        return this.spawnTransforms[index];
    }

    public final Matrix4f[] getSpawnTransforms() {
        return this.spawnTransforms;
    }

    protected void setMainGroup(GroupNode mainGroup) {
        this.mainSceneGroup = mainGroup;
    }

    public final GroupNode getMainGroup() {
        return this.mainSceneGroup;
    }

    protected void setSkyBox(SkyBox skyBox) {
        this.skyBox = skyBox;
    }

    public final SkyBox getSkyBox() {
        return this.skyBox;
    }

    protected void addNamedObject(String name, NamedObject object) {
        NamedObject existingObject;
        if (this.namedObjects == null) {
            this.namedObjects = new TreeMap();
        }
        if ((existingObject = this.namedObjects.get(name)) == null) {
            this.namedObjects.put(name, object);
        } else if (existingObject != object) {
            int nameIndex = 1;
            boolean done = false;
            while (!done) {
                String tempName = name + "[" + nameIndex + "]";
                if (this.namedObjects.get(tempName) == null) {
                    this.namedObjects.put(tempName, object);
                    done = true;
                }
                ++nameIndex;
            }
        }
    }

    public final int getNamedObjectsCount() {
        if (this.namedObjects == null) {
            return 0;
        }
        return this.namedObjects.size();
    }

    public final Map<String, NamedObject> getNamedObjects() {
        return this.namedObjects;
    }

    public final NamedObject getNamedObject(String name) {
        if (this.namedObjects == null) {
            return null;
        }
        return this.namedObjects.get(name);
    }

    public void dumpNamedObjects(boolean printValues) {
        if (this.namedObjects == null) {
            System.out.println("[No named objects]");
        } else {
            for (String name : this.namedObjects.keySet()) {
                if (printValues) {
                    System.out.println("\"" + name + "\": " + this.namedObjects.get(name));
                    continue;
                }
                System.out.println("\"" + name + "\"");
            }
        }
    }

    public void setMetaData(ModelMetaData metaData) {
        this.metaData = metaData;
    }

    public final ModelMetaData getMetaData() {
        return this.metaData;
    }

    public void setMountTransforms(TransformGroup[] mountTransforms) {
        int i;
        if (this.mountTransforms != null) {
            for (i = this.mountTransforms.length - 1; i >= 0; --i) {
                this.removeChild(this.mountTransforms[i]);
            }
        }
        this.mountTransforms = mountTransforms;
        if (this.mountTransforms != null) {
            for (i = 0; i < this.mountTransforms.length; ++i) {
                this.addChild(this.mountTransforms[i]);
            }
        }
    }

    public final int getMountTransformsCount() {
        if (this.mountTransforms == null) {
            return 0;
        }
        return this.mountTransforms.length;
    }

    public final TransformGroup[] getMountTransforms() {
        return this.mountTransforms;
    }

    public final TransformGroup getMountTransform(int index) {
        return this.mountTransforms[index];
    }

    public final TransformGroup getMountTransform(String name) {
        for (int i = 0; i < this.mountTransforms.length; ++i) {
            if (!this.mountTransforms[i].getName().equals(name)) continue;
            return this.mountTransforms[i];
        }
        return null;
    }

    public void addAnimationListener(AnimationListener l) {
        this.animListeners.add(l);
    }

    public void removeAnimationListener(AnimationListener l) {
        this.animListeners.remove(l);
    }

    protected final void fireOnAnimationStarted(ModelAnimation anim) {
        if (anim != null) {
            for (int i = 0; i < this.animListeners.size(); ++i) {
                this.animListeners.get(i).onAnimationStarted(anim);
            }
            this.finishedFired = false;
        }
    }

    protected final void fireOnAnimationFinished(ModelAnimation anim) {
        if (anim != null && !this.finishedFired) {
            this.finishedFired = true;
            for (int i = 0; i < this.animListeners.size(); ++i) {
                this.animListeners.get(i).onAnimationFinished(anim);
            }
        }
    }

    private void addAnimation(ModelAnimation anim) {
        if (this.animsMap.containsKey(anim.getName())) {
            return;
        }
        _Anim_PrivilegedAccess.setModel(this, anim);
        this.animsMap.put(anim.getName(), anim);
        if (this.anims == null) {
            this.anims = new ModelAnimation[64];
        } else if (this.anims.length < this.animsMap.size()) {
            ModelAnimation[] tmp = new ModelAnimation[(int)((double)(this.anims.length + 1) * 1.5)];
            System.arraycopy(this.anims, 0, tmp, 0, this.anims.length);
            this.anims = tmp;
        }
        this.anims[this.animsMap.size() - 1] = anim;
    }

    public void setAnimations(ModelAnimation[] anims) {
        this.animsMap.clear();
        this.anims = null;
        for (int i = 0; i < anims.length; ++i) {
            this.addAnimation(anims[i]);
        }
    }

    public final boolean hasAnimations() {
        return !this.animsMap.isEmpty();
    }

    public final int getAnimationsCount() {
        return this.animsMap.size();
    }

    public ModelAnimation[] getAnimations() {
        if (this.animsMap.size() == 0) {
            return null;
        }
        if (this.anims.length != this.animsMap.size()) {
            ModelAnimation[] tmp = new ModelAnimation[this.animsMap.size()];
            System.arraycopy(this.anims, 0, tmp, 0, this.animsMap.size());
            this.anims = tmp;
        }
        return this.anims;
    }

    public ModelAnimation getAnimation(int index) {
        if (index >= this.animsMap.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.anims[index];
    }

    public ModelAnimation getAnimation(String name) {
        return this.animsMap.get(name);
    }

    public final void dumpAnimations() {
        if (this.animsMap.size() == 0) {
            System.out.println("This model doesn't have any animations.");
            return;
        }
        for (int i = 0; i < this.anims.length; ++i) {
            System.out.println(this.anims[i]);
        }
    }

    public void setCurrentAnimation(ModelAnimation anim) {
        if (this.getCurrentAnimation() != null && this.animationStartTime >= 0.0f) {
            this.fireOnAnimationFinished(this.getCurrentAnimation());
        }
        this.currentAnimation = anim;
        this.animationStartTime = -1.0f;
        if (anim != null) {
            anim.reset();
            this.fireOnAnimationStarted(anim);
        }
    }

    public final void setCurrentAnimation(String name) {
        this.setCurrentAnimation(this.animsMap.get(name));
    }

    public final void setCurrentAnimation(int index) {
        this.setCurrentAnimation(this.anims[index]);
    }

    public final ModelAnimation getCurrentAnimation() {
        return this.currentAnimation;
    }

    public void interpolateAnimation(float animStartTime, float absAnimTime) {
        if (this.getCurrentAnimation() == null) {
            return;
        }
        ModelAnimation anim = this.getCurrentAnimation();
        if (anim.update(false, absAnimTime, this.getMountTransforms())) {
            this.fireOnAnimationFinished(anim);
            this.fireOnAnimationStarted(anim);
        }
    }

    @Override
    public boolean update(View view, Frustum frustum, long nanoTime, long nanoStep) {
        if (this.getCurrentAnimation() != null) {
            float gameSeconds = UpdatingThread.TimingMode.NANOSECONDS.getSecondsAsFloat(nanoTime);
            if (this.animationStartTime < 0.0f) {
                this.animationStartTime = gameSeconds;
            }
            this.interpolateAnimation(this.animationStartTime, gameSeconds - this.animationStartTime);
        }
        return true;
    }

    public Model getSharedInstance() {
        final Model newModel = new Model();
        final ArrayList newNestedTransforms = new ArrayList();
        final ArrayList newShapes = new ArrayList();
        final ArrayList newLights = new ArrayList();
        final ArrayList newFogs = new ArrayList();
        final ArrayList newSounds = new ArrayList();
        CopyListener listener = new CopyListener(){

            public void onNodeCopied(Node original, Node newInstance, boolean shared) {
                if (original == Model.this.mainSceneGroup) {
                    newModel.mainSceneGroup = (GroupNode)newInstance;
                }
                if (newInstance instanceof TransformGroup) {
                    newNestedTransforms.add((TransformGroup)newInstance);
                } else if (newInstance instanceof Shape3D) {
                    newShapes.add((Shape3D)newInstance);
                } else if (newInstance instanceof Light) {
                    newLights.add((Light)newInstance);
                } else if (newInstance instanceof Fog) {
                    newFogs.add((Fog)newInstance);
                } else if (newInstance instanceof Sound) {
                    newSounds.add((Sound)newInstance);
                }
                if (newInstance.getName() != null && newInstance.getName().length() > 0) {
                    newModel.addNamedObject(newInstance.getName(), (NamedObject)newInstance);
                }
            }
        };
        for (int i = 0; i < this.numChildren(); ++i) {
            newModel.addChild(this.getChild(i).sharedCopy(listener));
        }
        if (newNestedTransforms.size() > 0) {
            newModel.setNestedTransforms(newNestedTransforms.toArray(new TransformGroup[newNestedTransforms.size()]));
        }
        newModel.setShapes(newShapes.toArray(new Shape3D[newShapes.size()]));
        if (newLights.size() > 0) {
            newModel.setLights(newLights.toArray(new Light[newLights.size()]));
        }
        if (newFogs.size() > 0) {
            newModel.setFogs(newFogs.toArray(new Fog[newFogs.size()]));
        }
        if (newSounds.size() > 0) {
            newModel.setSounds(newSounds.toArray(new Sound[newSounds.size()]));
        }
        newModel.setCameras(this.getCameras());
        newModel.setSpawnTransforms(this.getSpawnTransforms());
        newModel.setSkyBox(this.getSkyBox());
        if (this.hasAnimations()) {
            for (ModelAnimation animation : this.getAnimations()) {
                newModel.addAnimation(animation.getSharedCopy(newModel.getNamedObjects()));
            }
        }
        if (this.getMountTransforms() != null) {
            TransformGroup[] newMTs = new TransformGroup[this.getMountTransformsCount()];
            for (int i = 0; i < this.getMountTransformsCount(); ++i) {
                newMTs[i] = new TransformGroup(this.getMountTransform(i).getTransform());
            }
        }
        return newModel;
    }

    public Model() {
        this.setPickHost(defaultPickHostValue);
    }
}

