/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.animations;

import java.util.Map;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationType;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.util.FloatUtils;
import org.xith3d.loaders.models.animations.Bone;
import org.xith3d.loaders.models.animations.BoneAnimationKeyFrame;
import org.xith3d.loaders.models.animations.BoneWeight;
import org.xith3d.loaders.models.animations.KeyFrameController;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedGeometryArray;
import org.xith3d.scenegraph.Shape3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoneAnimationKeyFrameController
extends KeyFrameController {
    private int lastFrame = -1;
    private final Shape3D shape;
    private final float[] coords;
    private final float[] normals;
    private final BoneWeight[][] weights;

    public final BoneAnimationKeyFrame getFrame(int index) {
        return (BoneAnimationKeyFrame)this.getKeyFrame(index);
    }

    @Override
    public final Shape3D getTarget() {
        return this.shape;
    }

    private void computeNormals(Geometry geom) {
        Vector3f tmp = new Vector3f();
        int[] index = ((IndexedGeometryArray)geom).getIndex();
        int numTriangles = index.length / 3;
        for (int i = 0; i < numTriangles; ++i) {
            int i3 = i * 3;
            int a = index[i3 + 0] * 3;
            int b = index[i3 + 1] * 3;
            int c = index[i3 + 2] * 3;
            float vecACx = this.coords[c + 0] - this.coords[a + 0];
            float vecACy = this.coords[c + 1] - this.coords[a + 1];
            float vecACz = this.coords[c + 2] - this.coords[a + 2];
            float vecABx = this.coords[b + 0] - this.coords[a + 0];
            float vecABy = this.coords[b + 1] - this.coords[a + 1];
            float vecABz = this.coords[b + 2] - this.coords[a + 2];
            FloatUtils.cross((float)vecACx, (float)vecACy, (float)vecACz, (float)vecABx, (float)vecABy, (float)vecABz, (Tuple3f)tmp);
            tmp.normalize();
            this.normals[index[i3 + 0] * 3 + 0] = tmp.getX();
            this.normals[index[i3 + 0] * 3 + 1] = tmp.getY();
            this.normals[index[i3 + 0] * 3 + 2] = tmp.getZ();
            this.normals[index[i3 + 1] * 3 + 0] = tmp.getX();
            this.normals[index[i3 + 1] * 3 + 1] = tmp.getY();
            this.normals[index[i3 + 1] * 3 + 2] = tmp.getZ();
            this.normals[index[i3 + 2] * 3 + 0] = tmp.getX();
            this.normals[index[i3 + 2] * 3 + 1] = tmp.getY();
            this.normals[index[i3 + 2] * 3 + 2] = tmp.getZ();
        }
        geom.setNormals(0, this.normals);
    }

    @Override
    public void reset() {
        this.lastFrame = -1;
    }

    @Override
    protected boolean checkUpdateConditions(boolean forced, float absAnimTime, int frame, float animDuration) {
        if (!forced && frame == this.lastFrame) {
            return false;
        }
        this.lastFrame = frame;
        return true;
    }

    @Override
    protected void updateTarget(float absAnimType, int baseFrame, int nextFrame, float alpha, ModelAnimation animation) {
        int frame = alpha < 0.5f ? baseFrame : nextFrame;
        Geometry geom = this.shape.getGeometry();
        Bone[] skeleton = this.getFrame(frame).getSkeleton();
        Point3f tmp = Point3f.fromPool();
        for (int i = 0; i < geom.getVertexCount(); ++i) {
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            for (int j = 0; j < this.weights[i].length; ++j) {
                BoneWeight weight = this.weights[i][j];
                Bone bone = skeleton[weight.getBoneIndex()];
                bone.getRotation().transform((Tuple3f)weight.getOffset(), (Tuple3f)tmp);
                x += (bone.getTranslation().getX() + tmp.getX()) * weight.getWeight();
                y += (bone.getTranslation().getY() + tmp.getY()) * weight.getWeight();
                z += (bone.getTranslation().getZ() + tmp.getZ()) * weight.getWeight();
            }
            this.coords[i * 3 + 0] = x;
            this.coords[i * 3 + 1] = y;
            this.coords[i * 3 + 2] = z;
        }
        Point3f.toPool((Point3f)tmp);
        geom.setCoordinates(0, this.coords);
        this.shape.updateBounds(false);
        this.computeNormals(geom);
    }

    @Override
    public BoneAnimationKeyFrameController sharedCopy(Map<String, NamedObject> namedObjects) {
        String shapeName = this.shape.getName();
        Shape3D newShape = (Shape3D)namedObjects.get(shapeName);
        if (newShape == null) {
            throw new Error("Can't clone this AnimationController!");
        }
        return new BoneAnimationKeyFrameController((BoneAnimationKeyFrame[])this.getKeyFrames(), this.weights, newShape);
    }

    public BoneAnimationKeyFrameController(BoneAnimationKeyFrame[] frames, BoneWeight[][] weights, Shape3D shape) {
        super(AnimationType.SKELETAL, frames);
        this.weights = weights;
        this.shape = shape;
        this.coords = new float[shape.getGeometry().getVertexCount() * 3];
        this.normals = new float[shape.getGeometry().getVertexCount() * 3];
    }
}

