/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.animations;

import java.util.Map;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.util.arrays.ArrayUtils;
import org.openmali.vecmath2.Matrix4f;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.animations.KeyFrameController;
import org.xith3d.scenegraph.TransformGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelAnimation {
    private Model model = null;
    private final Object animPrototype;
    private KeyFrameController[] controllers = null;
    private Matrix4f[][] mountTransformFrames = null;
    private final String name;
    private final int numFrames;
    private float fps;
    private float frameDuration;
    private float duration;
    private boolean animLoopNotified = false;
    private ModelAnimation[] attachedAnimations = null;

    void setModel(Model model) {
        this.model = model;
    }

    public final Model getModel() {
        return this.model;
    }

    public final KeyFrameController[] getControllers() {
        return this.controllers;
    }

    public void setMountTransformFrames(Matrix4f[][] mountTransformFrames) {
        this.mountTransformFrames = mountTransformFrames;
    }

    public final Matrix4f[][] getMountTransformFrames() {
        return this.mountTransformFrames;
    }

    public final Matrix4f[] getMountTransformFrame(int index) {
        if (this.mountTransformFrames == null) {
            return null;
        }
        return this.mountTransformFrames[index];
    }

    @Deprecated
    public Object getPrototype() {
        return this.animPrototype;
    }

    public final String getName() {
        return this.name;
    }

    public final int getNumFrames() {
        return this.numFrames;
    }

    public void setFPS(float fps) {
        this.fps = fps;
        this.frameDuration = 1.0f / fps;
        this.duration = (float)this.numFrames / fps;
    }

    public final float getFPS() {
        return this.fps;
    }

    public final float getFrameDuration() {
        return this.frameDuration;
    }

    public final float getDuration() {
        return this.duration;
    }

    public void attachAnimation(ModelAnimation anim) {
        if (this.attachedAnimations == null) {
            this.attachedAnimations = new ModelAnimation[]{anim};
        } else {
            ModelAnimation[] attachedAnimations2 = new ModelAnimation[this.attachedAnimations.length + 1];
            System.arraycopy(this.attachedAnimations, 0, attachedAnimations2, 0, this.attachedAnimations.length);
            attachedAnimations2[attachedAnimations2.length - 1] = anim;
            this.attachedAnimations = attachedAnimations2;
        }
    }

    public void detachAnimation(ModelAnimation anim) {
        if (this.attachedAnimations == null) {
            return;
        }
        int index = ArrayUtils.indexOf((Object[])this.attachedAnimations, (Object)anim, (boolean)true);
        if (index < 0) {
            return;
        }
        if (this.attachedAnimations.length == 1) {
            this.attachedAnimations = null;
            return;
        }
        ModelAnimation[] attachedAnimations2 = new ModelAnimation[this.attachedAnimations.length - 1];
        System.arraycopy(this.attachedAnimations, 0, attachedAnimations2, 0, index);
        System.arraycopy(this.attachedAnimations, index + 1, attachedAnimations2, index, this.attachedAnimations.length - index - 1);
        this.attachedAnimations = attachedAnimations2;
    }

    protected ModelAnimation[] getAttachedAnimations() {
        return this.attachedAnimations;
    }

    public void reset() {
        this.animLoopNotified = false;
        if (this.controllers != null) {
            for (int i = 0; i < this.controllers.length; ++i) {
                this.controllers[i].reset();
            }
        }
    }

    protected void updateMountTransforms(int baseFrame, int nextFrame, float alpha, TransformGroup[] mountTransforms) {
        if (mountTransforms != null) {
            Matrix4f m = Matrix4f.fromPool();
            for (int i = 0; i < mountTransforms.length; ++i) {
                if (mountTransforms[i].numChildren() <= 0) continue;
                Matrix4f m0 = this.getMountTransformFrame(baseFrame)[i];
                Matrix4f m1 = this.getMountTransformFrame(nextFrame)[i];
                if (m0 == null || m1 == null) continue;
                m.interpolate(m0, m1, alpha);
                mountTransforms[i].getTransform().set(m);
                mountTransforms[i].updateTransform();
            }
            Matrix4f.toPool((Matrix4f)m);
        }
    }

    protected void updateAttachedAnimations(boolean forced, float absAnimTime, int baseFrame, int nextFrame, float alpha) {
        if (this.attachedAnimations != null) {
            for (int i = 0; i < this.attachedAnimations.length; ++i) {
                ModelAnimation attachedAnimation = this.attachedAnimations[i];
                float absAnimTime2 = absAnimTime * attachedAnimation.getDuration() / this.getDuration();
                attachedAnimation.update(forced, absAnimTime2, attachedAnimation.getModel().getMountTransforms());
            }
        }
    }

    public boolean update(boolean forced, float absAnimTime, TransformGroup[] mountTransforms) {
        float normedAbsAnimTime = absAnimTime % this.getDuration();
        float time = normedAbsAnimTime / this.getDuration();
        float frameDuration = this.getDuration() / (float)this.getNumFrames();
        int baseFrame = (int)((float)this.getNumFrames() * time);
        int nextFrame = (baseFrame + 1) % this.getNumFrames();
        float frameT = normedAbsAnimTime % this.getDuration() - (float)baseFrame * frameDuration;
        float alpha = frameT / frameDuration;
        if (this.controllers != null) {
            for (int i = 0; i < this.controllers.length; ++i) {
                KeyFrameController controller = this.controllers[i];
                if (controller.getNumFrames() == 1) {
                    controller.update(forced, normedAbsAnimTime, 0, 0, 0.5f, this);
                    continue;
                }
                if (controller.getNumFrames() == this.getNumFrames()) {
                    controller.update(forced, normedAbsAnimTime, baseFrame, nextFrame, alpha, this);
                    continue;
                }
                controller.update(forced, normedAbsAnimTime, this);
            }
        }
        this.updateMountTransforms(baseFrame, nextFrame, alpha, mountTransforms);
        this.updateAttachedAnimations(forced, normedAbsAnimTime, baseFrame, nextFrame, alpha);
        if (!this.animLoopNotified && nextFrame == 0) {
            this.animLoopNotified = true;
            return this.getNumFrames() != 1;
        }
        if (nextFrame == 1) {
            this.animLoopNotified = false;
        }
        return false;
    }

    public ModelAnimation getSharedCopy(Map<String, NamedObject> namedObjects) {
        KeyFrameController[] newAnimControllers = null;
        if (this.controllers != null) {
            newAnimControllers = new KeyFrameController[this.controllers.length];
            for (int i = 0; i < this.controllers.length; ++i) {
                newAnimControllers[i] = this.controllers[i].sharedCopy(namedObjects);
            }
        }
        return new ModelAnimation(this.getName(), this.getNumFrames(), this.getFPS(), newAnimControllers, this.getPrototype());
    }

    public String toString() {
        return "ModelAnimation{ name = \"" + this.getName() + "\", " + "numFrames = " + this.getNumFrames() + ", " + "fps = " + this.getFPS() + ", " + "duration = " + this.getDuration() + " }";
    }

    public ModelAnimation(String name, int numFrames, float fps, KeyFrameController[] controllers) {
        this.name = name;
        this.numFrames = numFrames;
        this.controllers = controllers;
        this.animPrototype = null;
        this.setFPS(fps);
    }

    @Deprecated
    public ModelAnimation(String name, int numFrames, float fps, KeyFrameController[] controllers, Object animPrototype) {
        this.name = name;
        this.numFrames = numFrames;
        this.controllers = controllers;
        this.animPrototype = animPrototype;
        this.setFPS(fps);
    }
}

