/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.animations;

import java.util.Map;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationType;
import org.xith3d.loaders.models.animations.KeyFrameController;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.loaders.models.animations.PrecomputedAnimationKeyFrame;
import org.xith3d.scenegraph.Shape3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecomputedAnimationKeyFrameController
extends KeyFrameController {
    private int lastFrame = -1;
    private final Shape3D shape;

    public final PrecomputedAnimationKeyFrame getFrame(int index) {
        return (PrecomputedAnimationKeyFrame)this.getKeyFrame(index);
    }

    @Override
    public final Shape3D getTarget() {
        return this.shape;
    }

    @Override
    public void reset() {
        this.lastFrame = -1;
    }

    @Override
    protected boolean checkUpdateConditions(boolean forced, float absAnimTime, int frame, float animDuration) {
        if (!forced && frame == this.lastFrame) {
            return false;
        }
        this.lastFrame = frame;
        return true;
    }

    @Override
    protected void updateTarget(float absAnimTime, int baseFrame, int nextFrame, float alpha, ModelAnimation animation) {
        int frame = alpha < 0.5f ? baseFrame : nextFrame;
        this.shape.setGeometry(this.getFrame(frame).getGeometry());
    }

    @Override
    public PrecomputedAnimationKeyFrameController sharedCopy(Map<String, NamedObject> namedObjects) {
        String shapeName = this.shape.getName();
        Shape3D newShape = (Shape3D)namedObjects.get(shapeName);
        if (newShape == null) {
            throw new Error("Can't clone this AnimationController!");
        }
        return new PrecomputedAnimationKeyFrameController((PrecomputedAnimationKeyFrame[])this.getKeyFrames(), newShape);
    }

    public PrecomputedAnimationKeyFrameController(PrecomputedAnimationKeyFrame[] frames, Shape3D shape) {
        super(AnimationType.PRECOMPUTED, frames);
        this.shape = shape;
    }
}

