/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.impl.cal3d.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.jagatoo.loaders.models.cal3d.core.CalCoreAnimation;
import org.jagatoo.loaders.models.cal3d.core.CalCoreModel;
import org.xith3d.loaders.models.impl.cal3d.Cal3dModel;
import org.xith3d.loaders.models.impl.cal3d.browser.AnimControlPanel;

public class AnimationBrowser
extends JPanel {
    private static final long serialVersionUID = 5018525814303707429L;
    private Cal3dModel character;
    private JPanel animsPanel;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JPanel sceneViewPanel;
    private JCheckBox skeletonVisibleCheckBox;
    private JCheckBox skinVisibleCheckBox;

    public AnimationBrowser(Cal3dModel character) {
        this.character = character;
        this.initComponents();
        this.createAnimControls();
    }

    void createAnimControls() {
        CalCoreModel model = this.character.getInternalModel().getCoreModel();
        Collection animIds = model.getCoreAnimationIds();
        for (String id : animIds) {
            CalCoreAnimation anim = model.getCoreAnimation(id);
            AnimControlPanel animControl = new AnimControlPanel(this.character, id, anim);
            this.animsPanel.add(animControl);
        }
        this.animsPanel.add(Box.createVerticalGlue());
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.sceneViewPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.animsPanel = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.skeletonVisibleCheckBox = new JCheckBox();
        this.skinVisibleCheckBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.sceneViewPanel.setLayout(new BorderLayout());
        this.jSplitPane1.setRightComponent(this.sceneViewPanel);
        this.animsPanel.setLayout(new BoxLayout(this.animsPanel, 1));
        this.jScrollPane1.setViewportView(this.animsPanel);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.add((Component)this.jSplitPane1, "Center");
        this.skeletonVisibleCheckBox.setSelected(true);
        this.skeletonVisibleCheckBox.setText("Show Skeleton");
        this.skeletonVisibleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimationBrowser.this.skeletonVisibleCheckBoxActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.skeletonVisibleCheckBox);
        this.skinVisibleCheckBox.setSelected(true);
        this.skinVisibleCheckBox.setText("Show Skin");
        this.skinVisibleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimationBrowser.this.skinVisibleCheckBoxActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.skinVisibleCheckBox);
    }

    private void skinVisibleCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void skeletonVisibleCheckBoxActionPerformed(ActionEvent evt) {
    }
}

