/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.impl.dae;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jagatoo.loaders.models.collada.datastructs.AssetFolder;
import org.jagatoo.loaders.models.collada.datastructs.effects.Effect;
import org.jagatoo.loaders.models.collada.datastructs.effects.Profile;
import org.jagatoo.loaders.models.collada.datastructs.effects.ProfileCommon;
import org.jagatoo.loaders.models.collada.datastructs.geometries.Mesh;
import org.jagatoo.loaders.models.collada.datastructs.geometries.PolygonsGeometry;
import org.jagatoo.loaders.models.collada.datastructs.geometries.TrianglesGeometry;
import org.jagatoo.loaders.models.collada.datastructs.images.Surface;
import org.jagatoo.loaders.models.collada.datastructs.materials.Material;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.AbstractInstance;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.ControllerInstance;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.GeometryInstance;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.Node;
import org.openmali.vecmath2.Matrix4f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Transform;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.TriangleArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DaeConverter {
    public static Appearance toXith3D(Material material) {
        AssetFolder file = material.getFile();
        Appearance app = new Appearance();
        app.setMaterial(new org.xith3d.scenegraph.Material(true));
        app.getMaterial().setColorTarget(org.xith3d.scenegraph.Material.AMBIENT);
        String texture = null;
        String effectUrl = material.getEffect();
        Effect effect = effectUrl.length() == 0 ? (Effect)file.getLibraryEffects().getEffects().values().iterator().next() : (Effect)file.getLibraryEffects().getEffects().get(material.getEffect());
        for (Profile profile : effect.profiles) {
            if (profile instanceof ProfileCommon) {
                ProfileCommon profileCommon = (ProfileCommon)profile;
                for (Surface surface : profileCommon.getSurfaces().values()) {
                    for (String imageId : surface.imageIds) {
                        if (texture == null) {
                            texture = (String)file.getLibraryImages().getImages().get(imageId);
                            continue;
                        }
                        System.err.println("Ignoring extra texture : " + (String)file.getLibraryImages().getImages().get(imageId));
                    }
                }
                continue;
            }
            System.err.println("Ignoring profile type : " + profile.getClass().getName());
        }
        if (texture != null) {
            try {
                app.setTexture(TextureLoader.getInstance().loadTexture(new URL(file.getBasePath().toExternalForm() + texture)));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No texture found");
        }
        if (app.getTexture() != null && app.getTexture().getFormat().hasAlpha()) {
            app.getTransparencyAttributes(true).setMode(TransparencyAttributes.BLENDED);
        }
        return app;
    }

    public static Group toXith3D(Node node, Map<AbstractInstance, Geometry> instanceMap) {
        Group grp = null;
        if (node.getTransform().getMatrixTransform().getMatrix().equals(Matrix4f.IDENTITY)) {
            grp = new Group();
        } else {
            Transform trans = new Transform();
            trans.setMatrix(node.getTransform().getMatrixTransform().getMatrix());
            grp = trans;
        }
        for (Node n : node.getChildren()) {
            grp.addChild(DaeConverter.toXith3D(n, instanceMap));
        }
        for (GeometryInstance ai : node.getGeometryInstances()) {
            grp.addChild(DaeConverter.toXith3D((AbstractInstance)ai, instanceMap));
        }
        for (GeometryInstance ai : node.getControllerInstances()) {
            grp.addChild(DaeConverter.toXith3D((AbstractInstance)ai, instanceMap));
        }
        return grp;
    }

    public static Shape3D toXith3D(AbstractInstance instance, Map<AbstractInstance, Geometry> instanceMap) {
        Geometry geom = null;
        Appearance app = null;
        if (instance instanceof GeometryInstance) {
            GeometryInstance colladaGINode = (GeometryInstance)instance;
            geom = DaeConverter.toXith3D(colladaGINode.getGeometry());
            app = DaeConverter.toXith3D(colladaGINode.getMaterial());
            instanceMap.put((AbstractInstance)colladaGINode, geom);
        } else if (instance instanceof ControllerInstance) {
            ControllerInstance colladaCINode = (ControllerInstance)instance;
            colladaCINode.getController().updateDestinationGeometry(5000L);
            geom = DaeConverter.toXith3D(colladaCINode.getController().getDestinationGeometry());
            app = DaeConverter.toXith3D(colladaCINode.getMaterial());
            instanceMap.put((AbstractInstance)colladaCINode, geom);
        } else {
            throw new Error("Type " + instance.getClass().getSimpleName() + " not implemented yet.");
        }
        return new Shape3D(geom, app);
    }

    public static Geometry toXith3D(org.jagatoo.loaders.models.collada.datastructs.geometries.Geometry geometry) {
        if (geometry instanceof PolygonsGeometry) {
            throw new Error("PolygonsGeometry isn't supported yet ! If you're e.g. exporting from blender,\n try to select the option \"Triangles\" : THAT is supported.");
        }
        if (geometry instanceof TrianglesGeometry) {
            return DaeConverter.createGeometryFromTriangles((TrianglesGeometry)geometry);
        }
        if (geometry == null) {
            throw new Error("This Geometry is null.");
        }
        throw new Error(geometry.getClass().getSimpleName() + " isn't supported yet ! If you're e.g. exporting from blender," + "\n try to select the option \"Triangles\" : THAT is supported.");
    }

    public static void update(org.jagatoo.loaders.models.collada.datastructs.geometries.Geometry geometry, Geometry xithGeometry) {
        if (geometry instanceof PolygonsGeometry) {
            throw new Error("PolygonsGeometry isn't supported yet ! If you're e.g. exporting from blender,\n try to select the option \"Triangles\" : THAT is supported.");
        }
        if (!(geometry instanceof TrianglesGeometry)) {
            if (geometry == null) {
                throw new Error("This Geometry is null.");
            }
            throw new Error(geometry.getClass().getSimpleName() + " isn't supported yet ! If you're e.g. exporting from blender," + "\n try to select the option \"Triangles\" : THAT is supported.");
        }
        DaeConverter.updateGeometryFromTriangles((TrianglesGeometry)geometry, xithGeometry);
    }

    private static void updateGeometryFromTriangles(TrianglesGeometry geometry, Geometry xithGeometry) {
        int i;
        int j;
        Mesh mesh = geometry.getMesh();
        int indexCount = mesh.getVertexIndices().length;
        float[] realVertices = null;
        if (mesh.getVertexIndices() != null) {
            realVertices = new float[indexCount * 3];
            float[] fs = mesh.getSources().getVertices();
            for (int i2 = 0; i2 < indexCount; ++i2) {
                int j2 = mesh.getVertexIndices()[i2];
                realVertices[i2 * 3] = fs[j2 * 3];
                realVertices[i2 * 3 + 1] = fs[j2 * 3 + 1];
                realVertices[i2 * 3 + 2] = fs[j2 * 3 + 2];
            }
        } else {
            throw new Error("Huh.. we have no vertices... Your file has a problem :)");
        }
        float[] realNormals = null;
        if (mesh.getNormalIndices() != null) {
            realNormals = new float[indexCount * 3];
            float[] fs = mesh.getSources().getNormals();
            for (int i3 = 0; i3 < indexCount; ++i3) {
                j = mesh.getNormalIndices()[i3];
                realNormals[i3 * 3] = fs[j * 3];
                realNormals[i3 * 3 + 1] = fs[j * 3 + 1];
                realNormals[i3 * 3 + 2] = fs[j * 3 + 2];
            }
        }
        float[] realColors = null;
        if (mesh.getColorIndices() != null) {
            realColors = new float[indexCount * 4];
            float[] fs = mesh.getSources().getColors();
            for (i = 0; i < indexCount; ++i) {
                int j3 = mesh.getColorIndices()[i];
                realColors[i * 3] = fs[j3 * 3];
                realColors[i * 3 + 1] = fs[j3 * 3 + 1];
                realColors[i * 3 + 2] = fs[j3 * 3 + 2];
                realColors[i * 3 + 3] = fs[j3 * 3 + 2];
            }
        }
        float[][] realUVs = null;
        if (mesh.getUVIndices().length > 0) {
            realUVs = new float[mesh.getUVIndices().length][indexCount * 2];
            for (j = 0; j < mesh.getUVIndices().length; ++j) {
                float[] fs = mesh.getSources().getUVs()[j];
                for (int i4 = 0; i4 < indexCount; ++i4) {
                    int k = mesh.getUVIndices()[j][i4];
                    realUVs[j][i4 * 2] = fs[k * 2];
                    realUVs[j][i4 * 2 + 1] = fs[k * 2 + 1];
                }
            }
        }
        if (mesh.getVertexIndices() != null) {
            xithGeometry.setCoordinates(0, realVertices);
        }
        if (mesh.getNormalIndices() != null) {
            xithGeometry.setNormals(0, realNormals);
        }
        if (mesh.getColorIndices() != null) {
            xithGeometry.setColors(0, 4, realColors);
        }
        if (mesh.getUVIndices().length > 0) {
            for (i = 0; i < realUVs.length; ++i) {
                xithGeometry.setTextureCoordinates(i, 0, 2, realUVs[i]);
            }
        }
    }

    private static Geometry createGeometryFromTriangles(TrianglesGeometry geometry) {
        int indexCount = geometry.getMesh().getVertexIndices().length;
        TriangleArray xithGeometry = new TriangleArray(indexCount);
        DaeConverter.updateGeometryFromTriangles(geometry, xithGeometry);
        return xithGeometry;
    }

    private DaeConverter() {
    }
}

