/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.util.meta;

import org.openmali.vecmath2.AxisAngle3f;

public class ModelMetaData {
    private Resource resource = new Resource();
    private AxisAngle3f rotation;
    private float scaling;
    private LoadingFlags loadingFlags = new LoadingFlags();

    void setResourceName(String resourceName) {
        this.resource.name = resourceName;
    }

    public final String getResourceName() {
        return this.resource.name;
    }

    void setResourceRefrenceBase() {
        this.resource.type = Resource.Type.base;
    }

    public final boolean isResourceRefrenceBase() {
        return this.resource.type == Resource.Type.base;
    }

    void setResourceRefrenceRelative() {
        this.resource.type = Resource.Type.relative;
    }

    public final boolean isResourceRefrenceRelative() {
        return this.resource.type == Resource.Type.relative;
    }

    public void setRotation(AxisAngle3f rotation) {
        this.rotation = rotation;
    }

    public final AxisAngle3f getRotation() {
        return this.rotation;
    }

    void setScaling(float scaling) {
        this.scaling = scaling;
    }

    public final float getScaling() {
        return this.scaling;
    }

    public final LoadingFlags getLoadingFlags() {
        return this.loadingFlags;
    }

    protected static class LoadingFlags {
        protected boolean lightNodes;
        protected boolean fogNodes;
        protected boolean backgroundNodes;
        protected boolean behaviorNodes;
        protected boolean viewGroups;
        protected boolean soundNodes;
        protected boolean useDisplayLists;

        protected LoadingFlags() {
        }

        public int getFlags() {
            int retVal = 0;
            retVal |= this.lightNodes ? 1 : 0;
            retVal |= this.fogNodes ? 2 : 0;
            retVal |= this.viewGroups ? 8 : 0;
            return retVal |= this.soundNodes ? 4 : 0;
        }

        public void setFlag(int loadFlags) {
            this.lightNodes = (loadFlags & 1) > 0;
            this.fogNodes = (loadFlags & 2) > 0;
            this.viewGroups = (loadFlags & 8) > 0;
            this.soundNodes = (loadFlags & 4) > 0;
        }
    }

    protected static class Resource {
        protected String name;
        protected Type type = Type.relative;

        protected Resource() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum Type {
            base,
            relative;

        }
    }
}

