/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.shaders.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import org.jagatoo.util.cache.ResourceCache;
import org.xith3d.scenegraph.Shader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShaderLoader<T extends Shader> {
    private ResourceCache<String, T> shaderCache = new ResourceCache();
    private Stack<URL> baseURLs = new Stack();
    private Stack<String> basePaths = new Stack();

    public void setBaseURL(URL url) {
        if (url == null) {
            this.baseURLs.clear();
        } else {
            this.baseURLs.push(url);
        }
    }

    protected void popBaseURL() {
        if (!this.baseURLs.empty()) {
            this.baseURLs.pop();
        }
    }

    public URL getBaseURL() {
        if (this.baseURLs.empty()) {
            return null;
        }
        return this.baseURLs.peek();
    }

    public void setBasePath(String pathName) {
        if (pathName == null) {
            this.basePaths.clear();
        } else {
            this.basePaths.push(pathName);
        }
    }

    protected void popBasePath() {
        if (!this.basePaths.empty()) {
            this.basePaths.pop();
        }
    }

    public String getBasePath() {
        if (this.basePaths.empty()) {
            return null;
        }
        return this.basePaths.peek();
    }

    protected boolean setBaseURLFromShaderURL(URL shaderURL) throws MalformedURLException {
        String resource;
        int pos;
        URL oldBaseURL = this.getBaseURL();
        if (oldBaseURL == null && (pos = (resource = shaderURL.toExternalForm()).lastIndexOf(47)) >= 0) {
            String baseResource = resource.substring(0, pos + 1);
            this.setBaseURL(new URL(baseResource));
            return true;
        }
        return false;
    }

    protected boolean setBasePathFromShaderFile(String shaderFilename) {
        String oldBasePath = this.getBasePath();
        if (oldBasePath == null) {
            int pos = shaderFilename.lastIndexOf(47);
            if (pos < 0) {
                pos = shaderFilename.lastIndexOf(92);
            }
            if (pos >= 0) {
                String baseResource = shaderFilename.substring(0, pos + 1);
                this.setBasePath(baseResource);
                return true;
            }
        }
        return false;
    }

    protected T getFromCache(String cacheTag) {
        return (T)((Shader)this.shaderCache.get(cacheTag));
    }

    protected void cacheShader(String cacheTag, T shader) {
        this.shaderCache.put((Object)cacheTag, shader);
    }

    public abstract T loadShader(Reader var1, Shader.ShaderType var2) throws IOException;

    public abstract T loadShader(InputStream var1, Shader.ShaderType var2) throws IOException;

    public abstract T loadShader(URL var1, Shader.ShaderType var2) throws IOException;

    public abstract T loadShader(String var1, Shader.ShaderType var2) throws IOException;

    public abstract T loadShaderFromString(String var1, Shader.ShaderType var2);

    protected ShaderLoader() {
    }

    protected ShaderLoader(URL baseURL) {
        this();
        this.setBaseURL(baseURL);
    }

    protected ShaderLoader(String basePath) {
        this();
        this.setBasePath(basePath);
    }
}

