/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.sound;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xith3d.loaders.sound.ExtensionSoundLoader;
import org.xith3d.scenegraph.BackgroundSound;
import org.xith3d.scenegraph.PointSound;
import org.xith3d.sound.SoundContainer;

public abstract class SoundLoader {
    private static SoundLoader singletonInstance = null;

    public static SoundLoader getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ExtensionSoundLoader();
        }
        return singletonInstance;
    }

    public abstract SoundContainer loadSound(InputStream var1) throws IOException;

    public abstract SoundContainer loadSound(URL var1) throws IOException;

    public abstract SoundContainer loadSound(String var1) throws IOException;

    public PointSound loadPointSound(InputStream in, float gain) throws IOException {
        SoundContainer container = this.loadSound(in);
        return new PointSound(container, gain);
    }

    public PointSound loadPointSound(URL url, float gain) throws IOException {
        SoundContainer container = this.loadSound(url);
        return new PointSound(container, gain);
    }

    public PointSound loadPointSound(String filename, float gain) throws IOException {
        SoundContainer container = this.loadSound(filename);
        return new PointSound(container, gain);
    }

    public BackgroundSound loadBackgroundSound(InputStream in, float gain) throws IOException {
        SoundContainer container = this.loadSound(in);
        return new BackgroundSound(container, gain);
    }

    public BackgroundSound loadBackgroundSound(URL url, float gain) throws IOException {
        SoundContainer container = this.loadSound(url);
        return new BackgroundSound(container, gain);
    }

    public BackgroundSound loadBackgroundSound(String filename, float gain) throws IOException {
        SoundContainer container = this.loadSound(filename);
        return new BackgroundSound(container, gain);
    }
}

