/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.texture;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jagatoo.loaders.textures.locators.TextureStreamLocator;

public class TextureStreamLocatorZip
implements TextureStreamLocator {
    private URL in;
    private String basePath;
    private Set<String> nameCache;

    public String getBaseDirName() {
        return "zip-file";
    }

    public InputStream openTextureStream(String name) {
        if (!this.nameCache.contains(name)) {
            return null;
        }
        try {
            ZipEntry en;
            ZipInputStream zipIn = new ZipInputStream(this.in.openStream());
            while ((en = zipIn.getNextEntry()) != null) {
                if (!en.getName().equals(this.basePath + name)) continue;
                return zipIn;
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void cacheNames() {
        try {
            ZipEntry en;
            this.nameCache.clear();
            ZipInputStream zipIn = new ZipInputStream(this.in.openStream());
            while ((en = zipIn.getNextEntry()) != null) {
                this.nameCache.add(en.getName().substring(this.basePath.length()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TextureStreamLocatorZip(URL in, String basePath) {
        this.in = in;
        this.basePath = basePath;
        if (basePath.length() > 0 && !basePath.endsWith("/")) {
            this.basePath = this.basePath + "/";
        }
        this.nameCache = new HashSet<String>();
        this.cacheNames();
    }
}

