/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loop;

import java.util.Vector;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.Updater;
import org.xith3d.loop.UpdatingThread;

public class LimitedUpdater
implements Updater,
Updatable {
    private final Vector<Updatable> updatableList = new Vector();
    private long maxFrameTime = Long.MAX_VALUE;
    private boolean gameTimeStepped = true;

    public void addUpdatable(Updatable updatable) {
        this.updatableList.add(updatable);
    }

    public void removeUpdatable(Updatable updatable) {
        this.updatableList.remove(updatable);
    }

    public void setMaxFrameTime(long maxFrameTime) {
        this.maxFrameTime = maxFrameTime;
    }

    public final long getMaxFrameTime() {
        return this.maxFrameTime;
    }

    public void setGameTimeStepped(boolean stepped) {
        this.gameTimeStepped = stepped;
    }

    public final boolean isGameTimeStepped() {
        return this.gameTimeStepped;
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (!this.updatableList.isEmpty()) {
            long maxStep = this.getMaxFrameTime();
            long rest = frameTime;
            boolean gameTimeStepped = this.isGameTimeStepped();
            do {
                int i;
                if (rest > maxStep) {
                    if (gameTimeStepped) {
                        for (i = 0; i < this.updatableList.size(); ++i) {
                            this.updatableList.get(i).update(gameTime - rest, maxStep, timingMode);
                        }
                    } else {
                        for (i = 0; i < this.updatableList.size(); ++i) {
                            this.updatableList.get(i).update(gameTime, maxStep, timingMode);
                        }
                    }
                } else {
                    for (i = 0; i < this.updatableList.size(); ++i) {
                        this.updatableList.get(i).update(gameTime, rest, timingMode);
                    }
                }
            } while ((rest -= maxStep) > 0L);
        }
    }

    public LimitedUpdater(long maxFrameTime, boolean gameTimeStepped) {
        this.maxFrameTime = maxFrameTime;
        this.gameTimeStepped = gameTimeStepped;
    }

    public LimitedUpdater(long maxFrameTime) {
        this(maxFrameTime, true);
    }
}

