/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loop;

import org.jagatoo.util.timing.JavaTimer;
import org.jagatoo.util.timing.TimerInterface;
import org.xith3d.loop.DefaultFPSLimiter;
import org.xith3d.loop.FPSLimiter;
import org.xith3d.loop.GameTimeHost;
import org.xith3d.loop.Updatable;

public abstract class UpdatingThread
implements Runnable,
Updatable,
GameTimeHost {
    public static final int PAUSE_NONE = 0;
    public static final int PAUSE_TOTAL = 1;
    private TimerInterface timer = new JavaTimer();
    private TimingMode timingMode = TimingMode.MICROSECONDS;
    private long t0 = -1L;
    private long t02;
    private long t03;
    private long now;
    private long gameNanoTime = -1L;
    private GameTimeHost gameTimeHost;
    private long iterations = -1L;
    private FPSLimiter fpsLimiter = new DefaultFPSLimiter();
    private Thread thread = null;
    private boolean isStopping = false;
    private long minItTime;
    private long bruttoFrameTime;
    private int pauseMode;

    public final void setTimer(TimerInterface timer) {
        if (timer == null) {
            throw new IllegalArgumentException("timer MUST NOT be null.");
        }
        this.timer = timer;
    }

    public final TimerInterface getTimer() {
        return this.timer;
    }

    protected final void setMinIterationTime(long minItTime) {
        this.minItTime = minItTime;
    }

    public final long getMinIterationTime() {
        return this.minItTime;
    }

    public void setFPSLimiter(FPSLimiter fpsLimiter) {
        this.fpsLimiter = fpsLimiter;
    }

    public final FPSLimiter getFPSLimiter() {
        return this.fpsLimiter;
    }

    public final long getIterationsCount() {
        return this.iterations;
    }

    public final void setTimingMode(TimingMode mode) {
        this.timingMode = mode;
    }

    public final TimingMode getTimingMode() {
        if (this.gameTimeHost == null) {
            return this.timingMode;
        }
        return this.gameTimeHost.getTimingMode();
    }

    public final long getGameNanoTime() {
        if (this.gameTimeHost == null) {
            return this.gameNanoTime;
        }
        return this.gameTimeHost.getGameNanoTime();
    }

    public final long getGameMicroTime() {
        return this.getTimingMode().getMicroSeconds(this.getGameTime());
    }

    public final long getGameMilliTime() {
        return this.getTimingMode().getMilliSeconds(this.getGameTime());
    }

    public final long getGameTime() {
        return this.getGameNanoTime() / this.timingMode.getNanoFactor();
    }

    public final long getLastNanoFrameTime() {
        return this.bruttoFrameTime;
    }

    public final long getLastFrameTime() {
        return this.getLastNanoFrameTime() / this.timingMode.getNanoFactor();
    }

    public final void setPauseMode(int pauseMode) {
        this.pauseMode = pauseMode;
    }

    public final int getPauseMode() {
        return this.pauseMode;
    }

    public abstract void update(long var1, long var3, TimingMode var5);

    protected long nextIteration(boolean force) {
        if (this.t0 == -1L) {
            this.t0 = this.timer.getNanoseconds();
        }
        this.gameNanoTime = this.now - this.t0;
        long gameTime = this.getGameNanoTime();
        this.t03 = this.timer.getNanoseconds();
        long nanoDivisor = this.getTimingMode().getNanoFactor();
        if (force || this.getPauseMode() != 1) {
            this.update(gameTime / nanoDivisor, this.bruttoFrameTime / nanoDivisor, this.getTimingMode());
        }
        this.now = this.timer.getNanoseconds();
        if (this.getFPSLimiter() != null && this.minItTime != 0L) {
            this.getFPSLimiter().limitFPS(this.getIterationsCount(), this.now - this.t03, this.getMinIterationTime(), this.getTimer());
        }
        this.now = this.timer.getNanoseconds();
        this.bruttoFrameTime = this.now - this.t02;
        this.t02 = this.now;
        ++this.iterations;
        return this.bruttoFrameTime;
    }

    protected final boolean isStopping() {
        return this.isStopping;
    }

    protected void loop() {
        while (!this.isStopping()) {
            this.nextIteration(false);
        }
    }

    public void run() {
        this.t02 = this.t0 = this.timer.getNanoseconds();
        this.now = this.t0;
        this.gameNanoTime = 0L;
        this.bruttoFrameTime = 0L;
        this.iterations = 0L;
        this.isStopping = false;
        this.pauseMode = 0;
        try {
            this.loop();
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.end();
        }
        this.thread = null;
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean isRunning() {
        return this.getThread() != null;
    }

    protected void begin(boolean startNewThread) {
        if (this.getThread() == null) {
            if (startNewThread) {
                this.thread = new Thread(this);
                this.thread.start();
            } else {
                this.thread = Thread.currentThread();
                this.run();
            }
        } else {
            throw new IllegalStateException("This Thread is already running.");
        }
    }

    public void end() {
        if (this.getThread() == null) {
            throw new IllegalStateException("This Thread is not running.");
        }
        this.isStopping = true;
    }

    public UpdatingThread(long minItTime, GameTimeHost gameTimeHost) {
        this.setMinIterationTime(minItTime);
        this.gameTimeHost = gameTimeHost;
    }

    public UpdatingThread(long minItTime) {
        this(minItTime, null);
    }

    public UpdatingThread(GameTimeHost gameTimeHost) {
        this(0L, gameTimeHost);
    }

    public UpdatingThread() {
        this(0L, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimingMode {
        MILLISECONDS(1000.0, 1L, 1000.0f, 1000000L),
        MICROSECONDS(1000000.0, 1000L, 1.0f, 1000L),
        NANOSECONDS(1.0E9, 1000000L, 0.001f, 1L);

        private final double divisor;
        private final long milliDivisor;
        private final long nanoFactor;
        private final float floatDivisor;
        private final float floatMilliDivisor;
        private final float floatMicroFactor;
        private final float floatNanoFactor;

        public final double getDivisor() {
            return this.divisor;
        }

        public final long getMilliDivisor() {
            return this.milliDivisor;
        }

        public final long getNanoFactor() {
            return this.nanoFactor;
        }

        public final float getFloatDivisor() {
            return this.floatDivisor;
        }

        public final float getFloatMilliDivisor() {
            return this.floatMilliDivisor;
        }

        public final float getFloatMicroFactor() {
            return this.floatMicroFactor;
        }

        public final float getFloatNanoFactor() {
            return this.floatNanoFactor;
        }

        public final long getMilliSeconds(long t) {
            return t / this.milliDivisor;
        }

        public final long getMicroSeconds(long t) {
            return (long)((float)t * this.floatMicroFactor);
        }

        public final long getNanoSeconds(long t) {
            return t * this.nanoFactor;
        }

        public final float getSecondsAsFloat(long t) {
            return (float)t / this.getFloatDivisor();
        }

        public final long getFromMilliSeconds(long t) {
            return t * this.milliDivisor;
        }

        public final long getFromMicroSeconds(long t) {
            return (long)((float)t / this.floatMicroFactor);
        }

        public final long getFromNanoSeconds(long t) {
            return t / this.nanoFactor;
        }

        private TimingMode(double divisor, long milliDivisor, float microFactor, long nanoFactor) {
            this.divisor = divisor;
            this.milliDivisor = milliDivisor;
            this.nanoFactor = nanoFactor;
            this.floatDivisor = (float)divisor;
            this.floatMilliDivisor = milliDivisor;
            this.floatMicroFactor = microFactor;
            this.floatNanoFactor = nanoFactor;
        }
    }
}

