/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loop.opscheduler;

import org.jagatoo.datatypes.NamableObject;
import org.xith3d.loop.UpdatingThread;

public class Interval
implements NamableObject {
    private long lastGameTime = -1L;
    private long timeInterval;
    private String name;
    private boolean isAlive;

    public void setInterval(long timeInterval) {
        this.timeInterval = timeInterval;
    }

    public long getInterval() {
        return this.timeInterval;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getName() + ", name=" + this.getName() + ", timeInterval=" + this.getInterval();
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void kill() {
        this.isAlive = false;
    }

    public void revive() {
        this.lastGameTime = -1L;
        this.isAlive = true;
    }

    protected void onIntervalStarted(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
    }

    protected void onIntervalHit(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
    }

    public boolean check(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.lastGameTime == -1L) {
            this.lastGameTime = timingMode.getMicroSeconds(gameTime - frameTime);
            this.onIntervalStarted(gameTime, frameTime, timingMode);
        }
        if (this.lastGameTime + this.getInterval() <= timingMode.getMicroSeconds(gameTime)) {
            this.lastGameTime = timingMode.getMicroSeconds(gameTime);
            this.onIntervalHit(gameTime, frameTime, timingMode);
            return true;
        }
        return false;
    }

    public Interval(long timeInterval, String name) {
        this.timeInterval = timeInterval;
        this.name = name;
        this.isAlive = true;
    }

    public Interval(long timeInterval) {
        this.timeInterval = timeInterval;
        this.name = Integer.toHexString(this.hashCode());
        this.isAlive = true;
    }
}

