/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loop.opscheduler.impl;

import java.util.ArrayList;
import java.util.Vector;
import org.xith3d.loop.GameTimeHost;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Animatable;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.loop.opscheduler.IntervalListener;
import org.xith3d.loop.opscheduler.OperationScheduler;
import org.xith3d.loop.opscheduler.ScheduledOperation;

public class OperationSchedulerQueue
extends UpdatingThread
implements OperationScheduler {
    private final ArrayList<OperationScheduler> opScheders = new ArrayList();
    private OperationScheduler defaultOpScheder = null;
    private final IntervalAdapter intervalAdapter = new IntervalAdapter();

    public void addOperationScheduler(OperationScheduler opScheder, int index) {
        this.opScheders.add(index, opScheder);
        opScheder.addIntervalListener(this.intervalAdapter);
    }

    public void addOperationScheduler(OperationScheduler opScheder) {
        this.opScheders.add(opScheder);
        opScheder.addIntervalListener(this.intervalAdapter);
    }

    public void removeOperationScheduler(int index) {
        this.opScheders.get(index).removeIntervalListener(this.intervalAdapter);
        this.opScheders.remove(index);
    }

    public void removeOperationScheduler(OperationScheduler opScheder) {
        opScheder.removeIntervalListener(this.intervalAdapter);
        this.opScheders.remove(opScheder);
    }

    public void setDefaultOperationScheduler(OperationScheduler defaultOpScheder) {
        this.defaultOpScheder = defaultOpScheder;
    }

    public OperationScheduler getDefaultOperationScheduler() {
        return this.defaultOpScheder;
    }

    public void scheduleOperation(ScheduledOperation schedOp) {
        this.getDefaultOperationScheduler().scheduleOperation(schedOp);
    }

    public void unscheduleOperation(ScheduledOperation schedOp) {
        this.getDefaultOperationScheduler().unscheduleOperation(schedOp);
    }

    public void addInterval(Interval interval) {
        this.getDefaultOperationScheduler().addInterval(interval);
    }

    public void removeAllIntervals() {
        this.getDefaultOperationScheduler().removeAllIntervals();
    }

    public void addIntervalListener(IntervalListener l) {
        this.intervalAdapter.addIntervalListener(l);
    }

    public IntervalListener removeIntervalListener(IntervalListener l) {
        return this.intervalAdapter.removeIntervalListener(l);
    }

    public void addAnimatableObject(Animatable animObj, long gameTime, UpdatingThread.TimingMode timingMode) {
        this.scheduleOperation(animObj);
        if (gameTime >= 0L) {
            animObj.startAnimation(gameTime, timingMode);
        }
    }

    public void addAnimatableObject(Animatable animObj, boolean startAnimation) {
        if (startAnimation) {
            this.addAnimatableObject(animObj, 0L, this.getTimingMode());
        } else {
            this.addAnimatableObject(animObj, -1L, null);
        }
    }

    public void addAnimatableObject(Animatable anumObj) {
        this.addAnimatableObject(anumObj, true);
    }

    public void removeAnimatableObject(Animatable animObj) {
        this.unscheduleOperation(animObj);
    }

    public void addUpdatable(Updatable updatable) {
        this.getDefaultOperationScheduler().addUpdatable(updatable);
    }

    public void removeUpdatable(Updatable updatable) {
        this.getDefaultOperationScheduler().removeUpdatable(updatable);
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        for (int i = 0; i < this.opScheders.size(); ++i) {
            this.opScheders.get(i).update(gameTime, frameTime, timingMode);
        }
    }

    public void update(long gameTime) {
        this.update(gameTime, -1L, UpdatingThread.TimingMode.MILLISECONDS);
    }

    public void update() {
        this.update(-1L, -1L, UpdatingThread.TimingMode.MILLISECONDS);
    }

    public OperationSchedulerQueue(long minItTime, GameTimeHost gameTimeHost) {
        super(minItTime, gameTimeHost);
    }

    public OperationSchedulerQueue(long minItTime) {
        this(minItTime, null);
    }

    public OperationSchedulerQueue(GameTimeHost gameTimeHost) {
        this(0L, gameTimeHost);
    }

    public OperationSchedulerQueue() {
        this(0L, null);
    }

    private class IntervalAdapter
    implements IntervalListener {
        private Vector<IntervalListener> intervalListeners = new Vector();

        private IntervalAdapter() {
        }

        public void addIntervalListener(IntervalListener l) {
            this.intervalListeners.add(l);
        }

        public IntervalListener removeIntervalListener(IntervalListener l) {
            if (this.intervalListeners.remove(l)) {
                return l;
            }
            return null;
        }

        public void onIntervalHit(Interval interval, long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
            for (int i = 0; i < this.intervalListeners.size(); ++i) {
                this.intervalListeners.get(i).onIntervalHit(interval, gameTime, frameTime, timingMode);
            }
        }
    }
}

