/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jagatoo.datatypes.Enableable;
import org.openmali.spatial.IndexContainer;
import org.openmali.spatial.TriangleContainer;
import org.openmali.spatial.VertexContainer;
import org.openmali.spatial.bodies.Box;
import org.openmali.spatial.bodies.Plane;
import org.openmali.spatial.bodies.Sphere;
import org.openmali.spatial.bounds.BoundingBox;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.spatial.polygons.Triangle;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Ray3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollideableGroupType;
import org.xith3d.physics.collision.Collision;
import org.xith3d.physics.collision.CollisionCheck;
import org.xith3d.physics.collision.CollisionEngineVendorInformation;
import org.xith3d.physics.collision.CollisionListener;
import org.xith3d.physics.collision.collideable.BoxCollideable;
import org.xith3d.physics.collision.collideable.CapsuleCollideable;
import org.xith3d.physics.collision.collideable.CylinderCollideable;
import org.xith3d.physics.collision.collideable.PlaneCollideable;
import org.xith3d.physics.collision.collideable.RayCollideable;
import org.xith3d.physics.collision.collideable.SphereCollideable;
import org.xith3d.physics.collision.collideable.TriMeshCollideable;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollisionEngine
implements Updatable,
Enableable {
    private final Vector<CollisionCheck> collisionCheckList = new Vector();
    private CollisionListener defaultCollisionListener = null;
    private boolean enabled = true;

    public abstract List<CollideableGroupType> getGroupTypes();

    public abstract CollideableGroup newGroup();

    public abstract CollideableGroup newGroup(String var1);

    public RayCollideable newRay(float originX, float originY, float originZ, float directionX, float directionY, float directionZ) {
        throw new NotImplementedYetError("The engine " + this.getVendorInformation().getName() + " hasn't implemented Ray collision detection yet !");
    }

    public final RayCollideable newRay(Tuple3f origin, Tuple3f direction) {
        return this.newRay(origin.getX(), origin.getY(), origin.getZ(), direction.getX(), direction.getY(), direction.getZ());
    }

    public final RayCollideable newRay(Ray3f ray) {
        RayCollideable c = this.newRay((Tuple3f)ray.getOrigin(), (Tuple3f)ray.getDirection());
        return c;
    }

    public final RayCollideable newRay(VertexContainer vertexContainer) {
        Point3f coord = Point3f.fromPool();
        vertexContainer.getVertex(0, (Tuple3f)coord);
        float x0 = coord.getX();
        float y0 = coord.getY();
        float z0 = coord.getZ();
        vertexContainer.getVertex(1, (Tuple3f)coord);
        float x1 = coord.getX();
        float y1 = coord.getY();
        float z1 = coord.getZ();
        return this.newRay(x0, y0, z0, x1, y1, z1);
    }

    public final RayCollideable newRay(Shape3D shape) {
        return this.newRay(shape.getGeometry());
    }

    public SphereCollideable newSphere(float radius) {
        throw new NotImplementedYetError("The engine " + this.getVendorInformation().getName() + " hasn't implemented Sphere collision detection yet !");
    }

    public final SphereCollideable newSphere(Sphere sphere) {
        SphereCollideable c = this.newSphere(sphere.getRadius());
        c.setPosition(sphere.getCenterX(), sphere.getCenterY(), sphere.getCenterZ());
        return c;
    }

    public final SphereCollideable newSphere(VertexContainer vertexContainer) {
        BoundingSphere bs = BoundingSphere.newBoundingSphere((VertexContainer)vertexContainer);
        return this.newSphere((Sphere)bs);
    }

    public final SphereCollideable newSphere(Shape3D shape) {
        return this.newSphere(shape.getGeometry());
    }

    public final BoxCollideable newBox(Tuple3f size) {
        return this.newBox(size.getX(), size.getY(), size.getZ());
    }

    public BoxCollideable newBox(float xSize, float ySize, float zSize) {
        throw new NotImplementedYetError("The engine " + this.getVendorInformation().getName() + " hasn't implemented Box collision detection yet !");
    }

    public final BoxCollideable newBox(Box box) {
        BoxCollideable c = this.newBox(box.getXSpan(), box.getYSpan(), box.getZSpan());
        c.setPosition(box.getCenterX(), box.getCenterY(), box.getCenterZ());
        return c;
    }

    public final BoxCollideable newBox(VertexContainer vertexContainer) {
        BoundingBox bb = BoundingBox.newAABB((VertexContainer)vertexContainer);
        return this.newBox((Box)bb);
    }

    public final BoxCollideable newBox(Shape3D shape) {
        return this.newBox(shape.getGeometry());
    }

    public final CollideableGroup newBoxOutline(Box box) {
        CollideableGroup boxOutline = this.newGroup("Simple");
        float inverted = -1.0f;
        PlaneCollideable top = this.newPlane(new Vector3f(0.0f, -1.0f, 0.0f), box.getUpper());
        boxOutline.addCollideable(top);
        PlaneCollideable bottom = this.newPlane(new Vector3f(0.0f, 1.0f, 0.0f), box.getLower());
        boxOutline.addCollideable(bottom);
        PlaneCollideable front = this.newPlane(new Vector3f(0.0f, 0.0f, 1.0f), box.getLower());
        boxOutline.addCollideable(front);
        PlaneCollideable back = this.newPlane(new Vector3f(0.0f, 0.0f, -1.0f), box.getUpper());
        boxOutline.addCollideable(back);
        PlaneCollideable left = this.newPlane(new Vector3f(1.0f, 0.0f, 0.0f), box.getLower());
        boxOutline.addCollideable(left);
        PlaneCollideable right = this.newPlane(new Vector3f(-1.0f, 0.0f, 0.0f), box.getUpper());
        boxOutline.addCollideable(right);
        return boxOutline;
    }

    public final CollideableGroup newBoxOutline(VertexContainer vertexContainer) {
        BoundingBox bb = BoundingBox.newAABB((VertexContainer)vertexContainer);
        return this.newBoxOutline((Box)bb);
    }

    public final CollideableGroup newBoxOutline(Shape3D shape) {
        return this.newBoxOutline(shape.getGeometry());
    }

    public CapsuleCollideable newCapsule(float radius, float length) {
        throw new NotImplementedYetError("The engine " + this.getVendorInformation().getName() + " hasn't implemented Capsule collision detection yet !");
    }

    public CylinderCollideable newCylinder(float radius, float length) {
        throw new NotImplementedYetError("The engine " + this.getVendorInformation().getName() + " hasn't implemented Cylinder collision detection yet !");
    }

    public PlaneCollideable newPlane(Vector3f normal, Point3f point) {
        throw new NotImplementedYetError("The engine " + this.getVendorInformation().getName() + " hasn't implemented Plane collision detection yet !");
    }

    public PlaneCollideable newPlane(Vector3f normal, float d) {
        throw new NotImplementedYetError("The engine " + this.getVendorInformation().getName() + " hasn't implemented Plane collision detection yet !");
    }

    public PlaneCollideable newPlane(float a, float b, float c, float d) {
        throw new NotImplementedYetError("The engine " + this.getVendorInformation().getName() + " hasn't implemented Plane collision detection yet !");
    }

    public final PlaneCollideable newPlane(Plane plane) {
        return this.newPlane(plane.getA(), plane.getB(), plane.getC(), plane.getD());
    }

    public TriMeshCollideable newTriMesh(VertexContainer vertexContainer, IndexContainer indexContainer) {
        int[] indices;
        Point3f[] vertices = new Point3f[vertexContainer.getVertexCount()];
        Point3f coord = new Point3f();
        for (int i = 0; i < vertices.length; ++i) {
            vertexContainer.getVertex(i, (Tuple3f)coord);
            vertices[i] = new Point3f((Tuple3f)coord);
        }
        if (indexContainer == null) {
            indices = new int[vertexContainer.getVertexCount()];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = i;
            }
        } else {
            indices = new int[indexContainer.getIndexCount()];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = indexContainer.getIndex(i);
            }
        }
        return this.newTriMesh((Tuple3f[])vertices, indices);
    }

    public final TriMeshCollideable newTriMesh(VertexContainer vertexContainer) {
        return this.newTriMesh(vertexContainer, null);
    }

    public TriMeshCollideable newTriMesh(TriangleContainer triangleContainer) {
        VertexContainer vertexContainer = (VertexContainer)triangleContainer;
        int nt = triangleContainer.getTriangleCount();
        int nv = vertexContainer.getVertexCount();
        Point3f[] coords = new Point3f[nv];
        Point3f coord = new Point3f();
        for (int i = 0; i < coords.length; ++i) {
            vertexContainer.getVertex(i, (Tuple3f)coord);
            coords[i] = new Point3f((Tuple3f)coord);
        }
        Triangle trian = new Triangle();
        Vector3f edgeAC = new Vector3f();
        Vector3f edgeAB = new Vector3f();
        Vector3f faceNormal = new Vector3f();
        Vector3f crossNormal = new Vector3f();
        int[] indices = new int[nt * 3];
        int i = 0;
        for (int t = 0; t < nt; ++t) {
            triangleContainer.getTriangle(t, trian);
            indices[i++] = trian.getVertexIndexC();
            indices[i++] = trian.getVertexIndexB();
            indices[i++] = trian.getVertexIndexA();
        }
        return this.newTriMesh((Tuple3f[])coords, indices);
    }

    public final TriMeshCollideable newTriMesh(Geometry geometry) {
        if (geometry instanceof TriangleContainer) {
            return this.newTriMesh((TriangleContainer)geometry);
        }
        return this.newTriMesh((VertexContainer)geometry);
    }

    public final TriMeshCollideable newTriMesh(Shape3D shape) {
        return this.newTriMesh(shape.getGeometry());
    }

    public TriMeshCollideable newTriMesh(Tuple3f[] vertices, int[] indices) {
        throw new NotImplementedYetError("The engine " + this.getVendorInformation().getName() + " hasn't implemented TriMesh collision detection yet !");
    }

    public final TriMeshCollideable newTriMesh(Tuple3f[] vertices) {
        return this.newTriMesh(vertices, null);
    }

    public final CollideableGroup newTriMeshGroup(GroupNode group) {
        CollideableGroup collGroup = this.newGroup("Simple");
        for (int i = 0; i < group.numChildren(); ++i) {
            Node child = group.getChild(i);
            if (child instanceof GroupNode) {
                collGroup.addCollideable(this.newTriMeshGroup((GroupNode)child));
                continue;
            }
            if (!(child instanceof Shape3D)) continue;
            collGroup.addCollideable(this.newTriMesh((Shape3D)child));
        }
        return collGroup;
    }

    public final CollideableGroup newSphereGroup(GroupNode group) {
        CollideableGroup collGroup = this.newGroup("Simple");
        for (int i = 0; i < group.numChildren(); ++i) {
            Node child = group.getChild(i);
            if (child instanceof GroupNode) {
                collGroup.addCollideable(this.newSphereGroup((GroupNode)child));
                continue;
            }
            if (!(child instanceof Shape3D)) continue;
            collGroup.addCollideable(this.newSphere((Shape3D)child));
        }
        return collGroup;
    }

    public final CollideableGroup newBoxGroup(GroupNode group) {
        CollideableGroup collGroup = this.newGroup("Simple");
        for (int i = 0; i < group.numChildren(); ++i) {
            Node child = group.getChild(i);
            if (child instanceof GroupNode) {
                collGroup.addCollideable(this.newBoxGroup((GroupNode)child));
                continue;
            }
            if (!(child instanceof Shape3D)) continue;
            collGroup.addCollideable(this.newSphere((Shape3D)child));
        }
        return collGroup;
    }

    public abstract int checkCollisions(Collideable var1, Collideable var2, boolean var3, ArrayList<Collision> var4);

    public final ArrayList<Collision> checkCollisions(Collideable c1, Collideable c2, boolean ignoreStatic) {
        ArrayList<Collision> collisions = new ArrayList<Collision>();
        this.checkCollisions(c1, c2, ignoreStatic, collisions);
        return collisions;
    }

    public abstract int checkCollisions(Collideable var1, Collideable var2, boolean var3, CollisionListener var4);

    public abstract int checkCollisions(CollideableGroup var1, boolean var2, ArrayList<Collision> var3);

    public final ArrayList<Collision> checkCollisions(CollideableGroup group, boolean ignoreStatic) {
        ArrayList<Collision> collisions = new ArrayList<Collision>();
        this.checkCollisions(group, ignoreStatic, collisions);
        return collisions;
    }

    public abstract int checkCollisions(CollideableGroup var1, boolean var2, CollisionListener var3);

    public abstract CollisionEngineVendorInformation getVendorInformation();

    public final void addCollisionCheck(CollisionCheck cc) {
        this.collisionCheckList.add(cc);
    }

    public final void removeCollisionCheck(CollisionCheck cc) {
        this.collisionCheckList.remove(cc);
    }

    public final void setDefaultCollisionListener(CollisionListener cl) {
        this.defaultCollisionListener = cl;
    }

    public final CollisionListener getDefaultCollisionListener() {
        return this.defaultCollisionListener;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.isEnabled()) {
            for (int i = 0; i < this.collisionCheckList.size(); ++i) {
                CollisionListener cl;
                CollisionCheck cc = this.collisionCheckList.get(i);
                CollisionListener collisionListener = cl = cc.getCollisionListener() != null ? cc.getCollisionListener() : this.defaultCollisionListener;
                if (cl != null) {
                    this.checkCollisions(cc.getCollideable1(), cc.getCollideable2(), cc.getIgnoreStatic(), cl);
                    continue;
                }
                System.err.println("Warning: Neither the CollisionCheck defines a CollisionListener, nor the CollisionEngine has a default one.");
            }
        }
    }

    public class NotImplementedYetError
    extends Error {
        private static final long serialVersionUID = -5061974919339663639L;

        public NotImplementedYetError(String message) {
            super(message);
        }
    }
}

