/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision.collideable;

import org.jagatoo.opengl.enums.DrawMode;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.physics.collision.CollideableBase;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.primitives.Capsule;

public abstract class CapsuleCollideable
extends CollideableBase {
    private static Appearance defaultAppearance = null;
    private Capsule gfxObject;
    private float radius;
    private float length;

    public static void setDefaultAppearance(Appearance app) {
        defaultAppearance = app;
    }

    public static void setDefaultAppearance(Texture texture) {
        if (defaultAppearance == null) {
            defaultAppearance = new Appearance();
        }
        defaultAppearance.setTexture(texture);
    }

    public static void setDefaultAppearance(String texture) {
        CapsuleCollideable.setDefaultAppearance(TextureLoader.getInstance().getTexture(texture));
    }

    public static Appearance getDefaultAppearance() {
        return defaultAppearance;
    }

    public final String getInfo() {
        return "A capsule collideable. One can adjust its radius and length";
    }

    public final String getType() {
        return "Capsule";
    }

    public Capsule getBaseGFX() {
        if (this.gfxObject == null) {
            this.gfxObject = defaultAppearance == null ? new Capsule(this.radius, this.length, 16, 16, 11, false, 2) : new Capsule(this.radius, this.length, 16, 16, defaultAppearance.cloneNodeComponent(false));
            StaticTransform.rotateX(this.gfxObject, 1.5707964f);
        }
        if (this.gfxObject.getAppearance(true).getPolygonAttributes() != null) {
            this.gfxObject.getAppearance().getPolygonAttributes().setDrawMode(DrawMode.FILL);
        }
        return this.gfxObject;
    }

    public Capsule getDebugGFX() {
        Capsule shape = this.getBaseGFX();
        shape.getAppearance().getPolygonAttributes().setDrawMode(DrawMode.LINE);
        return shape;
    }

    public void setRadius(float radius) {
        if (this.gfxObject != null) {
            float q = radius / this.radius;
            StaticTransform.scale(this.gfxObject, q, q, 1.0f);
        }
        this.radius = radius;
    }

    public final float getRadius() {
        return this.radius;
    }

    public void setLength(float length) {
        if (this.gfxObject != null) {
            float q = length / this.length;
            StaticTransform.scale(this.gfxObject, 1.0f, 1.0f, q);
        }
        this.length = length;
    }

    public final float getLength() {
        return this.length;
    }

    public CapsuleCollideable(CollisionEngine eng, float radius, float length) {
        super(eng);
        this.radius = radius;
        this.length = length;
    }
}

