/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision.collideable;

import org.jagatoo.opengl.enums.DrawMode;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.physics.collision.CollideableBase;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;

public abstract class TriMeshCollideable
extends CollideableBase {
    private static Appearance defaultAppearance = null;
    private Shape3D gfxObject = null;

    public static void setDefaultAppearance(Appearance app) {
        defaultAppearance = app;
    }

    public static void setDefaultAppearance(Texture texture) {
        if (defaultAppearance == null) {
            defaultAppearance = new Appearance();
        }
        defaultAppearance.setTexture(texture);
    }

    public static void setDefaultAppearance(String texture) {
        TriMeshCollideable.setDefaultAppearance(TextureLoader.getInstance().getTexture(texture));
    }

    public static Appearance getDefaultAppearance() {
        return defaultAppearance;
    }

    public final String getInfo() {
        return "A triangle mesh collideable. Its shape is defined by a set of coordinates (and optionally indices)";
    }

    public final String getType() {
        return "TriMesh";
    }

    public Shape3D getBaseGFX() {
        if (this.gfxObject == null) {
            IndexedTriangleArray geom = new IndexedTriangleArray(this.getVertexCount(), this.getIndexCount());
            geom.setCoordinates(0, this.getVerticesFloats());
            geom.setIndex(this.getIndices());
            this.gfxObject = defaultAppearance == null ? new Shape3D(geom, null) : new Shape3D(geom, defaultAppearance.cloneNodeComponent(false));
        }
        if (this.gfxObject.getAppearance(true).getPolygonAttributes() != null) {
            this.gfxObject.getAppearance().getPolygonAttributes().setDrawMode(DrawMode.FILL);
        }
        return this.gfxObject;
    }

    public Shape3D getDebugGFX() {
        Shape3D shape = this.getBaseGFX();
        shape.getAppearance().getPolygonAttributes().setDrawMode(DrawMode.LINE);
        return shape;
    }

    public abstract float[] getVerticesFloats();

    public abstract int getVertexCount();

    public abstract void getVertex(int var1, Tuple3f var2);

    public abstract Point3f[] getVertices();

    public abstract int getIndexCount();

    public abstract int getIndex(int var1);

    public abstract int[] getIndices();

    public TriMeshCollideable(CollisionEngine eng) {
        super(eng);
    }
}

