/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.simulation;

import java.util.ArrayList;
import org.jagatoo.datatypes.Enableable;
import org.jagatoo.datatypes.NamableObject;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableBase;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.physics.util.PlaceableImpl;
import org.xith3d.utility.classes.beans.BeanUtil;

public abstract class Body
extends PlaceableImpl
implements NamableObject,
Enableable {
    private String name = null;
    private Object userObject = null;
    protected final SimulationWorld world;
    protected final ArrayList<Collideable> collideables = new ArrayList();

    public final SimulationWorld getWorld() {
        return this.world;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public final Object getUserObject() {
        return this.userObject;
    }

    public abstract void setEnabled(boolean var1);

    public abstract boolean isEnabled();

    public abstract void setGravityEnabled(boolean var1);

    public abstract boolean isGravityEnabled();

    public abstract Vector3f getLinearVelocity();

    public abstract void setLinearVelocity(float var1, float var2, float var3);

    public final void setLinearVelocity(Vector3f linearVel) {
        this.setLinearVelocity(linearVel.getX(), linearVel.getY(), linearVel.getZ());
    }

    public final void resetLinearVelocity() {
        this.setLinearVelocity(0.0f, 0.0f, 0.0f);
    }

    public abstract Vector3f getAngularVelocity();

    public abstract void setAngularVelocity(float var1, float var2, float var3);

    public final void setAngularVelocity(Tuple3f angularVel) {
        this.setAngularVelocity(angularVel.getX(), angularVel.getY(), angularVel.getZ());
    }

    public final void resetAngularVelocity() {
        this.setAngularVelocity(0.0f, 0.0f, 0.0f);
    }

    public abstract void addTorque(float var1, float var2, float var3);

    public final void addTorque(Tuple3f torque) {
        this.addTorque(torque.getX(), torque.getY(), torque.getZ());
    }

    public abstract void addForce(float var1, float var2, float var3);

    public final void addForce(Vector3f force) {
        this.addForce(force.getX(), force.getY(), force.getZ());
    }

    public Object getParameter(String member) {
        return BeanUtil.get(this, member);
    }

    public void setParameter(String member, Object value) {
        BeanUtil.set(this, member, value);
    }

    public abstract void setMass(float var1);

    public abstract float getMass();

    public void addCollideable(Collideable collideable) {
        this.collideables.add(collideable);
        collideable.setBody(this);
        collideable.setPosition((Tuple3f)this.position);
        collideable.setRotationMatrix(this.rotation);
    }

    public void removeCollideable(Collideable collideable) {
        this.collideables.remove(collideable);
        collideable.setBody(null);
    }

    public final int getCollideablesCount() {
        return this.collideables.size();
    }

    public final Collideable getCollideable(int i) {
        return this.collideables.get(i);
    }

    protected void refresh() {
        for (int i = 0; i < this.collideables.size(); ++i) {
            Collideable collideable = this.collideables.get(i);
            ((CollideableBase)collideable).setPosition(this.position.getX(), this.position.getY(), this.position.getZ(), false);
            ((CollideableBase)collideable).setRotationMatrix(this.rotation, false);
            collideable.recomputeWorldCoords(false, false);
            if (!(collideable instanceof CollideableGroup)) continue;
            ((CollideableGroup)collideable).recomputeChildrenWorldCoords(true);
        }
    }

    public String toString() {
        if (this.getName() == null) {
            return super.toString();
        }
        return super.toString() + " \"" + this.getName() + "\"";
    }

    public Body(SimulationWorld world) {
        this.world = world;
    }
}

