/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.simulation;

import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SurfaceParameters {
    private final String[] availableParams;
    private final HashMap<String, Object> defaultParams;
    private final HashMap<String, Object> params;

    public final String[] getAvailableParameters() {
        String[] availableParams = new String[this.availableParams.length];
        System.arraycopy(this.availableParams, 0, availableParams, 0, this.availableParams.length);
        return availableParams;
    }

    public final void dumpAvailableParameters() {
        System.out.println("Available parameters:");
        for (String paramName : this.getAvailableParameters()) {
            System.out.println("  " + paramName);
        }
    }

    public abstract String getParameterInfo(String var1);

    public final void dumpParameterInfo() {
        System.out.println("Parameters info:");
        for (String paramName : this.getAvailableParameters()) {
            System.out.println("  " + this.getParameterInfo(paramName));
        }
    }

    public final boolean isParamAvailable(String paramName) {
        return this.defaultParams.containsKey(paramName);
    }

    private final void checkAvailability(String paramName) {
        if (!this.isParamAvailable(paramName)) {
            throw new IllegalArgumentException("The parameter \"" + paramName + "\" is not available in the current implementation");
        }
    }

    public void setParameter(String paramName, Object paramValue) {
        this.checkAvailability(paramName);
        if (paramValue == null) {
            this.resetParameter(paramName);
        } else {
            this.params.put(paramName, paramValue);
        }
    }

    public void resetParameter(String paramName) {
        this.checkAvailability(paramName);
        this.params.remove(paramName);
    }

    public final Object getParameter(String paramName) {
        this.checkAvailability(paramName);
        Object value = this.params.get(paramName);
        if (value == null) {
            return this.defaultParams.get(paramName);
        }
        return value;
    }

    public final boolean isParameterSet(String paramName) {
        return this.params.containsKey(paramName);
    }

    public final float getFloatParameter(String paramName) {
        Object value = this.params.get(paramName);
        if (value == null) {
            return ((Float)this.defaultParams.get(paramName)).floatValue();
        }
        return ((Float)value).floatValue();
    }

    public final boolean getBooleanParameter(String paramName) {
        Object value = this.params.get(paramName);
        if (value == null) {
            return (Boolean)this.defaultParams.get(paramName);
        }
        return (Boolean)value;
    }

    protected SurfaceParameters(HashMap<String, Object> defaultParamers, String[] paramStrings, Object[] paramValues) {
        if (defaultParamers == null || defaultParamers.isEmpty()) {
            throw new IllegalArgumentException("defaultParamers must not be null nor empty.");
        }
        this.params = new HashMap();
        this.availableParams = new String[defaultParamers.size()];
        this.defaultParams = defaultParamers;
        int i = 0;
        for (String param : defaultParamers.keySet()) {
            this.availableParams[i++] = param;
        }
        if (paramStrings != null && paramValues != null) {
            for (i = 0; i < paramStrings.length; ++i) {
                this.params.put(paramStrings[i], paramValues[i]);
            }
        }
    }
}

