/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.util;

import org.jagatoo.datatypes.RepositionListener3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.Joint;
import org.xith3d.physics.simulation.joints.BallJoint;
import org.xith3d.physics.simulation.joints.Hinge2Joint;
import org.xith3d.physics.simulation.joints.HingeJoint;

public abstract class BodyJointAnchorLink
implements RepositionListener3f {
    private final Body body;
    private final Vector3f offset;

    public final Body getBody() {
        return this.body;
    }

    public final Vector3f getOffset() {
        return this.offset;
    }

    public abstract Joint getJoint();

    protected BodyJointAnchorLink(Body body, boolean useOffset, float offsetX, float offsetY, float offsetZ) {
        if (body == null) {
            throw new IllegalArgumentException("body must not be null.");
        }
        this.body = body;
        this.offset = useOffset ? new Vector3f(offsetX, offsetY, offsetZ) : null;
    }

    public static BodyJointAnchorLink make(Body body, BallJoint joint, int anchorIndex) {
        BodyJointAnchorLink_Ball bjal = new BodyJointAnchorLink_Ball(body, joint, anchorIndex, false, 0.0f, 0.0f, 0.0f);
        body.addRepositionListener(bjal);
        return bjal;
    }

    public static BodyJointAnchorLink make(Body body, BallJoint joint, int anchorIndex, float offsetX, float offsetY, float offsetZ) {
        BodyJointAnchorLink_Ball bjal = new BodyJointAnchorLink_Ball(body, joint, anchorIndex, true, offsetX, offsetY, offsetZ);
        body.addRepositionListener(bjal);
        return bjal;
    }

    public static BodyJointAnchorLink make(Body body, HingeJoint joint) {
        BodyJointAnchorLink_Hinge bjal = new BodyJointAnchorLink_Hinge(body, joint, false, 0.0f, 0.0f, 0.0f);
        body.addRepositionListener(bjal);
        return bjal;
    }

    public static BodyJointAnchorLink make(Body body, HingeJoint joint, float offsetX, float offsetY, float offsetZ) {
        BodyJointAnchorLink_Hinge bjal = new BodyJointAnchorLink_Hinge(body, joint, true, offsetX, offsetY, offsetZ);
        body.addRepositionListener(bjal);
        return bjal;
    }

    public static BodyJointAnchorLink make(Body body, Hinge2Joint joint) {
        BodyJointAnchorLink_Hinge2 bjal = new BodyJointAnchorLink_Hinge2(body, joint, false, 0.0f, 0.0f, 0.0f);
        body.addRepositionListener(bjal);
        return bjal;
    }

    public static BodyJointAnchorLink make(Body body, Hinge2Joint joint, float offsetX, float offsetY, float offsetZ) {
        BodyJointAnchorLink_Hinge2 bjal = new BodyJointAnchorLink_Hinge2(body, joint, true, offsetX, offsetY, offsetZ);
        body.addRepositionListener(bjal);
        return bjal;
    }

    private static final class BodyJointAnchorLink_Hinge2
    extends BodyJointAnchorLink {
        private final Hinge2Joint joint;

        public final Hinge2Joint getJoint() {
            return this.joint;
        }

        public void onPositionChanged(float posX, float posY, float posZ) {
            this.joint.setAnchor(posX, posY, posZ);
        }

        public BodyJointAnchorLink_Hinge2(Body body, Hinge2Joint joint, boolean useOffset, float offsetX, float offsetY, float offsetZ) {
            super(body, useOffset, offsetX, offsetY, offsetZ);
            if (joint == null) {
                throw new IllegalArgumentException("joint must not be null.");
            }
            this.joint = joint;
        }
    }

    private static final class BodyJointAnchorLink_Hinge
    extends BodyJointAnchorLink {
        private final HingeJoint joint;

        public final HingeJoint getJoint() {
            return this.joint;
        }

        public void onPositionChanged(float posX, float posY, float posZ) {
            this.joint.setAnchor(posX, posY, posZ);
        }

        public BodyJointAnchorLink_Hinge(Body body, HingeJoint joint, boolean useOffset, float offsetX, float offsetY, float offsetZ) {
            super(body, useOffset, offsetX, offsetY, offsetZ);
            if (joint == null) {
                throw new IllegalArgumentException("joint must not be null.");
            }
            this.joint = joint;
        }
    }

    private static final class BodyJointAnchorLink_Ball
    extends BodyJointAnchorLink {
        private final BallJoint joint;
        private final int anchorIndex;

        public final BallJoint getJoint() {
            return this.joint;
        }

        public void onPositionChanged(float posX, float posY, float posZ) {
            switch (this.anchorIndex) {
                case 1: {
                    this.joint.setAnchor1(posX, posY, posZ);
                    break;
                }
                case 2: {
                    this.joint.setAnchor2(posX, posY, posZ);
                }
            }
        }

        public BodyJointAnchorLink_Ball(Body body, BallJoint joint, int anchorIndex, boolean useOffset, float offsetX, float offsetY, float offsetZ) {
            super(body, useOffset, offsetX, offsetY, offsetZ);
            if (joint == null) {
                throw new IllegalArgumentException("joint must not be null.");
            }
            if (anchorIndex < 1 || anchorIndex > 2) {
                throw new IllegalArgumentException("anchorIndex must be in range [1, 2].");
            }
            this.joint = joint;
            this.anchorIndex = anchorIndex;
        }
    }
}

