/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.picking;

import org.openmali.FastMath;
import org.openmali.types.twodee.Rect2i;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Ray3f;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;

public class PickRay
extends Ray3f {
    private static final long serialVersionUID = 6030131242963942660L;
    private View.ProjectionPolicy projectionPolicy;
    private float fieldOfView;
    private float screenScale;
    private float centerViewX;
    private float centerViewY;
    private Matrix4f viewMatrix;
    private float canvasWidth;
    private float canvasHeight;
    private float canvasAspect;
    private float canvasX;
    private float canvasY;
    private View lastView = null;
    private RenderPassConfig lastRPC = null;

    public void recalculate(float canvasX, float canvasY) {
        this.canvasX = canvasX;
        this.canvasY = canvasY;
        float x = this.canvasX;
        float y = this.canvasY;
        if (this.lastRPC != null && this.lastRPC.getViewport() != null) {
            Rect2i viewport = this.lastRPC.getViewport();
            x -= (float)viewport.getLeft();
            y -= (float)viewport.getTop();
            this.canvasWidth = viewport.getWidth();
            this.canvasHeight = viewport.getHeight();
            this.canvasAspect = this.canvasWidth / this.canvasHeight;
        }
        if (this.projectionPolicy == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
            float rx = (2.0f * x / this.canvasWidth - 1.0f) * this.canvasAspect;
            float ry = 2.0f - 2.0f * y / this.canvasHeight - 1.0f;
            float vpd = 1.0f / FastMath.tan((float)this.fieldOfView);
            this.setOrigin(0.0f, 0.0f, 0.0f);
            this.setDirection(rx, ry, -vpd);
            this.getDirection().normalize();
        } else {
            float rx = 2.0f * x / this.canvasWidth - 1.0f;
            float ry = (2.0f - 2.0f * y / this.canvasHeight - 1.0f) / this.canvasAspect;
            float s = this.screenScale;
            float cx = this.centerViewX;
            float cy = this.centerViewY;
            this.setOrigin(-cx + s * rx, -cy + s * ry, 9999.0f);
            this.setDirection(0.0f, 0.0f, -1.0f);
        }
        this.viewMatrix.transform(this.getOrigin());
        this.viewMatrix.transform(this.getDirection());
    }

    public void recalculate(Matrix4f viewMatrix) {
        this.viewMatrix = viewMatrix;
        this.recalculate(this.canvasX, this.canvasY);
    }

    public void recalculate(View.ProjectionPolicy projectionPolicy, float fieldOfView, float screenScale, float centerViewX, float centerViewY, Matrix4f viewMatrix, float canvasWidth, float canvasHeight, float canvasX, float canvasY) {
        this.projectionPolicy = projectionPolicy;
        this.fieldOfView = fieldOfView;
        this.screenScale = screenScale;
        this.centerViewX = centerViewX;
        this.centerViewY = centerViewY;
        this.viewMatrix = viewMatrix;
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.canvasAspect = canvasWidth / canvasHeight;
        this.recalculate(canvasX, canvasY);
    }

    public void recalculate(PickRay template, View.CameraMode cameraMode) {
        this.lastView = template.lastView;
        this.lastRPC = template.lastRPC;
        this.projectionPolicy = template.projectionPolicy;
        this.fieldOfView = template.fieldOfView;
        this.screenScale = template.screenScale;
        this.centerViewX = template.centerViewX;
        this.centerViewY = template.centerViewY;
        this.canvasWidth = template.canvasWidth;
        this.canvasHeight = template.canvasHeight;
        this.canvasAspect = template.canvasAspect;
        if (this.lastRPC != null) {
            _SG_PrivilegedAccess.set(this.lastView, true, this.lastRPC);
        }
        this.viewMatrix = cameraMode == null ? this.lastView.getTransform().getMatrix4f() : this.lastView.getModelViewTransform(cameraMode, true).getMatrix4f();
        if (this.lastRPC != null) {
            _SG_PrivilegedAccess.set(this.lastView, false, null);
        }
        this.recalculate(template.canvasX, template.canvasY);
    }

    private static final float getCenterViewX(Tuple2f centerOfView) {
        return centerOfView != null ? centerOfView.getX() : 0.0f;
    }

    private static final float getCenterViewY(Tuple2f centerOfView) {
        return centerOfView != null ? centerOfView.getY() : 0.0f;
    }

    public void recalculate(Canvas3D canvas, int canvasX, int canvasY) {
        View view;
        this.lastView = view = canvas.getView();
        View.CameraMode cameraMode = this.lastRPC == null ? null : this.lastRPC.getCameraMode();
        _SG_PrivilegedAccess.set(view, true, this.lastRPC);
        this.projectionPolicy = view.getProjectionPolicy();
        this.fieldOfView = view.getFieldOfView();
        this.screenScale = view.getScreenScale();
        this.centerViewX = PickRay.getCenterViewX(view.getCenterOfView());
        this.centerViewY = PickRay.getCenterViewY(view.getCenterOfView());
        this.viewMatrix = cameraMode == null || cameraMode == View.CameraMode.VIEW_NORMAL ? view.getTransform().getMatrix4f() : view.getModelViewTransform(cameraMode, true).getMatrix4f();
        this.canvasWidth = canvas.getWidth();
        this.canvasHeight = canvas.getHeight();
        this.canvasAspect = this.canvasWidth / this.canvasHeight;
        _SG_PrivilegedAccess.set(view, false, null);
        this.recalculate((float)canvasX, (float)canvasY);
    }

    public void recalculate(int canvasX, int canvasY) {
        Canvas3D canvas = this.lastView.getCanvas3D(0);
        this.recalculate(canvas, canvasX, canvasY);
    }

    public void recalculate(RenderPassConfig rpc, Canvas3D canvas, int canvasX, int canvasY) {
        this.lastRPC = rpc;
        this.recalculate(canvas, canvasX, canvasY);
    }

    public void recalculate(View.CameraMode cameraMode, Canvas3D canvas, int canvasX, int canvasY) {
        float centerViewX = PickRay.getCenterViewX(canvas.getView().getCenterOfView());
        float centerViewY = PickRay.getCenterViewY(canvas.getView().getCenterOfView());
        this.recalculate(canvas.getView().getProjectionPolicy(), canvas.getView().getFieldOfView(), centerViewX, centerViewY, canvas.getView().getScreenScale(), cameraMode == null ? canvas.getView().getTransform().getMatrix4f() : canvas.getView().getModelViewTransform(cameraMode, true).getMatrix4f(), canvas.getWidth(), canvas.getHeight(), canvasX, canvasY);
        this.lastView = canvas.getView();
        this.lastRPC = null;
    }

    public PickRay() {
    }

    public PickRay(View.ProjectionPolicy projectionPolicy, float fieldOfView, float screenScale, float centerViewX, float centerViewY, Matrix4f viewMatrix, float canvasWidth, float canvasHeight, float canvasX, float canvasY) {
        this.projectionPolicy = projectionPolicy;
        this.fieldOfView = fieldOfView;
        this.screenScale = screenScale;
        this.centerViewX = centerViewX;
        this.centerViewY = centerViewY;
        this.viewMatrix = viewMatrix;
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.canvasAspect = canvasWidth / canvasHeight;
        this.recalculate(canvasX, canvasY);
    }

    public PickRay(View view, View.CameraMode cameraMode, Canvas3D canvas, int canvasX, int canvasY) {
        this(view.getProjectionPolicy(), view.getFieldOfView(), view.getScreenScale(), PickRay.getCenterViewX(view.getCenterOfView()), PickRay.getCenterViewY(view.getCenterOfView()), view.getModelViewTransform(cameraMode, true).getMatrix4f(), canvas.getWidth(), canvas.getHeight(), canvasX, canvasY);
        this.lastView = view;
    }

    public PickRay(View.CameraMode cameraMode, Canvas3D canvas, int canvasX, int canvasY) {
        this(canvas.getView().getProjectionPolicy(), canvas.getView().getFieldOfView(), canvas.getView().getScreenScale(), PickRay.getCenterViewX(canvas.getView().getCenterOfView()), PickRay.getCenterViewY(canvas.getView().getCenterOfView()), canvas.getView().getModelViewTransform(cameraMode, true).getMatrix4f(), canvas.getWidth(), canvas.getHeight(), canvasX, canvasY);
        this.lastView = canvas.getView();
    }

    public PickRay(RenderPassConfig rpc, Canvas3D canvas, int canvasX, int canvasY) {
        this();
        this.recalculate(rpc, canvas, canvasX, canvasY);
    }
}

