/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.scenegraph.Billboard;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BillboardManager {
    private static Matrix3f viewRotation = null;
    private static Matrix3f billboardScale = null;
    private static Transform3D viewTransform = null;
    private static Vector3f tmpVector = new Vector3f();

    BillboardManager() {
    }

    private static Matrix3f getViewRotation(View view) {
        if (viewRotation == null) {
            viewRotation = new Matrix3f();
        }
        if (viewTransform == null) {
            viewTransform = new Transform3D();
        }
        view.getTransform(viewTransform);
        viewTransform.getRotation(viewRotation);
        return viewRotation;
    }

    private static float computeZDistance(RenderAtom<?> atom, View view) {
        Point3f viewPosition = view.getPosition();
        Point3f atomPosition = new Point3f();
        atom.getPosition(atomPosition);
        tmpVector.sub((TupleNf)atomPosition, (TupleNf)viewPosition);
        return view.getFacingDirection().dot(tmpVector);
    }

    private static Matrix3f getBillboardXYScaleMatrix(double scaleX, double scaleY) {
        if (billboardScale == null) {
            billboardScale = new Matrix3f();
        }
        billboardScale.setIdentity();
        billboardScale.m00((float)scaleX);
        billboardScale.m11((float)scaleY);
        return billboardScale;
    }

    static void updateBillboardGeometry(RenderAtom<?> billboardAtom, View view, float canvasWidth, float canvasHeight, long nanoTime, long nanoStep, long frameId) {
        Matrix3f viewRotation = BillboardManager.getViewRotation(view);
        Billboard billboard = (Billboard)billboardAtom.getNode();
        Sized2iRO sizeOnScreen = billboard.getSizeOnScreen();
        if (sizeOnScreen != null) {
            switch (view.getProjectionPolicy()) {
                case PERSPECTIVE_PROJECTION: {
                    float zDistance = BillboardManager.computeZDistance(billboardAtom, view);
                    float fovRatio = zDistance * 2.0f * (float)Math.tan(view.getFieldOfView()) / canvasHeight;
                    viewRotation.mul(BillboardManager.getBillboardXYScaleMatrix(fovRatio * (float)sizeOnScreen.getWidth(), fovRatio * (float)sizeOnScreen.getHeight()));
                    break;
                }
                case PARALLEL_PROJECTION: {
                    float factor = 2.0f / canvasWidth;
                    viewRotation.mul(BillboardManager.getBillboardXYScaleMatrix(factor * (float)sizeOnScreen.getWidth(), factor * (float)sizeOnScreen.getHeight()));
                }
            }
        }
        billboard.updateFaceToCamera(viewRotation, frameId, nanoTime, nanoStep);
    }
}

