/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderOptions {
    private static final boolean DEFAULT_VALUE_GL_STATES_CACHE_ENABLED = true;
    public static final boolean DEFAULT_VALUE_LIGHTING_ENABLED = true;
    public static final boolean DEFAULT_VALUE_VBOS_ENABLED = true;
    public static final boolean DEFAULT_VALUE_DISPLAY_LISTS_ENABLED = true;
    public static final boolean DEFAULT_VALUE_TEXTURE_MAPPING_ENABLED = true;
    public static final boolean DEFAULT_VALUE_WIREFRAME_MODE_ENABLED = false;
    public static final boolean DEFAULT_VALUE_GL_ERROR_CHECKS_ENABLED = false;
    public static final boolean DEFAULT_VALUE_GL_TRACING_ENABLED = false;
    private boolean glStatesCacheEnabled = true;
    private boolean lightingEnabled = true;
    private boolean vbosEnabled = true;
    private boolean displayListsEnabled = true;
    private boolean textureMappingEnabled = true;
    private boolean wireframeModeEnabled = false;
    private boolean errorChecksEnabled = false;
    private boolean tracingEnabled = false;

    public void setGLStatesCacheEnabled(boolean enabled) {
        this.glStatesCacheEnabled = enabled;
    }

    public final boolean isGLStatesCacheEnabled() {
        return this.glStatesCacheEnabled;
    }

    public void setLightingEnabled(boolean enabled) {
        this.lightingEnabled = enabled;
    }

    public final boolean isLightingEnabled() {
        return this.lightingEnabled;
    }

    public void setVBOsEnabled(boolean enabled) {
        this.vbosEnabled = enabled;
    }

    public final boolean areVBOsEnabled() {
        return this.vbosEnabled;
    }

    public void setDisplayListsEnabled(boolean enabled) {
        this.displayListsEnabled = enabled;
    }

    public final boolean areDisplayListsEnabled() {
        return this.displayListsEnabled;
    }

    public void setTextureMappingEnabled(boolean enabled) {
        this.textureMappingEnabled = enabled;
    }

    public final boolean isTextureMappingEnabled() {
        return this.textureMappingEnabled && !this.wireframeModeEnabled;
    }

    public void setWireframeModeEnabled(boolean enabled) {
        this.wireframeModeEnabled = enabled;
    }

    public final boolean isWireframeModeEnabled() {
        return this.wireframeModeEnabled;
    }

    public boolean switchWireframeMode() {
        this.setWireframeModeEnabled(!this.isWireframeModeEnabled());
        return this.isWireframeModeEnabled();
    }

    public void setGLErrorChecksEnabled(boolean enabled) {
        this.errorChecksEnabled = enabled;
    }

    public final boolean areGLErrorChecksEnabled() {
        return this.errorChecksEnabled;
    }

    public void setGLTracingEnabled(boolean enabled) {
        this.tracingEnabled = enabled;
    }

    public final boolean isGLTracingEnabled() {
        return this.tracingEnabled;
    }

    public void loadDefaultOptions() {
        this.glStatesCacheEnabled = true;
        this.lightingEnabled = true;
        this.vbosEnabled = true;
        this.displayListsEnabled = true;
        this.textureMappingEnabled = true;
        this.wireframeModeEnabled = false;
        this.errorChecksEnabled = false;
        this.tracingEnabled = false;
    }

    public void loadOptions(RenderOptions renderOptions) {
        this.glStatesCacheEnabled = renderOptions.glStatesCacheEnabled;
        this.lightingEnabled = renderOptions.lightingEnabled;
        this.vbosEnabled = renderOptions.vbosEnabled;
        this.displayListsEnabled = renderOptions.displayListsEnabled;
        this.textureMappingEnabled = renderOptions.textureMappingEnabled;
        this.wireframeModeEnabled = renderOptions.wireframeModeEnabled;
        this.errorChecksEnabled = renderOptions.errorChecksEnabled;
        this.tracingEnabled = renderOptions.tracingEnabled;
    }

    public HashMap<String, Object> exportOptions() {
        HashMap<String, Object> exported = new HashMap<String, Object>();
        exported.put("GL_STATES_CACHE_ENABLED", this.glStatesCacheEnabled);
        exported.put("LIGHTING_ENABLED", this.lightingEnabled);
        exported.put("VBOS_ENABLED", this.vbosEnabled);
        exported.put("DISPLAY_LISTS_ENABLED", this.displayListsEnabled);
        exported.put("TEXTURE_MAPPING_ENABLED", this.textureMappingEnabled);
        exported.put("WIREFRAME_MODE_ENABLED", this.wireframeModeEnabled);
        exported.put("GL_ERROR_CHECKS_ENABLED", this.errorChecksEnabled);
        exported.put("GL_TRACING_ENABLED", this.tracingEnabled);
        return exported;
    }

    private static final boolean importBooleanOption(Map<String, Object> map, String key, boolean defaultValue) {
        Object value = map.get(key);
        if (value == null || !(value instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)value;
    }

    public void importOptions(Map<String, Object> map) {
        this.glStatesCacheEnabled = RenderOptions.importBooleanOption(map, "GL_STATES_CACHE_ENABLED", true);
        this.lightingEnabled = RenderOptions.importBooleanOption(map, "LIGHTING_ENABLED", true);
        this.vbosEnabled = RenderOptions.importBooleanOption(map, "VBOS_ENABLED", true);
        this.displayListsEnabled = RenderOptions.importBooleanOption(map, "DISPLAY_LISTS_ENABLED", true);
        this.textureMappingEnabled = RenderOptions.importBooleanOption(map, "TEXTURE_MAPPING_ENABLED", true);
        this.wireframeModeEnabled = RenderOptions.importBooleanOption(map, "WIREFRAME_MODE_ENABLED", false);
        this.errorChecksEnabled = RenderOptions.importBooleanOption(map, "GL_ERROR_CHECKS_ENABLED", false);
        this.tracingEnabled = RenderOptions.importBooleanOption(map, "GL_TRACING_ENABLED", false);
    }

    public RenderOptions() {
        this.loadDefaultOptions();
    }

    public RenderOptions(RenderOptions base) {
        if (base == null) {
            this.loadDefaultOptions();
        } else {
            this.loadOptions(base);
        }
    }
}

