/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import org.xith3d.render.Clipper;
import org.xith3d.render.Renderer;
import org.xith3d.render.ScissorRect;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.Switch;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.scenegraph.modifications.ScenegraphModificationsListener;

class ScenegraphModificationsManager
implements ScenegraphModificationsListener {
    private final Renderer renderer;
    private boolean anythingChanged = true;

    public final boolean hasAnythingChanged() {
        return this.anythingChanged;
    }

    public void resetAnythingChanged() {
        this.anythingChanged = false;
    }

    private final void setRootDirty(Node node) {
        BranchGroup root = node.getRoot();
        if (root != null) {
            _SG_PrivilegedAccess.forceRefill(root, true);
        }
    }

    public void onBranchGraphAdded(BranchGroup branchGraph) {
        _SG_PrivilegedAccess.forceRefill(branchGraph, true);
        this.anythingChanged = true;
        if (this.renderer.getScenegraphModificationListeners().size() > 0) {
            for (int i = 0; i < this.renderer.getScenegraphModificationListeners().size(); ++i) {
                this.renderer.getScenegraphModificationListeners().get(i).onBranchGraphAdded(branchGraph);
            }
        }
    }

    public void onBranchGraphRemoved(BranchGroup branchGraph) {
        this.anythingChanged = true;
        if (this.renderer.getScenegraphModificationListeners().size() > 0) {
            for (int i = 0; i < this.renderer.getScenegraphModificationListeners().size(); ++i) {
                this.renderer.getScenegraphModificationListeners().get(i).onBranchGraphRemoved(branchGraph);
            }
        }
    }

    public void onNodePropertyChanged(Node node, String property) {
        this.anythingChanged = true;
        if (this.renderer.getScenegraphModificationListeners().size() > 0) {
            for (int i = 0; i < this.renderer.getScenegraphModificationListeners().size(); ++i) {
                this.renderer.getScenegraphModificationListeners().get(i).onNodePropertyChanged(node, property);
            }
        }
    }

    public void onChildAddedToGroup(GroupNode group, Node child) {
        child.setModListener(this);
        this.anythingChanged = true;
        BranchGroup branchGroup = group.getRoot();
        if (branchGroup != null) {
            _SG_PrivilegedAccess.forceRecull(branchGroup, true);
            if (this.renderer.getScenegraphModificationListeners().size() > 0) {
                for (int i = 0; i < this.renderer.getScenegraphModificationListeners().size(); ++i) {
                    this.renderer.getScenegraphModificationListeners().get(i).onChildAddedToGroup(group, child);
                }
            }
        }
    }

    public void onChildRemovedFromGroup(GroupNode group, Node child) {
        this.anythingChanged = true;
        BranchGroup branchGroup = group.getRoot();
        if (branchGroup != null) {
            _SG_PrivilegedAccess.forceRecull(branchGroup, true);
            if (this.renderer.getScenegraphModificationListeners().size() > 0) {
                for (int i = 0; i < this.renderer.getScenegraphModificationListeners().size(); ++i) {
                    this.renderer.getScenegraphModificationListeners().get(i).onChildRemovedFromGroup(group, child);
                }
            }
        }
    }

    public void onSwitchWhichChildChanged(Switch sw, int oldValue, int whichChild) {
        this.anythingChanged = true;
    }

    public void onStateModifierContainmentChanged(GroupNode group, boolean oldValue, boolean newValue) {
        this.anythingChanged = true;
        if (this.renderer.getScenegraphModificationListeners().size() > 0) {
            for (int i = 0; i < this.renderer.getScenegraphModificationListeners().size(); ++i) {
                this.renderer.getScenegraphModificationListeners().get(i).onStateModifierContainmentChanged(group, oldValue, newValue);
            }
        }
    }

    public void onScissorRectChanged(GroupNode group, ScissorRect oldValue, ScissorRect newValue) {
        this.anythingChanged = true;
        if (this.renderer.getScenegraphModificationListeners().size() > 0) {
            for (int i = 0; i < this.renderer.getScenegraphModificationListeners().size(); ++i) {
                this.renderer.getScenegraphModificationListeners().get(i).onScissorRectChanged(group, oldValue, newValue);
            }
        }
    }

    public void onClipperChanged(GroupNode group, Clipper oldValue, Clipper newValue) {
        this.anythingChanged = true;
        if (this.renderer.getScenegraphModificationListeners().size() > 0) {
            for (int i = 0; i < this.renderer.getScenegraphModificationListeners().size(); ++i) {
                this.renderer.getScenegraphModificationListeners().get(i).onClipperChanged(group, oldValue, newValue);
            }
        }
    }

    public void onTransformChanged(TransformGroup tg, Transform3D transform) {
        this.anythingChanged = true;
        if (this.renderer.getScenegraphModificationListeners().size() > 0) {
            for (int i = 0; i < this.renderer.getScenegraphModificationListeners().size(); ++i) {
                this.renderer.getScenegraphModificationListeners().get(i).onTransformChanged(tg, transform);
            }
        }
    }

    public void onNodeComponentChanged(NodeComponent comp) {
        this.anythingChanged = true;
        if (this.renderer.getScenegraphModificationListeners().size() > 0) {
            for (int i = 0; i < this.renderer.getScenegraphModificationListeners().size(); ++i) {
                this.renderer.getScenegraphModificationListeners().get(i).onNodeComponentChanged(comp);
            }
        }
    }

    public ScenegraphModificationsManager(Renderer renderer) {
        this.renderer = renderer;
    }
}

