/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import org.openmali.types.twodee.Sized2iRO;

public class ScissorRect {
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean isChanged;

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setChanged(boolean changed) {
        this.isChanged = changed;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean check(Sized2iRO viewport) {
        return this.x >= 0 && this.y >= 0 && this.x + this.width <= viewport.getWidth() && this.y + this.height <= viewport.getHeight();
    }

    public void clamp(Sized2iRO viewport) {
        if (this.width > viewport.getWidth()) {
            this.width = viewport.getWidth();
        }
        if (this.height > viewport.getHeight()) {
            this.height = viewport.getHeight();
        }
        if (this.x + this.width > viewport.getWidth()) {
            this.x = viewport.getWidth() - this.width;
        }
        if (this.y + this.height > viewport.getHeight()) {
            this.y = viewport.getHeight() - this.height;
        }
        if (this.x < 0) {
            this.x = 0;
        }
        if (this.y < 0) {
            this.y = 0;
        }
    }

    public boolean equals(ScissorRect box2) {
        return box2 != null && (this == box2 || this.x == box2.x && this.y == box2.y && this.width == box2.width && this.height == box2.height);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": [x = " + this.x + ", y = " + this.y + ", width = " + this.width + ", height = " + this.height + "]";
    }

    public void init(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.isChanged = true;
    }

    public ScissorRect(int x, int y, int width, int height) {
        this.init(x, y, width, height);
    }
}

