/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.config;

import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Tuple2i;
import org.xith3d.render.config.DisplayModeSelector;
import org.xith3d.render.config.OpenGLLayer;

public class DisplayMode
implements Sized2iRO {
    public static FullscreenMode FULLSCREEN = FullscreenMode.FULLSCREEN;
    public static FullscreenMode WINDOWED = FullscreenMode.WINDOWED;
    public static FullscreenMode WINDOWED_UNDECORATED = FullscreenMode.WINDOWED_UNDECORATED;
    public static boolean VSYNC_ENABLED = true;
    public static boolean VSYNC_DISABLED = false;
    private final Object nativeMode;
    private final OpenGLLayer oglLayer;
    private final int width;
    private final int height;
    private final int bpp;
    private final int freq;

    public static int getDefaultBPP() {
        return 24;
    }

    public static int getDefaultFrequency() {
        return 75;
    }

    public final OpenGLLayer getOpenGLLayer() {
        return this.oglLayer;
    }

    public Object getNativeMode() {
        return this.nativeMode;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public Tuple2i getSize() {
        return new Tuple2i(this.getWidth(), this.getHeight());
    }

    public float getAspect() {
        return (float)this.getWidth() / (float)this.getHeight();
    }

    public final int getBPP() {
        return this.bpp;
    }

    public final int getFrequency() {
        return this.freq;
    }

    public static DisplayMode parseDisplayMode(OpenGLLayer layer, String value) throws IllegalArgumentException {
        DisplayModeSelector selector = DisplayModeSelector.getImplementation(layer);
        try {
            String[] modeParts = value.split("x");
            int width = Integer.parseInt(modeParts[0]);
            int height = Integer.parseInt(modeParts[1]);
            int bpp = modeParts[2].equals("?") ? 24 : Integer.parseInt(modeParts[2]);
            int freq = modeParts[3].equals("?") ? 75 : Integer.parseInt(modeParts[3]);
            return selector.getBestMode(width, height, bpp, freq);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("The String could not be parsed to a DisplayMode", t);
        }
    }

    public String toLightString() {
        String bpp = this.getBPP() <= 0 ? "?" : String.valueOf(this.getBPP());
        String freq = this.getFrequency() <= 0 ? "?" : String.valueOf(this.getFrequency());
        return this.getWidth() + "x" + this.getHeight() + "x" + bpp + "x" + freq;
    }

    public String toString() {
        return this.toLightString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DisplayMode)) {
            return false;
        }
        DisplayMode otherDM = (DisplayMode)other;
        if (otherDM.width != this.width) {
            return false;
        }
        if (otherDM.height != this.height) {
            return false;
        }
        if (otherDM.bpp != this.bpp) {
            return false;
        }
        return otherDM.freq == this.freq;
    }

    public DisplayMode(OpenGLLayer oglLayer, Object nativeMode, int width, int height, int bpp, int freq) {
        this.oglLayer = oglLayer;
        this.nativeMode = nativeMode;
        this.width = width;
        this.height = height;
        this.bpp = bpp;
        this.freq = freq;
    }

    public DisplayMode(Object nativeMode, int width, int height, int bpp, int freq) {
        this(null, nativeMode, width, height, bpp, freq);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FullscreenMode {
        FULLSCREEN,
        WINDOWED,
        WINDOWED_UNDECORATED;


        public final boolean isFullscreen() {
            return this == FULLSCREEN;
        }

        public final boolean isWindowed() {
            return this == WINDOWED || this == WINDOWED_UNDECORATED;
        }

        public final boolean isUndecorated() {
            return this == WINDOWED_UNDECORATED;
        }
    }
}

