/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.config;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.utility.comparator.Sorter;

public abstract class DisplayModeSelector {
    private static final ModesComparator modesComparator = new ModesComparator();
    public static boolean debug = false;
    private static final HashMap<OpenGLLayer, DisplayModeSelector> selectorCache = new HashMap();

    protected void sortModes(DisplayMode[] modes) {
        for (int i = 0; i < modes.length; ++i) {
            Sorter.quickSort(modes, 0, modes.length - 1, modesComparator);
        }
    }

    public abstract DisplayMode[] getAvailableModes();

    public DisplayMode getDesktopMode() {
        GraphicsDevice graphDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        java.awt.DisplayMode dm = graphDev.getDisplayMode();
        return new DisplayMode(null, dm.getWidth(), dm.getHeight(), dm.getBitDepth(), dm.getRefreshRate());
    }

    public DisplayMode getBestMode(int width, int height, int optimalBPP, int optimalFreq) {
        int i;
        int i2;
        DisplayMode[] modes = this.getAvailableModes();
        if (modes.length == 0) {
            modes = new DisplayMode[]{this.getDesktopMode()};
            if (debug) {
                System.out.println("No DisplayMode available! Falling back to desktop mode!");
            }
        }
        if (debug) {
            System.out.println("Trying to find best mode matching (Width = " + width + ", Height = " + height + " , BPP = " + optimalBPP + ")");
        }
        ArrayList<DisplayMode> foundModes = new ArrayList<DisplayMode>();
        for (i2 = 0; i2 < modes.length; ++i2) {
            if (debug) {
                System.out.println("  Found Mode " + i2 + "... Width = " + modes[i2].getWidth() + ", Height = " + modes[i2].getHeight() + ", BPP = " + modes[i2].getBPP() + ", frequency = " + modes[i2].getFrequency());
            }
            if (modes[i2].getWidth() != width || modes[i2].getHeight() != height || modes[i2].getBPP() != optimalBPP) continue;
            foundModes.add(modes[i2]);
        }
        if (foundModes.size() == 0) {
            for (i2 = 0; i2 < modes.length; ++i2) {
                if (modes[i2].getWidth() != width || modes[i2].getHeight() != height) continue;
                foundModes.add(modes[i2]);
            }
        }
        if (foundModes.size() == 0) {
            if (debug) {
                System.out.println("No matching mode found so far. Trying to find a similar one...");
            }
            Arrays.sort(modes, new ModesComparator());
            DisplayMode bestMode = modes[0];
            for (i = 1; i < modes.length; ++i) {
                int diffW0 = Math.abs(bestMode.getWidth() - width);
                int diffW1 = Math.abs(modes[i].getWidth() - width);
                int diffH0 = Math.abs(bestMode.getHeight() - height);
                int diffH1 = Math.abs(modes[i].getHeight() - height);
                if (diffW1 > diffW0 || diffH1 > diffH0) continue;
                bestMode = modes[i];
            }
            for (i = 0; i < modes.length; ++i) {
                if (modes[i].getWidth() != bestMode.getWidth() || modes[i].getHeight() != bestMode.getHeight()) continue;
                foundModes.add(modes[i]);
            }
            if (debug) {
                System.out.println("Found " + foundModes.size() + " similar mode(s) with (Width = " + bestMode.getWidth() + ", Height = " + bestMode.getHeight() + ").");
            }
        }
        DisplayMode bestMode = null;
        if (foundModes.size() > 0) {
            bestMode = (DisplayMode)foundModes.get(0);
            for (i = 1; i < foundModes.size(); ++i) {
                int diff0 = bestMode.getFrequency() - optimalFreq;
                int diff1 = ((DisplayMode)foundModes.get(i)).getFrequency() - optimalFreq;
                if (diff1 < 0 || diff1 >= diff0 && diff0 >= 0) continue;
                bestMode = (DisplayMode)foundModes.get(i);
            }
        }
        if (debug) {
            if (bestMode == null) {
                System.out.println("No DisplayMode available!");
            } else {
                System.out.println("Using mode: Width = " + bestMode.getWidth() + ", Height = " + bestMode.getHeight() + ", BPP = " + bestMode.getBPP() + ", frequency = " + bestMode.getFrequency());
            }
        }
        return bestMode;
    }

    public DisplayMode getBestMode(int width, int height, int optimalBPP) {
        return this.getBestMode(width, height, optimalBPP, DisplayMode.getDefaultFrequency());
    }

    public DisplayMode getBestMode(int width, int height) {
        return this.getBestMode(width, height, DisplayMode.getDefaultBPP());
    }

    public static DisplayModeSelector getImplementation(OpenGLLayer layer) {
        DisplayModeSelector cached = selectorCache.get(layer);
        if (cached != null) {
            return cached;
        }
        try {
            DisplayModeSelector selector = (DisplayModeSelector)Class.forName(layer.getDisplayModeSelectorClassName()).newInstance();
            selectorCache.put(layer, selector);
            return selector;
        }
        catch (Exception e) {
            Error error = new Error(e);
            throw error;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModesComparator
    implements Comparator<DisplayMode> {
        private ModesComparator() {
        }

        @Override
        public int compare(DisplayMode mode1, DisplayMode mode2) {
            if (mode1.getWidth() > mode2.getWidth()) {
                return 1;
            }
            if (mode1.getWidth() < mode2.getWidth()) {
                return -1;
            }
            if (mode1.getHeight() > mode2.getHeight()) {
                return 1;
            }
            if (mode1.getHeight() < mode2.getHeight()) {
                return -1;
            }
            if (mode1.getBPP() > mode2.getBPP()) {
                return 1;
            }
            if (mode1.getBPP() < mode2.getBPP()) {
                return -1;
            }
            if (mode1.getFrequency() > mode2.getFrequency()) {
                return 1;
            }
            if (mode1.getFrequency() < mode2.getFrequency()) {
                return -1;
            }
            return 0;
        }
    }
}

