/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;
import org.openmali.spatial.bounds.BoundingBox;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.spatial.bounds.BoundsType;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderAtomPeer;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.jsr231.GLUSingleton;
import org.xith3d.render.jsr231.ShapeAtomPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundsAtomPeer
extends RenderAtomPeer {
    private static final Matrix4f TEMP_MAT = new Matrix4f();
    private static final Colorf boundsColor_Shape = new Colorf(1.0f, 0.0f, 0.0f, 0.0f);
    private static final Colorf boundsColor_Group = new Colorf(0.0f, 1.0f, 0.0f, 0.0f);
    private static BoundingSphere boundingSphere = new BoundingSphere();
    private static BoundingBox boundingBox = new BoundingBox();
    private static GLUquadric boundsQuadric = null;
    private static final IntBuffer tmpIntBuffer = BufferUtil.newIntBuffer((int)1);
    private static FloatBuffer colorBuffer = BufferUtil.newFloatBuffer((int)4);

    protected static final int drawBounds(GL gl, Bounds bounds, Colorf color, OpenGLStatesCache statesCache) {
        GLU glu = GLUSingleton.instance();
        switch (bounds.getType()) {
            case SPHERE: {
                if (boundsQuadric == null) {
                    boundsQuadric = glu.gluNewQuadric();
                    glu.gluQuadricDrawStyle(boundsQuadric, 100011);
                }
                if (!statesCache.enabled || statesCache.blendingEnabled) {
                    gl.glDisable(3042);
                }
                statesCache.blendingEnabled = false;
                if (!statesCache.enabled || statesCache.alphaTestEnabled) {
                    gl.glDisable(3008);
                }
                statesCache.alphaTestEnabled = false;
                colorBuffer.rewind();
                gl.glGetFloatv(2816, colorBuffer);
                if (color == null) {
                    gl.glColor4f(boundsColor_Group.getRed(), boundsColor_Group.getGreen(), boundsColor_Group.getBlue(), boundsColor_Group.getAlpha());
                } else {
                    gl.glColor4f(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
                }
                BoundingSphere s = (BoundingSphere)bounds;
                gl.glTranslatef(s.getCenterX(), s.getCenterY(), s.getCenterZ());
                glu.gluSphere(boundsQuadric, (double)s.getRadius(), 12, 12);
                gl.glTranslatef(-s.getCenterX(), -s.getCenterY(), -s.getCenterZ());
                gl.glColor4fv(colorBuffer);
                if (!statesCache.enabled || statesCache.blendingEnabled) {
                    gl.glEnable(3042);
                }
                if (!statesCache.enabled || statesCache.alphaTestEnabled) {
                    gl.glEnable(3008);
                }
                return 0;
            }
            case AABB: {
                if (!statesCache.enabled || statesCache.alphaTestEnabled) {
                    gl.glDisable(3008);
                }
                statesCache.alphaTestEnabled = false;
                colorBuffer.rewind();
                gl.glGetFloatv(2816, colorBuffer);
                gl.glBlendFunc(770, 771);
                if (color == null) {
                    gl.glColor4f(boundsColor_Group.getRed(), boundsColor_Group.getGreen(), boundsColor_Group.getBlue(), 0.05f);
                } else {
                    gl.glColor4f(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
                }
                BoundingBox b = (BoundingBox)bounds;
                Point3f l = b.getLower();
                Point3f u = b.getUpper();
                float size = Math.max(Math.max(u.getX() - l.getX(), u.getY() - l.getY()), u.getZ() - l.getZ());
                float tx = l.getX() + size / 2.0f;
                float ty = l.getY() + size / 2.0f;
                float tz = l.getZ() + size / 2.0f;
                gl.glTranslatef(tx, ty, tz);
                gl.glDepthMask(false);
                gl.glColor4f(boundsColor_Group.getRed(), boundsColor_Group.getGreen(), boundsColor_Group.getBlue(), 0.1f);
                gl.glEnable(3042);
                GLUSingleton.getGLUT().glutSolidCube(size);
                gl.glDepthMask(true);
                tmpIntBuffer.clear();
                gl.glGetIntegerv(2849, tmpIntBuffer);
                int LINE_WIDTH = tmpIntBuffer.get();
                gl.glColor4f(1.0f, 0.0f, 0.0f, 0.0f);
                gl.glLineWidth(3.0f);
                gl.glDisable(3042);
                GLUSingleton.getGLUT().glutWireCube(size);
                gl.glLineWidth((float)LINE_WIDTH);
                gl.glTranslatef(-tx, -ty, -tz);
                gl.glColor4fv(colorBuffer);
                if (!statesCache.enabled || statesCache.blendingEnabled) {
                    gl.glEnable(3042);
                } else {
                    gl.glDisable(3042);
                }
                if (!statesCache.enabled || statesCache.alphaTestEnabled) {
                    gl.glEnable(3008);
                } else {
                    gl.glDisable(3008);
                }
                gl.glDepthMask(statesCache.depthWriteMask);
                return 0;
            }
        }
        return 0;
    }

    @Override
    public int renderAtom(RenderAtom<?> atom, Object glObj, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        if (renderMode != RenderPeer.RenderMode.NORMAL) {
            return 0;
        }
        GL gl = (GL)glObj;
        OpenGLStatesCache statesCache = renderPeer.getStatesCache();
        if (!statesCache.enabled || statesCache.colorMaterialEnabled) {
            gl.glDisable(2903);
            statesCache.colorMaterialEnabled = false;
        }
        if (!statesCache.enabled || statesCache.lightingEnabled) {
            gl.glDisable(2896);
            statesCache.lightingEnabled = false;
        }
        ShapeAtomPeer.setMatrix(gl, view, Transform3D.IDENTITY, false, true);
        Object bounds = ((Node)atom.getNode()).getBounds().getType() == BoundsType.AABB ? boundingBox : boundingSphere;
        bounds.set(((Node)atom.getNode()).getBounds());
        bounds.transform(((Node)atom.getNode()).getWorldTransform().getMatrix4f());
        if (atom.getNode() instanceof TransformGroup) {
            TEMP_MAT.set(((TransformGroup)atom.getNode()).getTransform().getMatrix4f());
            TEMP_MAT.invert();
            bounds.transform(TEMP_MAT);
        }
        return BoundsAtomPeer.drawBounds(gl, (Bounds)bounds, boundsColor_Shape, statesCache);
    }
}

