/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.ShapeAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.MaterialStateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterialStateUnitPeer
implements StateUnitPeer {
    private FloatBuffer tempBuffer = BufferUtil.newFloatBuffer((int)4);

    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        if (renderMode != RenderPeer.RenderMode.NORMAL) {
            return;
        }
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"MaterialStateUnitPeer::apply()");
        GL gl = (GL)glObj;
        Material m = ((MaterialStateUnit)stateUnit).getMaterial();
        if (m != null) {
            if (m.isLightingEnabled() && options.isLightingEnabled()) {
                ShapeAtom shapeAtom;
                Appearance app;
                X3DLog.debug("Lighting enabled");
                if (!statesCache.enabled || !statesCache.lightingEnabled) {
                    gl.glEnable(2896);
                    statesCache.lightingEnabled = true;
                }
                if (m.getColorTarget() != Material.NONE) {
                    gl.glColorMaterial(1032, m.getColorTarget().toOpenGL());
                    if (!statesCache.enabled || !statesCache.colorMaterialEnabled) {
                        gl.glEnable(2903);
                        statesCache.colorMaterialEnabled = true;
                    }
                } else if (!statesCache.enabled || statesCache.colorMaterialEnabled) {
                    gl.glDisable(2903);
                    statesCache.colorMaterialEnabled = false;
                }
                Colorf color = m.getAmbientColor();
                this.tempBuffer.put(color.getRed());
                this.tempBuffer.put(color.getGreen());
                this.tempBuffer.put(color.getBlue());
                this.tempBuffer.put(1.0f);
                this.tempBuffer.rewind();
                gl.glMaterialfv(1032, 4608, this.tempBuffer);
                color = m.getDiffuseColor();
                this.tempBuffer.put(color.getRed());
                this.tempBuffer.put(color.getGreen());
                this.tempBuffer.put(color.getBlue());
                this.tempBuffer.put(1.0f);
                this.tempBuffer.rewind();
                float opaque = 1.0f;
                if (atom instanceof ShapeAtom && (app = ((Shape3D)(shapeAtom = (ShapeAtom)atom).getNode()).getAppearance()) != null && app.getTransparencyAttributes() != null) {
                    opaque = 1.0f - app.getTransparencyAttributes().getTransparency();
                }
                gl.glMaterialfv(1032, 4609, this.tempBuffer);
                color = m.getEmissiveColor();
                this.tempBuffer.put(color.getRed());
                this.tempBuffer.put(color.getGreen());
                this.tempBuffer.put(color.getBlue());
                this.tempBuffer.put(opaque);
                this.tempBuffer.rewind();
                gl.glMaterialfv(1032, 5632, this.tempBuffer);
                color = m.getSpecularColor();
                this.tempBuffer.put(color.getRed());
                this.tempBuffer.put(color.getGreen());
                this.tempBuffer.put(color.getBlue());
                this.tempBuffer.put(1.0f);
                this.tempBuffer.rewind();
                gl.glMaterialfv(1032, 4610, this.tempBuffer);
                gl.glMaterialf(1032, 5633, m.getShininess());
                if (!(!m.getNormalizeNormals() || statesCache.enabled && statesCache.normalizeEnabled)) {
                    gl.glEnable(2977);
                } else if (!(m.getNormalizeNormals() || statesCache.enabled && !statesCache.normalizeEnabled)) {
                    gl.glDisable(2977);
                }
                statesCache.normalizeEnabled = m.getNormalizeNormals();
            } else {
                if (!statesCache.enabled || statesCache.lightingEnabled) {
                    gl.glDisable(2896);
                    statesCache.lightingEnabled = false;
                }
                if (!statesCache.enabled || statesCache.colorMaterialEnabled) {
                    gl.glDisable(2903);
                    statesCache.colorMaterialEnabled = false;
                }
                X3DLog.debug("Lighting disabled");
            }
        } else {
            if (!statesCache.enabled || statesCache.lightingEnabled) {
                gl.glDisable(2896);
                statesCache.lightingEnabled = false;
            }
            if (!statesCache.enabled || statesCache.colorMaterialEnabled) {
                gl.glDisable(2903);
                statesCache.colorMaterialEnabled = false;
            }
            X3DLog.debug("Lighting disabled");
        }
        ProfileTimer.endProfile();
    }
}

