/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.BufferUtil;
import java.io.File;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.List;
import javax.media.opengl.GL;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.openmali.types.twodee.Rect2i;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.BackgroundRenderPass;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.Clipper;
import org.xith3d.render.ClipperInfo;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.OpenGlExtensions;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.ScissorRect;
import org.xith3d.render.StateUnitPeerRegistry;
import org.xith3d.render.jsr231.CanvasPeerImplBase;
import org.xith3d.render.jsr231.RenderTargetPeer;
import org.xith3d.render.jsr231.ShadowRenderPeer;
import org.xith3d.render.jsr231.ShapeAtomPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.render.preprocessing.RenderBinProvider;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.logging.X3DLog;
import org.xith3d.utility.screenshots.ScreenshotCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RenderPeerImpl
extends RenderPeer {
    private GL gl;
    private final FloatBuffer openGLProjMatBuffer = BufferUtil.newFloatBuffer((int)16);
    private final DoubleBuffer planeBuffer = BufferUtil.newDoubleBuffer((int)4);
    private final FloatBuffer defaultLightColorBuffer = BufferUtil.newFloatBuffer((int)4);
    private final FloatBuffer pickMBuffer = BufferUtil.newFloatBuffer((int)16);
    private float[] openGLProjMatrix = new float[16];
    private ScissorRect lastScissorBox = null;
    private int lastClipperId = -1;
    private int activeClipperId = -1;
    private RenderOptions effectiveRenderOptions = new RenderOptions();
    private float[] defaultLightColorArray = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
    private final RenderTargetPeer renderTargetPeer = new RenderTargetPeer(this);
    private final ShadowRenderPeer shadowPeer = new ShadowRenderPeer(this);
    private ScreenshotCreator scheduledShotCreator = null;
    private ScreenshotCreator shotCreator = null;

    public RenderPeerImpl(CanvasPeerImplBase canvasPeer, StateUnitPeerRegistry shaderRegistry, OpenGLStatesCache statesCache, RenderOptions renderOptions) {
        super(canvasPeer, shaderRegistry, statesCache, renderOptions);
    }

    public RenderPeerImpl(CanvasPeerImplBase canvasPeer, StateUnitPeerRegistry shaderRegistry, OpenGLStatesCache statesCache) {
        this(canvasPeer, shaderRegistry, statesCache, new RenderOptions());
    }

    protected static void setGCRequested() {
        RenderPeerImpl.setGCRequested(true);
    }

    @Override
    protected void setCanvasPeer(CanvasPeer canvasPeer) {
        super.setCanvasPeer(canvasPeer);
    }

    public CanvasPeerImplBase getCanvasPeerBase() {
        return (CanvasPeerImplBase)this.getCanvasPeer();
    }

    public GL getGL() {
        return this.gl;
    }

    public final void setDefaultLightColor(float r, float g, float b, float a) {
        this.defaultLightColorArray[0] = r;
        this.defaultLightColorArray[1] = g;
        this.defaultLightColorArray[2] = b;
        this.defaultLightColorArray[3] = a;
    }

    public final float[] getClearColor() {
        return this.clearColor;
    }

    private final void drawFloor(GL gl, OpenGLStatesCache statesCache) {
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glDisable(2884);
        statesCache.cullFaceEnabled = false;
        gl.glDisable(2896);
        statesCache.lightingEnabled = false;
        gl.glDisable(3553);
        statesCache.texture2DEnabled[statesCache.currentServerTextureUnit] = false;
        gl.glDisable(32879);
        statesCache.texture3DEnabled[statesCache.currentServerTextureUnit] = false;
        gl.glDisable(3042);
        statesCache.blendingEnabled = false;
        gl.glDepthMask(false);
        gl.glColor3f(0.2f, 0.2f, 0.7f);
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 1.0f, 0.0f);
        gl.glVertex3f(-200.0f, 0.0f, -200.0f);
        gl.glVertex3f(-200.0f, 0.0f, 200.0f);
        gl.glVertex3f(200.0f, 0.0f, 200.0f);
        gl.glVertex3f(200.0f, 0.0f, -200.0f);
        gl.glEnd();
        gl.glPopMatrix();
        gl.glDepthMask(statesCache.depthWriteMask);
    }

    private final void finishScissors(GL gl, OpenGLStatesCache statesCache) {
        if (!statesCache.enabled || statesCache.scissorTestEnabled) {
            gl.glDisable(3089);
            statesCache.scissorTestEnabled = false;
        }
        this.lastScissorBox = null;
    }

    private final void startScissors(GL gl, OpenGLStatesCache statesCache, ScissorRect scissorBox) {
        if (scissorBox == null && (this.lastScissorBox != null || gl.glIsEnabled(3089))) {
            this.finishScissors(gl, statesCache);
            return;
        }
        if (scissorBox != null) {
            boolean ok;
            if (!scissorBox.equals(this.lastScissorBox)) {
                scissorBox.clamp((Sized2iRO)this.getCanvasPeerBase().getCurrentViewport());
                ok = scissorBox.check((Sized2iRO)this.getCanvasPeerBase().getCurrentViewport());
                if (ok) {
                    gl.glScissor(scissorBox.getX(), scissorBox.getY(), scissorBox.getWidth(), scissorBox.getHeight());
                }
            } else {
                ok = true;
            }
            if (!(!ok || this.lastScissorBox != null && statesCache.enabled && statesCache.scissorTestEnabled)) {
                gl.glEnable(3089);
                statesCache.scissorTestEnabled = true;
            }
            this.lastScissorBox = scissorBox;
        }
    }

    public static final int translateClipPlaneIndex(int index) {
        switch (index) {
            case 0: {
                return 12288;
            }
            case 1: {
                return 12289;
            }
            case 2: {
                return 12290;
            }
            case 3: {
                return 12291;
            }
            case 4: {
                return 12292;
            }
            case 5: {
                return 12293;
            }
        }
        throw new Error("unknown clip plane " + index);
    }

    private final void finishClipper(GL gl, OpenGLStatesCache statesCache) {
        for (int i = 0; i < 6; ++i) {
            if (!statesCache.clipPlaneEnabled[i]) continue;
            gl.glDisable(RenderPeerImpl.translateClipPlaneIndex(i));
            statesCache.clipPlaneEnabled[i] = false;
        }
        this.activeClipperId = -1;
    }

    private final void startClipper(GL gl, OpenGLStatesCache statesCache, ClipperInfo info, View view) {
        Clipper clipper;
        Clipper clipper2 = clipper = info == null ? null : info.getClipper();
        if (clipper != null && clipper.isEnabled()) {
            if (clipper.getId() == this.activeClipperId) {
                return;
            }
            this.activeClipperId = clipper.getId();
            if (this.lastClipperId != clipper.getId()) {
                Transform3D modelView;
                gl.glPushMatrix();
                gl.glLoadMatrixf(_SG_PrivilegedAccess.getFloatBuffer(view.getModelViewTransform(false), true));
                if (!clipper.isWorldCoordinateSystemUsed() && (modelView = info.getModelView()) != null) {
                    float[] matrix = new float[16];
                    modelView.getColumnMajor(matrix);
                    gl.glMultMatrixf(matrix, 0);
                }
            }
            for (int i = 0; i < 6; ++i) {
                int glI = RenderPeerImpl.translateClipPlaneIndex(i);
                if (clipper.isPlaneEnabled(i)) {
                    if (this.lastClipperId != clipper.getId()) {
                        this.planeBuffer.clear();
                        this.planeBuffer.put(clipper.getPlane(i).getA());
                        this.planeBuffer.put(clipper.getPlane(i).getB());
                        this.planeBuffer.put(clipper.getPlane(i).getC());
                        this.planeBuffer.put(clipper.getPlane(i).getD());
                        this.planeBuffer.rewind();
                        gl.glClipPlane(glI, this.planeBuffer);
                    }
                    if (statesCache.enabled && statesCache.clipPlaneEnabled[i]) continue;
                    gl.glEnable(glI);
                    statesCache.clipPlaneEnabled[i] = true;
                    continue;
                }
                if (statesCache.enabled && !statesCache.clipPlaneEnabled[i]) continue;
                gl.glDisable(glI);
                statesCache.clipPlaneEnabled[i] = false;
            }
            if (this.lastClipperId != clipper.getId()) {
                gl.glPopMatrix();
                this.lastClipperId = clipper.getId();
            }
        } else {
            this.finishClipper(gl, statesCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int drawBin(GL gl, OpenGLStatesCache statesCache, OpenGLCapabilities glCaps, RenderOptions options, boolean isScissorEnabled, boolean isClipperEnabled, RenderBin bin, View view, long frameId, int nameOffset, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode) {
        CanvasPeer canvasPeer = this.getCanvasPeer();
        int triangles = 0;
        int n = bin.size();
        for (int i = 0; i < n; ++i) {
            RenderAtom<? extends Node> atom = bin.getAtom(i);
            try {
                if (renderMode == RenderPeer.RenderMode.PICKING) {
                    gl.glPushName(nameOffset + i);
                }
                if (isScissorEnabled) {
                    this.startScissors(gl, statesCache, atom.getScissorRect());
                }
                if (isClipperEnabled) {
                    this.startClipper(gl, statesCache, atom.getClipper(), view);
                }
                triangles += this.renderAtom(atom, gl, canvasPeer, glCaps, statesCache, view, options, nanoTime, nanoStep, renderMode, frameId);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(0);
                continue;
            }
            finally {
                if (renderMode == RenderPeer.RenderMode.PICKING) {
                    gl.glPopName();
                }
            }
        }
        if (isClipperEnabled) {
            this.finishClipper(gl, statesCache);
        }
        return triangles;
    }

    private final void setColorMask(GL gl, int colorMask, OpenGLStatesCache statesCache) {
        if (statesCache.enabled && colorMask == statesCache.colorWriteMask) {
            return;
        }
        gl.glColorMask((colorMask & 1) != 0, (colorMask & 2) != 0, (colorMask & 4) != 0, (colorMask & 8) != 0);
        statesCache.colorWriteMask = colorMask;
    }

    private final void renderStart(GL gl, OpenGLStatesCache statesCache, int atomsCount, PickRequest pickRequest) {
        super.renderStart(pickRequest);
        this.getCanvasPeerBase().beforeRenderStart(pickRequest, this.forceNoSwap);
        if (pickRequest == null) {
            this.selectBuffer = null;
            gl.glRenderMode(7168);
            gl.glClearDepth(1.0);
            if (this.shotCreator != null && this.shotCreator.getFormat() == ScreenshotCreator.Format.RGBA) {
                gl.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], 1.0f);
            } else {
                gl.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
            }
            this.lastScissorBox = null;
            if (!statesCache.enabled || statesCache.scissorTestEnabled) {
                gl.glDisable(3089);
                statesCache.scissorTestEnabled = false;
            }
            if (!this.disableClearBuffer) {
                if (this.fullOverpaint) {
                    gl.glClear(1280);
                } else {
                    gl.glClear(17664);
                }
            }
        } else {
            gl.glRenderMode(7168);
            gl.glClearColor(0.2f, 0.2f, 0.2f, 0.0f);
            gl.glClearDepth(1.0);
            gl.glClear(1280);
            int selectBufferCapacity = atomsCount * 4;
            this.selectBuffer = BufferUtil.newIntBuffer((int)selectBufferCapacity);
            gl.glSelectBuffer(selectBufferCapacity, this.selectBuffer);
            gl.glRenderMode(7170);
            gl.glInitNames();
        }
        gl.glDepthFunc(513);
        gl.glHint(3152, 4354);
        gl.glHint(3154, 4354);
        gl.glHint(3155, 4354);
        gl.glShadeModel(7425);
        this.defaultLightColorBuffer.put(this.defaultLightColorArray);
        this.defaultLightColorBuffer.rewind();
        gl.glLightModelfv(2899, this.defaultLightColorBuffer);
        if (OpenGlExtensions.GL_EXT_separate_specular_color) {
            gl.glLightModeli(33272, 33274);
        }
        gl.glPixelStorei(3317, 1);
    }

    private final void gluPickMatrix(GL gl, float x, float y, float width, float height, int[] viewport) {
        float[] m = new float[16];
        float sx = (float)viewport[2] / width;
        float sy = (float)viewport[3] / height;
        float tx = ((float)viewport[2] + 2.0f * ((float)viewport[0] - x)) / width;
        float ty = ((float)viewport[3] + 2.0f * ((float)viewport[1] - y)) / height;
        m[0] = sx;
        m[4] = 0.0f;
        m[8] = 0.0f;
        m[12] = tx;
        m[1] = 0.0f;
        m[5] = sy;
        m[9] = 0.0f;
        m[13] = ty;
        m[2] = 0.0f;
        m[6] = 0.0f;
        m[10] = 1.0f;
        m[14] = 0.0f;
        m[3] = 0.0f;
        m[7] = 0.0f;
        m[11] = 0.0f;
        m[15] = 1.0f;
        this.pickMBuffer.put(m);
        this.pickMBuffer.rewind();
        gl.glMultMatrixf(this.pickMBuffer);
    }

    private final void renderStartView(GL gl, View view, PickRequest pickRequest) {
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        if (pickRequest != null) {
            Rect2i currentViewport = this.getCanvasPeerBase().getCurrentViewport();
            int y = this.getCanvasPeer().getHeight() - currentViewport.getTop() - currentViewport.getHeight();
            int[] viewport = new int[]{currentViewport.getLeft(), y, currentViewport.getWidth(), currentViewport.getHeight()};
            this.gluPickMatrix(gl, pickRequest.getMouseX(), viewport[3] - pickRequest.getMouseY(), 1.0f, 1.0f, viewport);
        }
        view.getProjection().getColumnMajor(this.openGLProjMatrix);
        this.openGLProjMatBuffer.put(this.openGLProjMatrix);
        this.openGLProjMatBuffer.rewind();
        gl.glMultMatrixf(this.openGLProjMatBuffer);
        gl.glMatrixMode(5888);
    }

    private final void setGLModelViewMatrix(GL gl, View view, View.CameraMode mode) {
        gl.glLoadMatrixf(_SG_PrivilegedAccess.getFloatBuffer(view.getModelViewTransform(mode, true), true));
    }

    private final int renderMain(GL gl, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, RenderOptions options, boolean isScissorEnabled, boolean isClipperEnabled, View view, RenderPass renderPass, long frameId, int nameOffset, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode) throws Throwable {
        X3DLog.debug("Rendering opaque and transparent bin");
        int triangles = 0;
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"CanvasPeerImpl::Drawing Main Scene");
        RenderBinProvider binProvider = renderPass.getRenderBinProvider();
        if (binProvider.getOpaqueBin().size() > 0) {
            if (!statesCache.enabled || !statesCache.depthTestEnabled) {
                gl.glEnable(2929);
                statesCache.depthTestEnabled = true;
            }
            triangles += this.drawBin(gl, statesCache, glCaps, options, isScissorEnabled, isClipperEnabled, binProvider.getOpaqueBin(), view, frameId, nameOffset, nanoTime, nanoStep, renderMode);
            nameOffset += binProvider.getOpaqueBin().size();
        }
        if (binProvider.getTransparentBin().size() > 0) {
            triangles += this.drawBin(gl, statesCache, glCaps, options, isScissorEnabled, isClipperEnabled, binProvider.getTransparentBin(), view, frameId, nameOffset, nanoTime, nanoStep, renderMode);
            nameOffset += binProvider.getTransparentBin().size();
        }
        ProfileTimer.endProfile();
        if (!(renderMode != RenderPeer.RenderMode.PICKING || statesCache.enabled && statesCache.depthTestEnabled)) {
            gl.glEnable(2929);
            statesCache.depthTestEnabled = true;
        }
        if (renderMode != RenderPeer.RenderMode.PICKING && (this.shotCreator == null || this.shotCreator.getFormat() == ScreenshotCreator.Format.RGB)) {
            triangles += this.shadowPeer.drawShadows(gl, view, renderPass.getShadowCasterLight(), binProvider.getShadowsBin(), frameId);
        }
        this.getCanvasPeer().addTriangles(triangles);
        return nameOffset;
    }

    private final Object renderDone(GL gl, List<RenderPass> renderPasses, PickRequest pickRequest, OpenGLStatesCache statesCache, long frameId) {
        if (!statesCache.enabled || !statesCache.depthWriteMask) {
            gl.glDepthMask(true);
            statesCache.depthWriteMask = true;
        }
        if (!statesCache.enabled || statesCache.colorWriteMask != 15) {
            gl.glColorMask(true, true, true, true);
            statesCache.colorWriteMask = 15;
        }
        super.renderDone(frameId);
        if (pickRequest != null) {
            gl.glFlush();
            return this.convertSelectBuffer(gl.glRenderMode(7168), renderPasses, pickRequest.getPickAll());
        }
        return null;
    }

    public final int renderRenderPass(Object glObj, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, List<RenderPass> renderPasses, RenderPass renderPass, int rpIndex, boolean isRenderTargetMode, RenderPeer.RenderMode renderMode, View view, boolean layeredMode, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest, int nameOffset) throws Throwable {
        RenderPassConfig passConfig = renderPass.getConfig();
        if (pickRequest == null) {
            renderPass.getRenderCallbackNotifier().notifyBeforeRenderPassIsRendered(renderPass, this.getCanvasPeer().getType(), glObj);
        }
        if (passConfig.getColorMask() == -1) {
            this.setColorMask(this.gl, this.colorMask, statesCache);
        } else {
            this.setColorMask(this.gl, passConfig.getColorMask(), statesCache);
        }
        _SG_PrivilegedAccess.set(view, true, passConfig);
        this.setGLModelViewMatrix(this.gl, view, passConfig.getCameraMode());
        if (renderPass.isEnabled()) {
            if (passConfig != null) {
                if (passConfig.getRenderOptions() != null) {
                    this.effectiveRenderOptions.loadOptions(passConfig.getRenderOptions());
                } else {
                    this.effectiveRenderOptions.loadOptions(this.getRenderOptions());
                }
                if (isRenderTargetMode && renderMode != RenderPeer.RenderMode.SHADOW_MAP_GENERATION) {
                    this.getCanvasPeerBase().updateViewport(this.gl, passConfig.getViewport());
                }
            } else {
                this.effectiveRenderOptions.loadOptions(this.getRenderOptions());
                if (isRenderTargetMode && renderMode != RenderPeer.RenderMode.SHADOW_MAP_GENERATION) {
                    this.getCanvasPeerBase().updateViewport(this.gl, null);
                }
            }
            statesCache.enabled = this.effectiveRenderOptions.isGLStatesCacheEnabled();
            view.getFrustum((Sized2iRO)(this.getCanvasPeerBase().getCurrentViewport() == null ? this.getCanvasPeer().getCanvas3D() : this.getCanvasPeerBase().getCurrentViewport()));
            if (isRenderTargetMode && renderPass.getRenderTarget() != null) {
                renderPass.getRenderCallbackNotifier().notifyBeforeRenderTargetIsActivated(renderPass, renderPass.getRenderTarget(), this.getCanvasPeer().getType(), glObj);
                this.renderTargetPeer.setupRenderTarget(this.gl, glCaps, statesCache, this.getCanvasPeer(), renderPass.getRenderTarget());
                renderPass.getRenderCallbackNotifier().notifyAfterRenderTargetIsActivated(renderPass, renderPass.getRenderTarget(), this.getCanvasPeer().getType(), glObj);
            }
            this.renderStartView(this.gl, view, pickRequest);
            if (isRenderTargetMode && renderPass.getRenderTarget() != null && renderPass.getRenderTarget().isBackgroundRenderingEnabled()) {
                for (int i = 0; i < renderPasses.size(); ++i) {
                    RenderPass bgPass = renderPasses.get(i);
                    if (!(bgPass instanceof BackgroundRenderPass)) continue;
                    nameOffset += this.renderRenderPass(glObj, glCaps, statesCache, renderPasses, bgPass, i, false, renderMode, view, layeredMode, frameId, nanoTime, nanoStep, pickRequest, nameOffset);
                }
                this.gl.glClear(256);
                this.setGLModelViewMatrix(this.gl, view, passConfig.getCameraMode());
                view.getFrustum((Sized2iRO)this.getCanvasPeerBase().getCurrentViewport());
                this.renderStartView(this.gl, view, pickRequest);
            }
            if ((layeredMode && !renderPass.isUnlayeredModeForced() || !layeredMode && renderPass.isLayeredModeForced()) && rpIndex > 0) {
                this.gl.glClear(256);
            }
            if (pickRequest == null) {
                renderPass.getRenderCallbackNotifier().notifyAfterRenderPassIsSetUp(renderPass, this.getCanvasPeer().getType(), glObj);
            }
            nameOffset += this.renderMain(this.gl, glCaps, statesCache, this.effectiveRenderOptions, renderPass.isScissorEnabled(), renderPass.isClipperEnabled(), view, renderPass, frameId, nameOffset, nanoTime, nanoStep, pickRequest != null ? RenderPeer.RenderMode.PICKING : RenderPeer.RenderMode.NORMAL);
            if (isRenderTargetMode && renderPass.getRenderTarget() != null) {
                renderPass.getRenderCallbackNotifier().notifyBeforeRenderTargetIsDeactivated(renderPass, renderPass.getRenderTarget(), this.getCanvasPeer().getType(), glObj);
                this.renderTargetPeer.finishRenderTarget(this.gl, renderPass.getRenderTarget());
                renderPass.getRenderCallbackNotifier().notifyAfterRenderTargetIsDeactivated(renderPass, renderPass.getRenderTarget(), this.getCanvasPeer().getType(), glObj);
            }
        } else if (pickRequest != null) {
            nameOffset += renderPass.getRenderBinProvider().getAtomsCount();
        }
        if (renderMode == RenderPeer.RenderMode.SHADOW_MAP_GENERATION || passConfig != null && passConfig.getRenderOptions() != null || rpIndex + 1 < renderPasses.size() && renderPasses.get(rpIndex + 1).getConfig() != null && renderPasses.get(rpIndex + 1).getConfig().getRenderOptions() != null) {
            super.renderDone(frameId);
            super.resetStateUnitStateArrays();
        }
        _SG_PrivilegedAccess.set(view, false, null);
        if (pickRequest == null) {
            renderPass.getRenderCallbackNotifier().notifyAfterRenderPassCompleted(renderPass, this.getCanvasPeer().getType(), glObj);
        }
        return nameOffset;
    }

    @Override
    public final Object render(Object glObj, View view, List<RenderPass> renderPasses, boolean layeredMode, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        if (view == null) {
            return null;
        }
        this.gl = (GL)glObj;
        this.lastClipperId = -1;
        this.shotCreator = this.scheduledShotCreator;
        this.scheduledShotCreator = null;
        OpenGLCapabilities glCaps = this.getCanvasPeer().getOpenGLCapabilities();
        OpenGLStatesCache statesCache = this.getStatesCache();
        statesCache.enabled = this.getRenderOptions().isGLStatesCacheEnabled();
        Object result = null;
        ShapeAtomPeer.reset();
        X3DLog.debug("Starting to render the frame");
        try {
            if (renderPasses != null && renderPasses.size() > 0) {
                RenderBinProvider firstBinProvider = renderPasses.get(0).getRenderBinProvider();
                this.renderStart(this.gl, statesCache, firstBinProvider.getAtomsCount(), pickRequest);
                int nameOffset = 0;
                for (int i = 0; i < renderPasses.size(); ++i) {
                    RenderPass renderPass = renderPasses.get(i);
                    if (!renderPass.isEnabled()) continue;
                    if (this.shotCreator == null || this.shotCreator.getFormat() == ScreenshotCreator.Format.RGB) {
                        nameOffset += this.shadowPeer.initShadows(this.gl, view, renderPass.getShadowCasterLight(), renderPass.getRenderBinProvider().getShadowsBin(), frameId);
                    }
                    nameOffset += this.renderRenderPass(glObj, glCaps, statesCache, renderPasses, renderPass, i, true, pickRequest == null ? RenderPeer.RenderMode.NORMAL : RenderPeer.RenderMode.PICKING, view, layeredMode, frameId, nanoTime, nanoStep, pickRequest, nameOffset);
                }
                this.renderDone(this.gl, renderPasses, pickRequest, statesCache, frameId);
                if (this.shotCreator != null) {
                    this.gl.glReadBuffer(1028);
                    this.gl.glPixelStorei(3333, 1);
                    int offset = this.shotCreator.getFormat() == ScreenshotCreator.Format.RGBA ? 0 : 0;
                    this.gl.glReadPixels(0, offset, this.getCanvasPeer().getWidth(), this.getCanvasPeer().getHeight(), this.shotCreator.getFormat().getIntGL(), 5121, (Buffer)this.shotCreator.getBuffer());
                    this.shotCreator.createScreenshot();
                    this.shotCreator = null;
                }
            }
        }
        catch (Throwable terr) {
            X3DLog.print(terr);
            terr.printStackTrace();
            throw new Error(terr);
        }
        RenderPeerImpl.checkGCRequested();
        X3DLog.debug("Done rendering the frame");
        return result;
    }

    public void clearViewport(GL gl, float r, float g, float b, float a) {
        gl.glClearColor(r, g, b, a);
        gl.glClear(16384);
        gl.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
    }

    public void clearViewport(GL gl) {
        this.clearViewport(gl, this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
    }

    @Override
    public final void takeScreenshot(File file, boolean alpha) {
        ScreenshotCreator.Format format = alpha ? ScreenshotCreator.Format.RGBA : ScreenshotCreator.Format.RGB;
        this.scheduledShotCreator = new ScreenshotCreator(this.getCanvasPeer().getWidth(), this.getCanvasPeer().getHeight(), format, file);
    }
}

