/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import javax.media.opengl.GL;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.jagatoo.opengl.enums.TestFunction;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.RenderingAttribsStateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.StencilFuncSeparate;
import org.xith3d.scenegraph.StencilMaskSeparate;
import org.xith3d.scenegraph.StencilOpSeparate;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingAttribsStateUnitPeer
implements StateUnitPeer {
    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        boolean alphaTest;
        boolean depthTest;
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"RenderingAttribsStateUnitPeer::apply()");
        GL gl = (GL)glObj;
        RenderingAttributes ra = ((RenderingAttribsStateUnit)stateUnit).getRenderingAttributes();
        if (!statesCache.enabled || statesCache.depthWriteMask != ra.isDepthBufferWriteEnabled()) {
            gl.glDepthMask(ra.isDepthBufferWriteEnabled());
            statesCache.depthWriteMask = ra.isDepthBufferWriteEnabled();
        }
        if (ra.hasColorWriteMask() && (!statesCache.enabled || statesCache.colorWriteMask != ra.getColorWriteMask())) {
            gl.glColorMask(ra.isRedWriteEnabled(), ra.isGreenWriteEnabled(), ra.isBlueWriteEnabled(), ra.isAlphaWriteEnabled());
            statesCache.colorWriteMask = ra.getColorWriteMask();
        }
        if (ra.isDepthBufferEnabled()) {
            gl.glDepthFunc(ra.getDepthTestFunction().toOpenGL());
            depthTest = ra.getDepthTestFunction() != TestFunction.ALWAYS;
        } else {
            depthTest = false;
        }
        if (!(!depthTest || statesCache.enabled && statesCache.depthTestEnabled)) {
            gl.glEnable(2929);
        } else if (!(depthTest || statesCache.enabled && !statesCache.depthTestEnabled)) {
            gl.glDisable(2929);
        }
        statesCache.depthTestEnabled = depthTest;
        if (!statesCache.enabled || statesCache.blendingEnabled) {
            gl.glAlphaFunc(ra.getAlphaTestFunction().toOpenGL(), ra.getAlphaTestValue());
            alphaTest = ra.getAlphaTestFunction() != TestFunction.ALWAYS;
        } else {
            alphaTest = false;
        }
        if (!(!alphaTest || statesCache.enabled && statesCache.alphaTestEnabled)) {
            gl.glEnable(3008);
        } else if (!(alphaTest || statesCache.enabled && !statesCache.alphaTestEnabled)) {
            gl.glDisable(3008);
        }
        statesCache.alphaTestEnabled = alphaTest;
        if (ra.isStencilEnabled()) {
            if (!statesCache.enabled || !statesCache.stencilTestEnabled) {
                gl.glEnable(2960);
            }
            gl.glStencilFunc(ra.getStencilTestFunction().toOpenGL(), ra.getStencilRef(), ra.getStencilMask());
            gl.glStencilOp(ra.getStencilOpFail().toOpenGL(), ra.getStencilOpZFail().toOpenGL(), ra.getStencilOpZPass().toOpenGL());
            if (renderPeer.getCanvasPeer().getOpenGLInfo().getVersionMajor() >= 2) {
                StencilMaskSeparate maskSep;
                StencilOpSeparate opSep;
                StencilFuncSeparate funcSep = ra.getStencilFuncSeparate();
                if (funcSep != null) {
                    gl.glStencilFuncSeparate(funcSep.getFace().toOpenGL(), funcSep.getTestFunction().toOpenGL(), funcSep.getRef(), funcSep.getMask());
                }
                if ((opSep = ra.getStencilOpSeparate()) != null) {
                    gl.glStencilOpSeparate(opSep.getFace().toOpenGL(), opSep.getSFail().toOpenGL(), opSep.getDPFail().toOpenGL(), opSep.getDPPass().toOpenGL());
                }
                if ((maskSep = ra.getStencilMaskSeparate()) != null) {
                    gl.glStencilMaskSeparate(maskSep.getFace().toOpenGL(), maskSep.getMask());
                }
            }
        } else if (!statesCache.enabled || statesCache.stencilTestEnabled) {
            gl.glDisable(2960);
        }
        statesCache.stencilTestEnabled = ra.isStencilEnabled();
        ProfileTimer.endProfile();
    }
}

