/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.openmali.FastMath;
import org.openmali.spatial.bounds.BoundingBox;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.spatial.bounds.BoundsType;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderAtomPeer;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.lwjgl.ShapeAtomPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundsAtomPeer
extends RenderAtomPeer {
    private static final Matrix4f TEMP_MAT = new Matrix4f();
    private static final Colorf boundsColor_Shape = new Colorf(1.0f, 0.0f, 0.0f, 0.0f);
    private static BoundingSphere boundingSphere = new BoundingSphere();
    private static BoundingBox boundingBox = new BoundingBox();
    private static FloatBuffer tmpPlaneBuffer = BufferUtils.createFloatBuffer((int)4);
    private static final IntBuffer tmpIntBuffer = BufferUtils.createIntBuffer((int)16);
    private static FloatBuffer currentColor = BufferUtils.createFloatBuffer((int)16);
    private static final Colorf boundsColor_Group = new Colorf(0.0f, 1.0f, 0.0f, 0.0f);
    private static final int DRAW_STYLE_POINT = 1;
    private static final int DRAW_STYLE_LINE = 2;
    private static final int DRAW_STYLE_FILL = 3;
    private static final int DRAW_STYLE_SILHOUETTE = 4;

    private static void drawSphere(float radius, int slices, int stacks, boolean withNormals, boolean normalsToOutside, boolean withTextureCoords) {
        float nsign = normalsToOutside ? 1.0f : -1.0f;
        float drho = (float)Math.PI / (float)stacks;
        float dtheta = (float)Math.PI * 2 / (float)slices;
        int drawStyle = 2;
        if (drawStyle == 3) {
            float s;
            float rho;
            int imax;
            int imin;
            float z;
            float y;
            float x;
            float theta;
            int j;
            if (!withTextureCoords) {
                GL11.glBegin((int)6);
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glVertex3f((float)0.0f, (float)0.0f, (float)(nsign * radius));
                for (j = 0; j <= slices; ++j) {
                    theta = j == slices ? 0.0f : (float)j * dtheta;
                    x = -FastMath.sin((float)theta) * FastMath.sin((float)drho);
                    y = FastMath.cos((float)theta) * FastMath.sin((float)drho);
                    z = nsign * FastMath.cos((float)drho);
                    if (withNormals) {
                        GL11.glNormal3f((float)(x * nsign), (float)(y * nsign), (float)(z * nsign));
                    }
                    GL11.glVertex3f((float)(x * radius), (float)(y * radius), (float)(z * radius));
                }
                GL11.glEnd();
            }
            float ds = 1.0f / (float)slices;
            float dt = 1.0f / (float)stacks;
            float t = 1.0f;
            if (withTextureCoords) {
                imin = 0;
                imax = stacks;
            } else {
                imin = 1;
                imax = stacks - 1;
            }
            for (int i = imin; i < imax; ++i) {
                rho = (float)i * drho;
                GL11.glBegin((int)8);
                s = 0.0f;
                for (j = 0; j <= slices; ++j) {
                    theta = j == slices ? 0.0f : (float)j * dtheta;
                    x = -FastMath.sin((float)theta) * FastMath.sin((float)rho);
                    y = FastMath.cos((float)theta) * FastMath.sin((float)rho);
                    z = nsign * FastMath.cos((float)rho);
                    if (withNormals) {
                        GL11.glNormal3f((float)(x * nsign), (float)(y * nsign), (float)(z * nsign));
                    }
                    if (withTextureCoords) {
                        GL11.glTexCoord2f((float)s, (float)t);
                    }
                    GL11.glVertex3f((float)(x * radius), (float)(y * radius), (float)(z * radius));
                    x = -FastMath.sin((float)theta) * FastMath.sin((float)(rho + drho));
                    y = FastMath.cos((float)theta) * FastMath.sin((float)(rho + drho));
                    z = nsign * FastMath.cos((float)(rho + drho));
                    if (withNormals) {
                        GL11.glNormal3f((float)(x * nsign), (float)(y * nsign), (float)(z * nsign));
                    }
                    if (withTextureCoords) {
                        GL11.glTexCoord2f((float)s, (float)(t - dt));
                    }
                    s += ds;
                    GL11.glVertex3f((float)(x * radius), (float)(y * radius), (float)(z * radius));
                }
                GL11.glEnd();
                t -= dt;
            }
            if (!withTextureCoords) {
                GL11.glBegin((int)6);
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glVertex3f((float)0.0f, (float)0.0f, (float)(-radius * nsign));
                rho = (float)Math.PI - drho;
                s = 1.0f;
                for (j = slices; j >= 0; --j) {
                    theta = j == slices ? 0.0f : (float)j * dtheta;
                    x = -FastMath.sin((float)theta) * FastMath.sin((float)rho);
                    y = FastMath.cos((float)theta) * FastMath.sin((float)rho);
                    z = nsign * FastMath.cos((float)rho);
                    if (withNormals) {
                        GL11.glNormal3f((float)(x * nsign), (float)(y * nsign), (float)(z * nsign));
                    }
                    s -= ds;
                    GL11.glVertex3f((float)(x * radius), (float)(y * radius), (float)(z * radius));
                }
                GL11.glEnd();
            }
        } else if (drawStyle == 2 || drawStyle == 4) {
            float z;
            float y;
            float x;
            float theta;
            int j;
            float rho;
            int i;
            for (i = 1; i < stacks; ++i) {
                rho = (float)i * drho;
                GL11.glBegin((int)2);
                for (j = 0; j < slices; ++j) {
                    theta = (float)j * dtheta;
                    x = FastMath.cos((float)theta) * FastMath.sin((float)rho);
                    y = FastMath.sin((float)theta) * FastMath.sin((float)rho);
                    z = FastMath.cos((float)rho);
                    if (withNormals) {
                        GL11.glNormal3f((float)(x * nsign), (float)(y * nsign), (float)(z * nsign));
                    }
                    GL11.glVertex3f((float)(x * radius), (float)(y * radius), (float)(z * radius));
                }
                GL11.glEnd();
            }
            for (j = 0; j < slices; ++j) {
                theta = (float)j * dtheta;
                GL11.glBegin((int)3);
                for (i = 0; i <= stacks; ++i) {
                    rho = (float)i * drho;
                    x = FastMath.cos((float)theta) * FastMath.sin((float)rho);
                    y = FastMath.sin((float)theta) * FastMath.sin((float)rho);
                    z = FastMath.cos((float)rho);
                    if (withNormals) {
                        GL11.glNormal3f((float)(x * nsign), (float)(y * nsign), (float)(z * nsign));
                    }
                    GL11.glVertex3f((float)(x * radius), (float)(y * radius), (float)(z * radius));
                }
                GL11.glEnd();
            }
        } else if (drawStyle == 1) {
            GL11.glBegin((int)0);
            if (withNormals) {
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)nsign);
            }
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)radius);
            if (withNormals) {
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-nsign));
            }
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)(-radius));
            for (int i = 1; i < stacks - 1; ++i) {
                float rho = (float)i * drho;
                for (int j = 0; j < slices; ++j) {
                    float theta = (float)j * dtheta;
                    float x = FastMath.cos((float)theta) * FastMath.sin((float)rho);
                    float y = FastMath.sin((float)theta) * FastMath.sin((float)rho);
                    float z = FastMath.cos((float)rho);
                    if (withNormals) {
                        GL11.glNormal3f((float)(x * nsign), (float)(y * nsign), (float)(z * nsign));
                    }
                    GL11.glVertex3f((float)(x * radius), (float)(y * radius), (float)(z * radius));
                }
            }
            GL11.glEnd();
        }
    }

    private static final void drawCube(float sizeX, float sizeY, float sizeZ) {
        float hsx = sizeX / 2.0f;
        float hsy = sizeY / 2.0f;
        float hsz = sizeZ / 2.0f;
        GL11.glBegin((int)7);
        GL11.glVertex3f((float)hsx, (float)hsy, (float)(-hsz));
        GL11.glVertex3f((float)(-hsx), (float)hsy, (float)(-hsz));
        GL11.glVertex3f((float)(-hsx), (float)hsy, (float)hsz);
        GL11.glVertex3f((float)hsx, (float)hsy, (float)hsz);
        GL11.glVertex3f((float)hsx, (float)(-hsy), (float)hsz);
        GL11.glVertex3f((float)(-hsx), (float)(-hsy), (float)hsz);
        GL11.glVertex3f((float)(-hsx), (float)(-hsy), (float)(-hsz));
        GL11.glVertex3f((float)hsx, (float)(-hsy), (float)(-hsz));
        GL11.glVertex3f((float)hsx, (float)hsy, (float)hsz);
        GL11.glVertex3f((float)(-hsx), (float)hsy, (float)hsz);
        GL11.glVertex3f((float)(-hsx), (float)(-hsy), (float)hsz);
        GL11.glVertex3f((float)hsx, (float)(-hsy), (float)hsz);
        GL11.glVertex3f((float)hsx, (float)(-hsy), (float)(-hsz));
        GL11.glVertex3f((float)(-hsx), (float)(-hsy), (float)(-hsz));
        GL11.glVertex3f((float)(-hsx), (float)hsy, (float)(-hsz));
        GL11.glVertex3f((float)hsx, (float)hsy, (float)(-hsz));
        GL11.glVertex3f((float)(-hsx), (float)hsy, (float)hsz);
        GL11.glVertex3f((float)(-hsx), (float)hsy, (float)(-hsz));
        GL11.glVertex3f((float)(-hsx), (float)(-hsy), (float)(-hsz));
        GL11.glVertex3f((float)(-hsx), (float)(-hsy), (float)hsz);
        GL11.glVertex3f((float)hsx, (float)hsy, (float)(-hsz));
        GL11.glVertex3f((float)hsx, (float)hsy, (float)hsz);
        GL11.glVertex3f((float)hsx, (float)(-hsy), (float)hsz);
        GL11.glVertex3f((float)hsx, (float)(-hsy), (float)(-hsz));
        GL11.glEnd();
    }

    protected static final int drawBounds(Bounds bounds, Colorf color, OpenGLStatesCache statesCache) {
        tmpIntBuffer.clear();
        GL11.glGetTexEnv((int)8960, (int)8704, (IntBuffer)tmpIntBuffer);
        int oldTexEnvMode = tmpIntBuffer.get();
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        tmpPlaneBuffer.clear();
        GL11.glGetTexEnv((int)8960, (int)8705, (FloatBuffer)tmpPlaneBuffer);
        float[] oldTexEnvColor = new float[]{tmpPlaneBuffer.get(), tmpPlaneBuffer.get(), tmpPlaneBuffer.get(), tmpPlaneBuffer.get()};
        tmpPlaneBuffer.clear();
        tmpPlaneBuffer.put(0, 0.0f);
        tmpPlaneBuffer.put(1, 0.0f);
        tmpPlaneBuffer.put(2, 0.0f);
        tmpPlaneBuffer.put(3, 1.0f);
        GL11.glTexEnv((int)8960, (int)8705, (FloatBuffer)tmpPlaneBuffer);
        boolean oldTex1D = GL11.glIsEnabled((int)3552);
        boolean oldTex2D = GL11.glIsEnabled((int)3553);
        boolean oldTex3D = GL11.glIsEnabled((int)32879);
        boolean oldTexCM = GL11.glIsEnabled((int)34067);
        GL11.glDisable((int)3552);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)32879);
        GL11.glDisable((int)34067);
        switch (bounds.getType()) {
            case SPHERE: {
                boolean isBlended = statesCache.blendingEnabled;
                boolean isAlphaTest = statesCache.alphaTestEnabled;
                if (isBlended) {
                    GL11.glDisable((int)3042);
                }
                if (isAlphaTest) {
                    GL11.glDisable((int)3008);
                }
                currentColor.clear();
                GL11.glGetFloat((int)2816, (FloatBuffer)currentColor);
                if (color == null) {
                    GL11.glColor4f((float)boundsColor_Group.getRed(), (float)boundsColor_Group.getGreen(), (float)boundsColor_Group.getBlue(), (float)boundsColor_Group.getAlpha());
                } else {
                    GL11.glColor4f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
                }
                BoundingSphere s = (BoundingSphere)bounds;
                GL11.glTranslatef((float)s.getCenterX(), (float)s.getCenterY(), (float)s.getCenterZ());
                BoundsAtomPeer.drawSphere(s.getRadius(), 12, 12, false, true, false);
                GL11.glTranslatef((float)(-s.getCenterX()), (float)(-s.getCenterY()), (float)(-s.getCenterZ()));
                GL11.glColor4f((float)currentColor.get(), (float)currentColor.get(), (float)currentColor.get(), (float)currentColor.get());
                if (isBlended) {
                    GL11.glEnable((int)3042);
                }
                if (!isAlphaTest) break;
                GL11.glEnable((int)3008);
                break;
            }
            case AABB: {
                boolean isBlended = GL11.glIsEnabled((int)3042);
                boolean isAlphaTest = GL11.glIsEnabled((int)3008);
                if (isAlphaTest) {
                    GL11.glDisable((int)3008);
                }
                currentColor.clear();
                GL11.glGetFloat((int)2816, (FloatBuffer)currentColor);
                GL11.glBlendFunc((int)770, (int)771);
                if (color == null) {
                    GL11.glColor4f((float)boundsColor_Group.getRed(), (float)boundsColor_Group.getGreen(), (float)boundsColor_Group.getBlue(), (float)0.05f);
                } else {
                    GL11.glColor4f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
                }
                BoundingBox box = (BoundingBox)bounds;
                Tuple3f boxSize = box.getSize();
                GL11.glTranslatef((float)box.getCenterX(), (float)box.getCenterY(), (float)box.getCenterZ());
                GL11.glDepthMask((boolean)false);
                GL11.glColor4f((float)boundsColor_Group.getRed(), (float)boundsColor_Group.getGreen(), (float)boundsColor_Group.getBlue(), (float)0.1f);
                GL11.glEnable((int)3042);
                BoundsAtomPeer.drawCube(boxSize.getX(), boxSize.getY(), boxSize.getZ());
                GL11.glDepthMask((boolean)true);
                tmpIntBuffer.clear();
                GL11.glGetInteger((int)2849, (IntBuffer)tmpIntBuffer);
                int LINE_WIDTH = tmpIntBuffer.get();
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GL11.glPolygonMode((int)1032, (int)6913);
                GL11.glLineWidth((float)3.0f);
                GL11.glDisable((int)3042);
                BoundsAtomPeer.drawCube(boxSize.getX(), boxSize.getY(), boxSize.getZ());
                GL11.glLineWidth((float)LINE_WIDTH);
                GL11.glPolygonMode((int)1032, (int)6914);
                GL11.glTranslatef((float)(-box.getCenterX()), (float)(-box.getCenterY()), (float)(-box.getCenterZ()));
                GL11.glColor4f((float)currentColor.get(), (float)currentColor.get(), (float)currentColor.get(), (float)currentColor.get());
                if (isBlended) {
                    GL11.glEnable((int)3042);
                } else {
                    GL11.glDisable((int)3042);
                }
                if (isAlphaTest) {
                    GL11.glEnable((int)3008);
                } else {
                    GL11.glDisable((int)3008);
                }
                statesCache.blendingEnabled = isBlended;
                statesCache.alphaTestEnabled = isAlphaTest;
                GL11.glDepthMask((boolean)statesCache.depthWriteMask);
                break;
            }
        }
        if (oldTex1D) {
            GL11.glEnable((int)3552);
        }
        if (oldTex2D) {
            GL11.glEnable((int)3553);
        }
        if (oldTex3D) {
            GL11.glEnable((int)32879);
        }
        if (oldTexCM) {
            GL11.glEnable((int)34067);
        }
        statesCache.texture1DEnabled[statesCache.currentServerTextureUnit] = oldTex1D;
        statesCache.texture2DEnabled[statesCache.currentServerTextureUnit] = oldTex2D;
        statesCache.texture3DEnabled[statesCache.currentServerTextureUnit] = oldTex3D;
        statesCache.textureCMEnabled[statesCache.currentServerTextureUnit] = oldTexCM;
        tmpPlaneBuffer.clear();
        tmpPlaneBuffer.put(0, oldTexEnvColor[0]);
        tmpPlaneBuffer.put(1, oldTexEnvColor[1]);
        tmpPlaneBuffer.put(2, oldTexEnvColor[2]);
        tmpPlaneBuffer.put(3, oldTexEnvColor[3]);
        GL11.glTexEnv((int)8960, (int)8705, (FloatBuffer)tmpPlaneBuffer);
        GL11.glTexEnvi((int)8960, (int)8704, (int)oldTexEnvMode);
        return 0;
    }

    @Override
    public int renderAtom(RenderAtom<?> atom, Object glObj, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        if (renderMode != RenderPeer.RenderMode.NORMAL) {
            return 0;
        }
        OpenGLStatesCache statesCache = renderPeer.getStatesCache();
        if (!statesCache.enabled || statesCache.colorMaterialEnabled) {
            GL11.glDisable((int)2903);
            statesCache.colorMaterialEnabled = false;
        }
        if (!statesCache.enabled || statesCache.lightingEnabled) {
            GL11.glDisable((int)2896);
            statesCache.lightingEnabled = false;
        }
        ShapeAtomPeer.setMatrix(view, Transform3D.IDENTITY, false, true);
        Object bounds = ((Node)atom.getNode()).getBounds().getType() == BoundsType.AABB ? boundingBox : boundingSphere;
        bounds.set(((Node)atom.getNode()).getBounds());
        bounds.transform(((Node)atom.getNode()).getWorldTransform().getMatrix4f());
        if (atom.getNode() instanceof TransformGroup) {
            TEMP_MAT.set(((TransformGroup)atom.getNode()).getTransform().getMatrix4f());
            TEMP_MAT.invert();
            bounds.transform(TEMP_MAT);
        }
        return BoundsAtomPeer.drawBounds((Bounds)bounds, boundsColor_Shape, renderPeer.getStatesCache());
    }
}

