/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.impl.awt.AWTCursorConverter;
import org.jagatoo.input.impl.mixed.AWTJInputInputDeviceFactory;
import org.jagatoo.input.render.Cursor;
import org.jagatoo.input.render.InputSourceWindow;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.PixelFormat;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.RenderPass;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.render.lwjgl.CanvasPeerImplBase;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanvasPeerImplAWT
extends CanvasPeerImplBase {
    private Frame window;
    private ContextGLCanvas glCanvas;
    private int left = 0;
    private int top = 0;
    private long lastKnownFrameId = -1L;
    private boolean closeRequested = false;
    private boolean isRendering = false;
    private boolean displayModeChanged = false;
    private AWTJInputInputDeviceFactory inputDeviceFactory = null;

    public AWTJInputInputDeviceFactory getInputDeviceFactory(InputSystem inputSystem) {
        if (this.inputDeviceFactory == null) {
            this.inputDeviceFactory = new AWTJInputInputDeviceFactory((InputSourceWindow)this, inputSystem.getEventQueue());
        }
        return this.inputDeviceFactory;
    }

    public final ContextGLCanvas getDrawable() {
        return this.glCanvas;
    }

    public void refreshCursor(Mouse mouse) {
        if (this.getCursor() == null) {
            this.glCanvas.setCursor(AWTCursorConverter.HIDDEN_CURSOR);
        } else if (this.getCursor() == Cursor.DEFAULT_CURSOR) {
            this.glCanvas.setCursor(java.awt.Cursor.getDefaultCursor());
        } else {
            AWTCursorConverter.convertCursor((Cursor)this.getCursor());
            this.glCanvas.setCursor((java.awt.Cursor)this.getCursor().getCursorObject());
        }
    }

    public final boolean receivesInputEvents() {
        return this.glCanvas.hasFocus();
    }

    public CanvasPeerImplAWT(Object owner, org.xith3d.render.config.DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, int depthBufferSize) {
        super(displayMode, fullscreen, vsync, fsaa, depthBufferSize);
        if (owner == null) {
            String message = "The " + this.getClass().getSimpleName() + " must be used with an owner (integrated into an AWT/Swing environment).";
            X3DLog.error(message);
            throw new Error(message);
        }
        assert (displayMode != null);
        displayMode = this.getDisplayMode();
        try {
            System.setProperty("org.xith3d.render.lwjgl.displayGLInfos", String.valueOf(false));
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        try {
            this.glCanvas = new ContextGLCanvas(new PixelFormat(0, depthBufferSize, 8, fsaa.getIntValue()));
            this.setVSyncEnabled(vsync);
            this.glCanvas.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
            this.glCanvas.setFocusable(true);
            this.glCanvas.requestFocus();
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new Error(t.getMessage(), t);
        }
        if (owner == null) {
            this.window = new Frame("Xith3D (LWJGL)");
            this.window.setLayout(null);
            if (fullscreen.isFullscreen()) {
                this.window.setBackground(Color.BLACK);
            }
            this.window.setUndecorated(fullscreen != DisplayMode.FullscreenMode.WINDOWED);
            this.window.setSize(displayMode.getWidth(), displayMode.getHeight());
            this.window.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    CanvasPeerImplAWT.this.closeRequested = true;
                }
            });
            boolean exclusive = fullscreen.isFullscreen() && displayMode.getNativeMode() != null;
            this.window.add((Component)((Object)this.glCanvas));
            this.window.setVisible(true);
            if (!exclusive) {
                Dimension frameSize;
                Thread.yield();
                if (!fullscreen.isFullscreen()) {
                    Insets insets = this.window.getInsets();
                    this.glCanvas.setLocation(insets.left, insets.top);
                    frameSize = new Dimension(displayMode.getWidth() + insets.left + insets.right, displayMode.getHeight() + insets.top + insets.bottom);
                    this.window.setSize(frameSize);
                } else {
                    frameSize = new Dimension(displayMode.getWidth(), displayMode.getHeight());
                }
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Point upperLeft = new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
                this.window.setLocation(upperLeft);
            } else {
                java.awt.DisplayMode awtMode = (java.awt.DisplayMode)displayMode.getNativeMode();
                GraphicsDevice graphDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                graphDev.setFullScreenWindow(this.window);
                graphDev.setDisplayMode(awtMode);
            }
        } else {
            this.glCanvas.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
            ((Container)owner).add((Component)((Object)this.glCanvas));
        }
        Thread.yield();
        if (owner == null) {
            this.window.setResizable(false);
            Dimension size = this.window.getSize();
            this.window.setSize(size.width - 2, size.height - 2);
        }
    }

    @Override
    public OpenGLLayer getType() {
        return OpenGLLayer.LWJGL_AWT;
    }

    @Override
    protected final Class<?> getExpectedNativeDisplayModeClass() {
        return java.awt.DisplayMode.class;
    }

    @Override
    protected void applyVSync() {
        this.glCanvas.setVSyncEnabled(this.isVSyncEnabled());
    }

    @Override
    public void setVSyncEnabled(boolean vsync) {
        super.setVSyncEnabled(vsync);
        this.vsyncSwitched = true;
    }

    @Override
    public final Frame getWindow() {
        return this.window;
    }

    public final AWTGLCanvas getComponent() {
        return this.glCanvas;
    }

    @Override
    public void setIcon(URL iconResource) throws IOException {
        assert (this.window instanceof Frame) : "Window isn't a Frame";
        this.window.setIconImage(ImageIO.read(iconResource));
    }

    @Override
    public final void setTitle(String title) {
        this.window.setTitle(title);
    }

    @Override
    public final String getTitle() {
        return this.window.getTitle();
    }

    @Override
    public final boolean setLocation(int x, int y) {
        if (this.window.getLocation().x != x || this.window.getLocation().y != y) {
            this.window.setLocation(x, y);
            this.left = x;
            this.top = y;
            return true;
        }
        return false;
    }

    @Override
    public final int getLeft() {
        return this.left;
    }

    @Override
    public final int getTop() {
        return this.top;
    }

    @Override
    public final boolean setSize(int width, int height) {
        if (this.glCanvas.getSize().width != width || this.glCanvas.getSize().height != height) {
            this.glCanvas.setSize(width, height);
            if (this.getWindow() != null) {
                Insets insets = this.getWindow().getInsets();
                this.glCanvas.setLocation(insets.left, insets.top);
                Dimension frameSize = new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
                this.getWindow().setSize(frameSize);
            }
            return true;
        }
        return false;
    }

    @Override
    public final int getWidth() {
        return this.glCanvas.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.glCanvas.getHeight();
    }

    @Override
    protected boolean setDisplayModeImpl(org.xith3d.render.config.DisplayMode displayMode) {
        boolean result = true;
        this.displayModeChanged = true;
        return true;
    }

    @Override
    public void setGamma(float gamma, float brightness, float contrast) {
        super.setGamma(gamma, brightness, contrast);
        try {
            Display.setDisplayConfiguration((float)gamma, (float)brightness, (float)contrast);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final boolean isRendering() {
        return this.isRendering;
    }

    @Override
    protected Thread makeCurrent() {
        return Thread.currentThread();
    }

    @Override
    public void beforeThreadChanged() {
        if (this.renderingThread != null || this.getRenderedFrames() == 0L) {
            this.renderingThread = null;
        }
    }

    @Override
    protected Object initRenderingImpl(View view, List<RenderPass> renderPasses, boolean layeredMode, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        if (this.displayModeChanged) {
            try {
                Display.setDisplayMode((DisplayMode)this.getNativeDisplayMode());
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
            this.displayModeChanged = false;
        }
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"CanvasPeerImpl::render");
        this.glCanvas.repaint(view, renderPasses, layeredMode, frameId, nanoTime, nanoStep, pickRequest);
        Object result = this.glCanvas.pickResult;
        this.glCanvas.pickResult = null;
        ProfileTimer.endProfile();
        return result;
    }

    @Override
    public void destroy() {
        if (this.window != null) {
            this.window.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContextGLCanvas
    extends AWTGLCanvas {
        private static final long serialVersionUID = 521768945921758405L;
        private View view;
        private List<RenderPass> renderPasses;
        private boolean layeredMode;
        private long frameId;
        private long nanoTime;
        private long nanoStep;
        private PickRequest pickRequest;
        private Object pickResult;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void initGL() {
            Object object = CanvasPeerImplAWT.this.getRenderLock();
            synchronized (object) {
                CanvasPeerImplAWT.this.isRendering = true;
                CanvasPeerImplAWT.this.clear();
                try {
                    CanvasPeerImplAWT.this.init();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                CanvasPeerImplAWT.this.isRendering = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintGL() {
            if (!CanvasPeerImplAWT.this.isInitialized()) {
                return;
            }
            Object object = CanvasPeerImplAWT.this.getRenderLock();
            synchronized (object) {
                CanvasPeerImplAWT.this.isRendering = true;
                if (CanvasPeerImplAWT.this.closeRequested) {
                    CanvasPeerImplAWT.this.closeRequested = false;
                    CanvasPeerImplAWT.this.fireClosingEvent();
                }
                if (this.frameId < 0L || this.frameId <= CanvasPeerImplAWT.this.lastKnownFrameId) {
                    CanvasPeerImplAWT.this.isRendering = false;
                    return;
                }
                CanvasPeerImplAWT.this.lastKnownFrameId = this.frameId;
                this.pickResult = CanvasPeerImplAWT.this.doRender(this.view, this.renderPasses, this.layeredMode, this.frameId, this.nanoTime, this.nanoStep, this.pickRequest);
                try {
                    this.swapBuffers();
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                }
                CanvasPeerImplAWT.this.isRendering = false;
            }
        }

        public void repaint(View view, List<RenderPass> renderPasses, boolean layeredMode, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
            this.view = view;
            this.renderPasses = renderPasses;
            this.layeredMode = layeredMode;
            this.frameId = frameId;
            this.nanoTime = nanoTime;
            this.nanoStep = nanoStep;
            this.pickRequest = pickRequest;
            this.pickResult = null;
            this.repaint();
        }

        public ContextGLCanvas(PixelFormat pixelFormat) throws LWJGLException {
            super(pixelFormat);
            this.frameId = -1L;
            this.nanoTime = 0L;
            this.nanoStep = -1L;
        }
    }
}

